/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.app.ActivityManager;
import android.content.Context;
import android.hardware.Camera;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import com.bytedance.realx.base.RXLogging;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.webrtc.Camera1Enumerator;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.CameraSession;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.ContextUtils;
import org.webrtc.Histogram;
import org.webrtc.NV21Buffer;
import org.webrtc.Size;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.TextureBufferImpl;
import org.webrtc.VideoFrame;

class Camera1Session
implements CameraSession,
Camera.FaceDetectionListener {
    private static final String TAG = "Camera1Session";
    private static final int NUMBER_OF_CAPTURE_BUFFERS = 3;
    private static int sMinFramerate;
    private static final Histogram camera1StartTimeMsHistogram;
    private static final Histogram camera1StopTimeMsHistogram;
    private static final Histogram camera1ResolutionHistogram;
    private final Handler cameraThreadHandler;
    private final CameraSession.Events events;
    private final boolean captureToTexture;
    private final Context applicationContext;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final int cameraId;
    private final Camera camera;
    private final Camera.CameraInfo info;
    private final CameraEnumerationAndroid.CaptureFormat captureFormat;
    private final long constructionTimeNs;
    private final int scaleWidth;
    private final int scaleHeight;
    private final SensorManager sensorManager;
    private final Sensor gravitySensor;
    private int gravityOrientation = 0;
    private final SensorEventListener gravityEventListener = new SensorEventListener(){

        public void onSensorChanged(SensorEvent event) {
            float absY;
            float x = event.values[0];
            float y = event.values[1];
            float absX = Math.abs(x);
            if ((double)Math.abs(absX - (absY = Math.abs(y))) < 4.0) {
                return;
            }
            if (absX >= absY) {
                if (x >= 0.0f) {
                    Camera1Session.this.gravityOrientation = CameraSession.UIDeviceOrientation.LandscapeRight.value();
                } else {
                    Camera1Session.this.gravityOrientation = CameraSession.UIDeviceOrientation.LandscapeLeft.value();
                }
            } else if (y >= 0.0f) {
                Camera1Session.this.gravityOrientation = CameraSession.UIDeviceOrientation.Portrait.value();
            } else {
                Camera1Session.this.gravityOrientation = CameraSession.UIDeviceOrientation.PortraitUpsideDown.value();
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };
    private boolean mEnableFollowGravity = false;
    private SessionState state;
    private boolean firstFrameReported;
    private int mLastDisplayRotation;
    private int mLastValidDisplayRotation;
    private int mDisplayRotationCheckCounter;
    private CameraVideoCapturer.ORIENTATION_MODE mOrientation = CameraVideoCapturer.ORIENTATION_MODE.ORIENTATION_MODE_ADAPTIVE;
    private boolean isDesktopMode;
    private boolean mEnableFaceAE;
    private boolean mFaceDetectStarted;

    public static void create(CameraSession.CreateSessionCallback callback, CameraSession.Events events, boolean captureToTexture, boolean isDesktopMode, Context applicationContext, SurfaceTextureHelper surfaceTextureHelper, int cameraId, int width, int height, int framerate, boolean faceae, boolean followGravity) {
        CameraEnumerationAndroid.CaptureFormat captureFormat;
        Camera camera;
        long constructionTimeNs = System.nanoTime();
        RXLogging.w(TAG, "Open camera " + cameraId + " brand:" + Build.BRAND + ", modle:" + Build.MODEL + ", width:" + width + ", height:" + height + ", framerate:" + framerate);
        events.onCameraOpening();
        try {
            camera = Camera.open((int)cameraId);
        }
        catch (RuntimeException e) {
            callback.onFailure(CameraSession.FailureType.ERROR, e.getMessage());
            return;
        }
        if (camera == null) {
            callback.onFailure(CameraSession.FailureType.ERROR, "android.hardware.Camera.open returned null for camera id = " + cameraId);
            return;
        }
        try {
            camera.setPreviewTexture(surfaceTextureHelper.getSurfaceTexture());
        }
        catch (IOException | RuntimeException e) {
            camera.release();
            callback.onFailure(CameraSession.FailureType.ERROR, e.getMessage());
            return;
        }
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        try {
            Camera.Parameters parameters = camera.getParameters();
            captureFormat = Camera1Session.findClosestCaptureFormat(parameters, width, height, framerate);
            Size pictureSize = Camera1Session.findClosestPictureSize(parameters, width, height);
            events.onCameraConfig(pictureSize.width, pictureSize.height, captureFormat.framerate);
            sMinFramerate = captureFormat.framerate.min / 1000;
            Camera1Session.updateCameraParameters(camera, parameters, captureFormat, pictureSize, captureToTexture);
        }
        catch (RuntimeException e) {
            camera.release();
            callback.onFailure(CameraSession.FailureType.ERROR, e.getMessage());
            return;
        }
        if (!captureToTexture) {
            int frameSize = captureFormat.frameSize();
            for (int i = 0; i < 3; ++i) {
                ByteBuffer buffer = ByteBuffer.allocateDirect(frameSize);
                camera.addCallbackBuffer(buffer.array());
            }
        }
        camera.setDisplayOrientation(0);
        callback.onDone(new Camera1Session(events, captureToTexture, isDesktopMode, applicationContext, surfaceTextureHelper, cameraId, camera, info, captureFormat, constructionTimeNs, width, height, faceae, followGravity));
    }

    private static void updateCameraParameters(Camera camera, Camera.Parameters parameters, CameraEnumerationAndroid.CaptureFormat captureFormat, Size pictureSize, boolean captureToTexture) {
        List focusModes = parameters.getSupportedFocusModes();
        parameters.setPreviewFpsRange(captureFormat.framerate.min, captureFormat.framerate.max);
        parameters.setPreviewSize(captureFormat.width, captureFormat.height);
        if (!Build.MODEL.equalsIgnoreCase("PEGM00") && !Build.MODEL.equalsIgnoreCase("PEGT00")) {
            parameters.setPictureSize(pictureSize.width, pictureSize.height);
        } else {
            Log.d((String)TAG, (String)("updateCameraParameters: ignore pic size for model:" + Build.MODEL));
        }
        if (!captureToTexture) {
            parameters.setPreviewFormat(captureFormat.imageFormat);
        }
        if (parameters.isVideoStabilizationSupported()) {
            parameters.setVideoStabilization(true);
        }
        if (focusModes.contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        }
        camera.setParameters(parameters);
    }

    @Override
    public void setOrientationMode(CameraVideoCapturer.ORIENTATION_MODE orientation) {
        this.mOrientation = orientation;
    }

    @Override
    public int enableFollowGravity(boolean enable) {
        if (this.gravitySensor == null || this.sensorManager == null) {
            return -1;
        }
        if (enable) {
            this.sensorManager.registerListener(this.gravityEventListener, this.gravitySensor, 2);
            this.mEnableFollowGravity = true;
        } else {
            this.sensorManager.registerListener(null, this.gravitySensor, 2);
            this.mEnableFollowGravity = false;
        }
        return 0;
    }

    @Override
    public int getDeviceOrientation() {
        if (!this.mEnableFollowGravity) {
            return CameraSession.getDeviceUIOrientation(ContextUtils.getApplicationContext());
        }
        return this.gravityOrientation;
    }

    private static CameraEnumerationAndroid.CaptureFormat findClosestCaptureFormat(Camera.Parameters parameters, int width, int height, int framerate) {
        CameraEnumerationAndroid.CaptureFormat.FramerateRange fpsRange;
        String MODEL_OPPO_RENO5 = "PEGM00";
        if (parameters.getSupportedPreviewFpsRange() == null) {
            RXLogging.e(TAG, "camera parameters is null!");
            return null;
        }
        List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> supportedFramerates = Camera1Enumerator.convertFramerates(parameters.getSupportedPreviewFpsRange());
        RXLogging.w(TAG, "Available fps ranges: " + supportedFramerates);
        if (Build.MODEL.equalsIgnoreCase("PEGM00") && framerate == 15) {
            fpsRange = new CameraEnumerationAndroid.CaptureFormat.FramerateRange(15000, 20000);
            RXLogging.w(TAG, "unsupported framerate for special device found, hardcode framerange to:" + fpsRange.toString());
        } else {
            fpsRange = CameraEnumerationAndroid.getClosestSupportedFramerateRange(supportedFramerates, framerate);
        }
        RXLogging.w(TAG, "selected fps range :" + fpsRange.toString());
        if (parameters == null) {
            RXLogging.e(TAG, "camera parameters is null!");
            return null;
        }
        Size previewSize = CameraEnumerationAndroid.getClosestSupportedSize(Camera1Enumerator.convertSizes(parameters.getSupportedPreviewSizes()), width, height);
        CameraEnumerationAndroid.reportCameraResolution(camera1ResolutionHistogram, previewSize);
        RXLogging.w(TAG, "selected preview size" + previewSize.toString());
        return new CameraEnumerationAndroid.CaptureFormat(previewSize.width, previewSize.height, fpsRange);
    }

    private static Size findClosestPictureSize(Camera.Parameters parameters, int width, int height) {
        if (parameters == null || parameters.getSupportedPictureSizes() == null) {
            RXLogging.e(TAG, "camera parameters is null!");
            return null;
        }
        return CameraEnumerationAndroid.getClosestSupportedSize(Camera1Enumerator.convertSizes(parameters.getSupportedPictureSizes()), width, height);
    }

    private Camera1Session(CameraSession.Events events, boolean captureToTexture, boolean isDesktopMode, Context applicationContext, SurfaceTextureHelper surfaceTextureHelper, int cameraId, Camera camera, Camera.CameraInfo info, CameraEnumerationAndroid.CaptureFormat captureFormat, long constructionTimeNs, int width, int height, boolean faceae, boolean followGravity) {
        RXLogging.w(TAG, "Create new camera1 session on camera " + cameraId);
        this.cameraThreadHandler = new Handler();
        this.events = events;
        this.captureToTexture = captureToTexture;
        this.isDesktopMode = isDesktopMode;
        this.applicationContext = applicationContext;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = cameraId;
        this.camera = camera;
        this.info = info;
        this.captureFormat = captureFormat;
        this.constructionTimeNs = constructionTimeNs;
        this.scaleWidth = width;
        this.scaleHeight = height;
        this.mEnableFaceAE = faceae;
        this.sensorManager = (SensorManager)applicationContext.getSystemService("sensor");
        this.gravitySensor = this.sensorManager.getDefaultSensor(9);
        this.mEnableFollowGravity = followGravity;
        surfaceTextureHelper.setTextureSize(captureFormat.width, captureFormat.height);
        this.startCapturing();
    }

    @Override
    public void stop() {
        RXLogging.w(TAG, "Stop camera1 session on camera " + this.cameraId);
        this.checkIsOnCameraThread();
        if (this.state != SessionState.STOPPED) {
            long stopStartTime = System.nanoTime();
            this.stopInternal();
            int stopTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - stopStartTime);
            camera1StopTimeMsHistogram.addSample(stopTimeMs);
        }
    }

    @Override
    public boolean isCameraTorchSupported() {
        this.checkIsOnCameraThread();
        if (this.applicationContext != null) {
            return this.applicationContext.getPackageManager().hasSystemFeature("android.hardware.camera.flash");
        }
        return false;
    }

    public void onFaceDetection(Camera.Face[] faces, Camera camera) {
        Log.d((String)TAG, (String)("onFaceDetection: face count=" + faces.length));
    }

    @Override
    public void turnOnFlashLight() {
        RXLogging.w(TAG, "turn on flash light camera1, cameraId:" + this.cameraId);
        this.checkIsOnCameraThread();
        if (this.info.facing == 1) {
            RXLogging.w(TAG, "front camera not support flash light");
            return;
        }
        if (this.state != SessionState.STOPPED) {
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setFlashMode("torch");
            this.camera.setParameters(parameters);
        }
    }

    @Override
    public void turnOffFlashLight() {
        RXLogging.w(TAG, "turn on flash light camera1, cameraId:" + this.cameraId);
        this.checkIsOnCameraThread();
        if (this.info.facing == 1) {
            RXLogging.w(TAG, "front camera not support flash light");
            return;
        }
        if (this.state != SessionState.STOPPED) {
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setFlashMode("off");
            this.camera.setParameters(parameters);
        }
    }

    @Override
    public boolean isCameraZoomSupported() {
        RXLogging.w(TAG, "turn on flash light camera1, cameraId:" + this.cameraId);
        this.checkIsOnCameraThread();
        if (this.state != SessionState.STOPPED) {
            Camera.Parameters parameters = this.camera.getParameters();
            return parameters.isZoomSupported() || parameters.isSmoothZoomSupported();
        }
        return false;
    }

    @Override
    public int setCameraZoomRatio(float zoom) {
        RXLogging.w(TAG, "turn on flash light camera1, cameraId:" + this.cameraId);
        this.checkIsOnCameraThread();
        int result = -1;
        if (this.state != SessionState.STOPPED) {
            Camera.Parameters parameters = this.camera.getParameters();
            if (this.isCameraZoomSupported()) {
                int realZoom = (int)Math.min((float)parameters.getMaxZoom(), zoom);
                if (parameters.isSmoothZoomSupported()) {
                    this.camera.startSmoothZoom(realZoom);
                    result = 0;
                } else {
                    parameters.setZoom(realZoom);
                    this.camera.setParameters(parameters);
                    result = 0;
                }
            }
        }
        return result;
    }

    @Override
    public float getCameraZoomMaxRatio() {
        RXLogging.w(TAG, "turn on flash light camera1, cameraId:" + this.cameraId);
        this.checkIsOnCameraThread();
        float result = 1.0f;
        if (this.state != SessionState.STOPPED && this.isCameraZoomSupported()) {
            Camera.Parameters parameters = this.camera.getParameters();
            result = parameters.getMaxZoom();
        }
        return result;
    }

    private void startCapturing() {
        RXLogging.w(TAG, "Start capturing");
        this.checkIsOnCameraThread();
        this.state = SessionState.RUNNING;
        this.camera.setErrorCallback(new Camera.ErrorCallback(){

            public void onError(int error, Camera camera) {
                String errorMessage = error == 100 ? "CAMERA_ERROR_SERVER_DIED" : (error == 2 ? "CAMERA_ERROR_EVICTED" : (error == 1 ? "CAMERA_ERROR_UNKNOWN" : "Camera error: " + error));
                RXLogging.e(Camera1Session.TAG, errorMessage);
                Camera1Session.this.stopInternal();
                Camera1Session.this.events.onCameraError(Camera1Session.this, errorMessage);
            }
        });
        if (this.captureToTexture) {
            this.listenForTextureFrames();
        } else {
            this.listenForBytebufferFrames();
        }
        try {
            this.camera.startPreview();
            if (this.mEnableFaceAE) {
                this.camera.setFaceDetectionListener((Camera.FaceDetectionListener)this);
                this.camera.startFaceDetection();
                this.mFaceDetectStarted = true;
            }
            if (this.mEnableFollowGravity) {
                this.enableFollowGravity(true);
            }
        }
        catch (RuntimeException e) {
            this.stopInternal();
            this.events.onCameraError(this, e.getMessage());
        }
    }

    private void stopInternal() {
        RXLogging.w(TAG, "Stop internal");
        this.checkIsOnCameraThread();
        if (this.state == SessionState.STOPPED) {
            RXLogging.w(TAG, "Camera is already stopped");
            return;
        }
        this.state = SessionState.STOPPED;
        this.surfaceTextureHelper.stopListening();
        try {
            if (this.mFaceDetectStarted) {
                this.camera.stopFaceDetection();
            }
            this.camera.stopPreview();
            if (this.mEnableFollowGravity) {
                this.enableFollowGravity(false);
            }
            if (this.captureToTexture) {
                this.camera.setPreviewTexture(null);
            }
            this.camera.release();
            this.events.onCameraClosed(this);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        catch (Error error) {
            error.printStackTrace();
        }
        RXLogging.w(TAG, "Stop done");
    }

    private void listenForTextureFrames() {
        this.surfaceTextureHelper.startListening(frame -> {
            this.checkIsOnCameraThread();
            if (this.state != SessionState.RUNNING) {
                RXLogging.w(TAG, "Texture frame captured but camera is no longer running.");
                return;
            }
            if (!this.firstFrameReported) {
                int startTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.constructionTimeNs);
                camera1StartTimeMsHistogram.addSample(startTimeMs);
                this.firstFrameReported = true;
            }
            VideoFrame.Buffer buffer = this.scaleWidth != 0 && this.scaleHeight != 0 && (this.captureFormat.width != this.scaleWidth || this.captureFormat.height != this.scaleHeight) ? ((float)this.captureFormat.width / (float)this.captureFormat.height > (float)this.scaleWidth / (float)this.scaleHeight ? frame.getBuffer().cropAndScale((int)((float)this.captureFormat.width - (float)this.scaleWidth / (float)this.scaleHeight * (float)this.captureFormat.height) / 2, 0, (int)((float)this.scaleWidth / (float)this.scaleHeight * (float)this.captureFormat.height), this.captureFormat.height, this.scaleWidth, this.scaleHeight) : frame.getBuffer().cropAndScale(0, (int)((float)this.captureFormat.height - (float)this.scaleHeight / (float)this.scaleWidth * (float)this.captureFormat.width) / 2, this.captureFormat.width, (int)((float)this.scaleHeight / (float)this.scaleWidth * (float)this.captureFormat.width), this.scaleWidth, this.scaleHeight)) : frame.getBuffer().cropAndScale(0, 0, (int)((float)this.scaleWidth / (float)this.scaleHeight * (float)this.captureFormat.height), this.captureFormat.height, this.scaleWidth, this.scaleHeight);
            if (buffer == null) {
                RXLogging.e(TAG, "cropandscale return null buffer");
                return;
            }
            int orientation = 90;
            if (this.mEnableFollowGravity) {
                orientation = this.getGravityOrientation();
            } else {
                orientation = this.getFrameOrientation();
                this.gravityOrientation = CameraSession.getDeviceUIOrientation(this.applicationContext);
            }
            VideoFrame modifiedFrame = new VideoFrame((VideoFrame.Buffer)CameraSession.createTextureBufferWithModifiedTransformMatrix((TextureBufferImpl)buffer, this.info.facing == 1, 0), orientation, frame.getTimestampNs(), this.info.facing == 1);
            buffer.release();
            this.events.onFrameCaptured(this, modifiedFrame);
            modifiedFrame.release();
        });
    }

    private void listenForBytebufferFrames() {
        this.camera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

            public void onPreviewFrame(byte[] data, Camera callbackCamera) {
                Camera1Session.this.checkIsOnCameraThread();
                if (callbackCamera != Camera1Session.this.camera) {
                    RXLogging.e(Camera1Session.TAG, "Callback from a different camera. This should never happen.");
                    return;
                }
                if (Camera1Session.this.state != SessionState.RUNNING) {
                    RXLogging.w(Camera1Session.TAG, "Bytebuffer frame captured but camera is no longer running.");
                    return;
                }
                long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
                if (!Camera1Session.this.firstFrameReported) {
                    int startTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - Camera1Session.this.constructionTimeNs);
                    camera1StartTimeMsHistogram.addSample(startTimeMs);
                    Camera1Session.this.firstFrameReported = true;
                }
                NV21Buffer frameBuffer = new NV21Buffer(data, ((Camera1Session)Camera1Session.this).captureFormat.width, ((Camera1Session)Camera1Session.this).captureFormat.height, () -> Camera1Session.this.cameraThreadHandler.post(() -> {
                    if (Camera1Session.this.state == SessionState.RUNNING) {
                        Camera1Session.this.camera.addCallbackBuffer(data);
                    }
                }));
                int rotation = 90;
                if (Camera1Session.this.mEnableFollowGravity) {
                    rotation = Camera1Session.this.getGravityOrientation();
                } else {
                    rotation = Camera1Session.this.getFrameOrientation();
                    Camera1Session.this.gravityOrientation = CameraSession.getDeviceUIOrientation(Camera1Session.this.applicationContext);
                }
                VideoFrame frame = new VideoFrame((VideoFrame.Buffer)frameBuffer, rotation, captureTimeNs, ((Camera1Session)Camera1Session.this).info.facing == 1);
                Camera1Session.this.events.onFrameCaptured(Camera1Session.this, frame);
                frame.release();
            }
        });
    }

    private int getGravityOrientation() {
        int rotation = this.gravityOrientation;
        if (this.info.facing == 1) {
            rotation = 360 - rotation;
        }
        return (this.info.orientation + rotation) % 360;
    }

    private int getFrameOrientation() {
        int rotation = CameraSession.getDeviceUIOrientation(this.applicationContext);
        int validRotation = this.mLastValidDisplayRotation;
        if (this.mDisplayRotationCheckCounter > 0) {
            --this.mDisplayRotationCheckCounter;
            validRotation = this.mLastValidDisplayRotation;
        } else if (this.mDisplayRotationCheckCounter == 0) {
            validRotation = !Camera1Session.isInForeground(this.applicationContext) ? this.mLastValidDisplayRotation : rotation;
            this.mDisplayRotationCheckCounter = -1;
        } else if (rotation != this.mLastDisplayRotation) {
            this.mDisplayRotationCheckCounter = sMinFramerate > 0 ? sMinFramerate : 5;
        }
        this.mLastDisplayRotation = rotation;
        this.mLastValidDisplayRotation = validRotation;
        rotation = this.info.facing == 0 ? validRotation : 360 - validRotation;
        return (this.info.orientation + rotation) % 360;
    }

    private static boolean isInForeground(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        String packageName = context.getPackageName();
        List appProcesses = am.getRunningAppProcesses();
        if (appProcesses == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if ((!appProcess.processName.equals(packageName) || appProcess.importance != 100) && appProcess.importance != 125) continue;
            return true;
        }
        return false;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    static {
        camera1StartTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera1.StartTimeMs", 1, 10000, 50);
        camera1StopTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera1.StopTimeMs", 1, 10000, 50);
        camera1ResolutionHistogram = Histogram.createEnumeration("WebRTC.Android.Camera1.Resolution", CameraEnumerationAndroid.COMMON_RESOLUTIONS.size());
    }

    private static enum SessionState {
        RUNNING,
        STOPPED;

    }
}

