/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Parcelable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import org.webrtc.ContextUtils;
import org.webrtc.ScreenAudioCaptureAndroidManager;
import org.webrtc.ScreenCaptureAndroidManager;

public class RXScreenCaptureService
extends Service {
    private static final String DATA = "DATA";
    private static final String ACTION = "ACTION";
    public static final String KEY_LARGE_ICON = "largei";
    public static final String KEY_SMALL_ICON = "largei";
    public static final String KEY_LAUNCH_ACTIVITY = "activity";
    public static final String KEY_RESULT_DATA = "PermissionResult";
    public static final String KEY_CONTENT_TEXT = "contentText";
    public static final String KEY_WIDTH = "w";
    public static final String KEY_HEIGHT = "h";
    public static final String KEY_IFRAMERATE = "if";
    public static final String KEY_MIN_FRAMERATE = "minfr";
    public static final String KEY_INDEX = "i";
    public static final String KEY_HASHCODE = "hc";
    public static final int COMMAND_INVALID = -1;
    public static final int COMMAND_LAUNCH = 0;
    public static final int COMMAND_START = 1;
    public static final int COMMAND_STOP = 2;
    public static final int COMMAND_CHANGE_CAPTURE_FORMAT = 3;
    public static final int COMMAND_ON_FRAME = 4;
    public static final int COMMAND_DISPOSE = 5;
    public static final int COMMAND_AUDIO_START = 6;
    public static final int COMMAND_AUDIO_STOP = 7;
    public static final int COMMAND_AUDIO_DISPOSE = 8;
    public static final int COMMAND_STOP_SERVICE = 9;
    int mLargeIcon = -1;
    int mSmallIcon = -1;
    String mLaunchActivity;
    String mContentText;
    private HandlerThread mHandlerThread;
    private Handler mHandler;
    private MediaProjectionManager mMediaProjectionManager;
    private Intent mPermissionReulstData;
    private MediaProjection mMediaProjection;

    public static Intent getServiceIntent(Context context, int command, Intent data) {
        Intent intent = new Intent(context, RXScreenCaptureService.class);
        intent.putExtra(ACTION, command);
        if (data != null) {
            intent.putExtra(DATA, (Parcelable)data);
        }
        return intent;
    }

    private static int getCommand(Intent intent) {
        if (intent == null) {
            return -1;
        }
        return intent.getIntExtra(ACTION, -1);
    }

    private static Intent getData(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Intent)intent.getParcelableExtra(DATA);
    }

    public void onCreate() {
        super.onCreate();
        this.mHandlerThread = new HandlerThread("RXScreenCaptureService");
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        switch (RXScreenCaptureService.getCommand(intent)) {
            case 0: {
                this.startLaunch(intent);
                break;
            }
            case 1: {
                this.startCapture(intent);
                break;
            }
            case 2: {
                this.stopCapture(intent);
                break;
            }
            case 3: {
                this.changeCaptureFormat(intent);
                break;
            }
            case 5: {
                this.dispose();
                break;
            }
            case 6: {
                this.startAudioCapture();
                break;
            }
            case 7: {
                this.stopAudioCapture();
                break;
            }
            case 8: {
                this.audioDispose();
                break;
            }
            case 9: {
                this.stop();
                break;
            }
        }
        return super.onStartCommand(intent, flags, startId);
    }

    @RequiresApi(api=16)
    private void startLaunch(Intent intent) {
        Intent data = RXScreenCaptureService.getData(intent);
        if (null == data) {
            return;
        }
        this.mLargeIcon = data.getIntExtra("largei", -1);
        this.mSmallIcon = data.getIntExtra("largei", -1);
        this.mLaunchActivity = data.getStringExtra(KEY_LAUNCH_ACTIVITY);
        this.mContentText = data.getStringExtra(KEY_CONTENT_TEXT);
        if (TextUtils.isEmpty((CharSequence)this.mLaunchActivity) || this.mLargeIcon == -1 && this.mSmallIcon == -1) {
            return;
        }
        if (this.mSmallIcon == -1) {
            this.mSmallIcon = this.mLargeIcon;
        }
        if (this.mLargeIcon == -1) {
            this.mLargeIcon = this.mSmallIcon;
        }
        this.mPermissionReulstData = (Intent)data.getParcelableExtra(KEY_RESULT_DATA);
        this.createNotificationChannel();
    }

    private void startCapture(Intent intent) {
        Intent data = RXScreenCaptureService.getData(intent);
        if (null == data) {
            return;
        }
        this.createOrGetMediaProjection();
        int width = data.getIntExtra(KEY_WIDTH, 0);
        int height = data.getIntExtra(KEY_HEIGHT, 0);
        int ignoredFramerate = data.getIntExtra(KEY_IFRAMERATE, 0);
        int min_framerate = data.getIntExtra(KEY_MIN_FRAMERATE, 0);
        this.mHandler.post(() -> ScreenCaptureAndroidManager.INSTANCE().startCapture(width, height, ignoredFramerate, min_framerate, this.mMediaProjection));
    }

    private void stopCapture(Intent intent) {
        Intent data = RXScreenCaptureService.getData(intent);
        if (null == data) {
            return;
        }
        int hashCode = data.getIntExtra(KEY_HASHCODE, 0);
        this.mHandler.post(() -> ScreenCaptureAndroidManager.INSTANCE().stopCapture(hashCode));
    }

    private void changeCaptureFormat(Intent intent) {
        Intent data = RXScreenCaptureService.getData(intent);
        if (null == data) {
            return;
        }
        int width = data.getIntExtra(KEY_WIDTH, 0);
        int height = data.getIntExtra(KEY_HEIGHT, 0);
        int ignoredFramerate = data.getIntExtra(KEY_IFRAMERATE, 0);
        this.mHandler.post(() -> ScreenCaptureAndroidManager.INSTANCE().changeCaptureFormat(width, height, ignoredFramerate));
    }

    private void dispose() {
        this.mHandler.post(() -> ScreenCaptureAndroidManager.INSTANCE().dispose());
    }

    private void startAudioCapture() {
        this.createOrGetMediaProjection();
        this.mHandler.post(() -> ScreenAudioCaptureAndroidManager.INSTANCE().startAudioCapture(this.mMediaProjection));
    }

    private void stopAudioCapture() {
        this.mHandler.post(() -> ScreenAudioCaptureAndroidManager.INSTANCE().stopAudioCapture());
    }

    private void audioDispose() {
        this.mHandler.post(() -> ScreenAudioCaptureAndroidManager.INSTANCE().dispose());
    }

    @RequiresApi(api=21)
    private void stop() {
        this.mHandler.post(() -> {
            this.stopMediaProjection();
            this.stopForeground(true);
            this.stopSelf();
        });
    }

    @RequiresApi(api=21)
    private void stopMediaProjection() {
        if (this.mMediaProjection != null) {
            this.mMediaProjection.stop();
            this.mMediaProjection = null;
        }
    }

    private void createOrGetMediaProjection() {
        Context context = ContextUtils.getApplicationContext();
        if (this.mMediaProjection == null) {
            if (this.mMediaProjectionManager == null && context != null) {
                this.mMediaProjectionManager = (MediaProjectionManager)context.getSystemService("media_projection");
            }
            if (this.mMediaProjectionManager != null) {
                this.mMediaProjection = this.mMediaProjectionManager.getMediaProjection(-1, this.mPermissionReulstData);
            }
        }
    }

    @RequiresApi(api=16)
    private void createNotificationChannel() {
        Class<?> mainClazz = null;
        try {
            mainClazz = Class.forName(this.mLaunchActivity);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (mainClazz == null) {
            return;
        }
        Notification.Builder builder = new Notification.Builder(this.getApplicationContext());
        Intent nfIntent = new Intent((Context)this, mainClazz);
        builder.setContentIntent(PendingIntent.getActivity((Context)this, (int)0, (Intent)nfIntent, (int)(Build.VERSION.SDK_INT > 30 ? 0xC000000 : 0x8000000))).setLargeIcon(BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.mLargeIcon)).setSmallIcon(this.mSmallIcon).setContentText((CharSequence)this.mContentText).setWhen(System.currentTimeMillis());
        if (Build.VERSION.SDK_INT >= 26) {
            builder.setChannelId("notification_id");
        }
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
            NotificationChannel channel = new NotificationChannel("notification_id", (CharSequence)"notification_name", 2);
            notificationManager.createNotificationChannel(channel);
        }
        Notification notification = builder.build();
        notification.defaults = 1;
        this.startForeground(110, notification);
    }
}

