/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.support.annotation.Nullable;
import java.util.concurrent.atomic.AtomicInteger;
import org.webrtc.RefCounted;

public class RefCountDelegate
implements RefCounted {
    private final AtomicInteger refCount = new AtomicInteger(1);
    @Nullable
    private final Runnable releaseCallback;

    public RefCountDelegate(@Nullable Runnable releaseCallback) {
        this.releaseCallback = releaseCallback;
    }

    @Override
    public void retain() {
        this.refCount.incrementAndGet();
    }

    @Override
    public void release() {
        if (this.refCount.decrementAndGet() == 0 && this.releaseCallback != null) {
            this.releaseCallback.run();
        }
    }
}

