/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttuploader;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class AWSV4Auth {
    private static Mac mMac;
    private static MessageDigest mMessageDigest;
    private static String MAC_ALGORITHM;
    private String accessKeyID;
    private String secretAccessKey;
    private String regionName;
    private String serviceName;
    private String httpMethodName;
    private String canonicalURI;
    private TreeMap<String, String> queryParameters;
    private TreeMap<String, String> awsHeaders;
    private boolean awsHeadersHasTimestamp = false;
    private String payload;
    private boolean debug = false;
    private final String HMACAlgorithm = "HMAC-SHA256";
    private final String aws4Request = "request";
    private final String AWSAmzDateKey = "x-date";
    private String strSignedHeader;
    private String xAmzDate;
    private String currentDate;
    protected static final char[] hexArray;

    private AWSV4Auth() {
    }

    private AWSV4Auth(Builder builder) {
        this.accessKeyID = builder.accessKeyID;
        this.secretAccessKey = builder.secretAccessKey;
        this.regionName = builder.regionName;
        this.serviceName = builder.serviceName;
        this.httpMethodName = builder.httpMethodName;
        this.canonicalURI = builder.canonicalURI;
        this.queryParameters = builder.queryParameters;
        this.awsHeaders = builder.awsHeaders;
        this.payload = builder.payload;
        this.debug = builder.debug;
        if (this.awsHeaders == null) {
            this.awsHeaders = new TreeMap();
        }
        this.xAmzDate = this.findTimestampFromHeaderCaseInsensitive();
        if (this.xAmzDate == null) {
            this.xAmzDate = this.getTimeStamp();
            this.awsHeaders.put("x-date", this.xAmzDate);
        } else {
            this.awsHeadersHasTimestamp = true;
        }
        this.currentDate = this.getDateFromTimeStamp(this.xAmzDate);
    }

    private String prepareCanonicalRequest() {
        StringBuilder canonicalURL = new StringBuilder("");
        canonicalURL.append(this.httpMethodName).append("\n");
        this.canonicalURI = this.canonicalURI == null || this.canonicalURI.trim().isEmpty() ? "/" : this.canonicalURI;
        canonicalURL.append(this.canonicalURI).append("\n");
        StringBuilder queryString = new StringBuilder("");
        if (this.queryParameters != null && !this.queryParameters.isEmpty()) {
            for (Map.Entry<String, String> entrySet : this.queryParameters.entrySet()) {
                String key = entrySet.getKey();
                String string = entrySet.getValue();
                queryString.append(key).append("=").append(this.encodeParameter(string)).append("&");
            }
            queryString.deleteCharAt(queryString.lastIndexOf("&"));
            queryString.append("\n");
        } else {
            queryString.append("\n");
        }
        canonicalURL.append((CharSequence)queryString);
        StringBuilder signedHeaders = new StringBuilder("");
        if (this.awsHeaders != null && !this.awsHeaders.isEmpty()) {
            String value;
            String key;
            TreeMap<String, String> canonialHeader = new TreeMap<String, String>();
            for (Map.Entry<String, String> entry : this.awsHeaders.entrySet()) {
                key = entry.getKey().toLowerCase();
                value = entry.getValue().trim();
                canonialHeader.put(key, value);
            }
            for (Map.Entry<String, String> entry : canonialHeader.entrySet()) {
                key = entry.getKey().toLowerCase();
                value = entry.getValue().trim();
                signedHeaders.append(key).append(";");
                canonicalURL.append(key).append(":").append(value).append("\n");
            }
            canonicalURL.append("\n");
        } else {
            canonicalURL.append("\n");
        }
        this.strSignedHeader = signedHeaders.substring(0, signedHeaders.length() - 1);
        canonicalURL.append(this.strSignedHeader).append("\n");
        this.payload = this.payload == null ? "" : this.payload;
        canonicalURL.append(this.generateHex(this.payload));
        if (this.debug) {
            System.out.println("##Canonical Request:\n" + canonicalURL.toString());
        }
        return canonicalURL.toString();
    }

    private String prepareStringToSign(String canonicalURL) {
        String stringToSign = "";
        stringToSign = "HMAC-SHA256\n";
        stringToSign = stringToSign + this.xAmzDate + "\n";
        stringToSign = stringToSign + this.currentDate + "/" + this.regionName + "/" + this.serviceName + "/" + "request" + "\n";
        stringToSign = stringToSign + this.generateHex(canonicalURL);
        if (this.debug) {
            System.out.println("##String to sign:\n" + stringToSign);
        }
        return stringToSign;
    }

    private String calculateSignature(String stringToSign) {
        try {
            byte[] signatureKey = this.getSignatureKey(this.secretAccessKey, this.currentDate, this.regionName, this.serviceName);
            byte[] signature = this.HmacSHA256(signatureKey, stringToSign);
            String strHexSignature = this.bytesToHex(signature);
            return strHexSignature;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Map<String, String> getHeaders() {
        String canonicalURL = this.prepareCanonicalRequest();
        String stringToSign = this.prepareStringToSign(canonicalURL);
        String signature = this.calculateSignature(stringToSign);
        if (signature != null) {
            HashMap<String, String> header = new HashMap<String, String>(0);
            for (Map.Entry<String, String> entry : this.awsHeaders.entrySet()) {
                header.put(entry.getKey(), entry.getValue());
            }
            header.put("Authorization", this.buildAuthorizationString(signature));
            if (this.debug) {
                System.out.println("##Signature:\n" + signature);
                System.out.println("##Header:");
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    System.out.println(entry.getKey() + " = " + entry.getValue());
                }
                System.out.println("================================");
            }
            return header;
        }
        if (this.debug) {
            System.out.println("##Signature:\n" + signature);
        }
        return null;
    }

    private String buildAuthorizationString(String strSignature) {
        return "HMAC-SHA256 Credential=" + this.accessKeyID + "/" + this.currentDate + "/" + this.regionName + "/" + this.serviceName + "/" + "request" + ",SignedHeaders=" + this.strSignedHeader + ",Signature=" + strSignature;
    }

    private String generateHex(String data) {
        try {
            mMessageDigest.update(data.getBytes("UTF-8"));
            byte[] digest = mMessageDigest.digest();
            return String.format("%064x", new BigInteger(1, digest));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private byte[] HmacSHA256(byte[] key, String data) throws Exception {
        mMac.init(new SecretKeySpec(key, MAC_ALGORITHM));
        return mMac.doFinal(data.getBytes("UTF8"));
    }

    private byte[] getSignatureKey(String key, String date, String regionName, String serviceName) throws Exception {
        byte[] kSecret = key.getBytes("UTF8");
        byte[] kDate = this.HmacSHA256(kSecret, date);
        byte[] kRegion = this.HmacSHA256(kDate, regionName);
        byte[] kService = this.HmacSHA256(kRegion, serviceName);
        byte[] kSigning = this.HmacSHA256(kService, "request");
        return kSigning;
    }

    private String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars).toLowerCase();
    }

    private String getTimeStamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(new Date());
    }

    private String getDateFromTimeStamp(String timestamp) {
        if (timestamp == null || timestamp.length() < 8) {
            return null;
        }
        return timestamp.substring(0, 8);
    }

    private String encodeParameter(String param) {
        String out;
        try {
            out = URLEncoder.encode(param, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (Exception e) {
            out = param;
        }
        return out;
    }

    private String findTimestampFromHeaderCaseInsensitive() {
        if (this.awsHeaders != null && !this.awsHeaders.isEmpty()) {
            for (Map.Entry<String, String> entrySet : this.awsHeaders.entrySet()) {
                if (!entrySet.getKey().toLowerCase().equals("x-date")) continue;
                return entrySet.getValue();
            }
        }
        return null;
    }

    static {
        MAC_ALGORITHM = "HmacSHA256";
        try {
            mMac = Mac.getInstance(MAC_ALGORITHM);
            mMessageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        hexArray = "0123456789ABCDEF".toCharArray();
    }

    public static class Builder {
        private String accessKeyID;
        private String secretAccessKey;
        private String regionName;
        private String serviceName;
        private String httpMethodName;
        private String canonicalURI;
        private TreeMap<String, String> queryParameters;
        private TreeMap<String, String> awsHeaders;
        private String payload;
        private boolean debug = false;

        public Builder(String accessKeyID, String secretAccessKey) {
            this.accessKeyID = accessKeyID;
            this.secretAccessKey = secretAccessKey;
        }

        public Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder httpMethodName(String httpMethodName) {
            this.httpMethodName = httpMethodName;
            return this;
        }

        public Builder canonicalURI(String canonicalURI) {
            this.canonicalURI = canonicalURI;
            return this;
        }

        public Builder queryParameters(TreeMap<String, String> queryParameters) {
            this.queryParameters = queryParameters;
            return this;
        }

        public Builder awsHeaders(TreeMap<String, String> awsHeaders) {
            this.awsHeaders = awsHeaders;
            return this;
        }

        public Builder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public Builder debug() {
            this.debug = true;
            return this;
        }

        public AWSV4Auth build() {
            return new AWSV4Auth(this);
        }
    }
}

