/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttuploader;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.pandora.common.settings.ISettingsListener;
import com.pandora.common.settings.TTVideoSettingManager;
import com.ss.ttuploader.TTImageInfoTop;
import com.ss.ttuploader.TTImageUploaderConfig;
import com.ss.ttuploader.TTImageUploaderListenerTop;
import com.ss.ttuploader.TTLogUpload;
import com.ss.ttuploader.TTLogUploadTob;
import com.ss.ttuploader.TTUploadUtil;
import com.ss.ttuploader.UploadEventManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TTImageUploaderTop
implements Handler.Callback,
ISettingsListener {
    public static final int KeyIsVideoUploadDomain = 3;
    public static final int KeyIsUploadCookie = 4;
    public static final int KeyIsSliceRetryCount = 5;
    public static final int KeyIsFileRetryCount = 6;
    public static final int KeyIsSliceTimeout = 7;
    public static final int KeyIsSocketNum = 9;
    public static final int KeyIsMaxFailTime = 13;
    public static final int KeyIsServerParameter = 16;
    public static final int KeyIsEnableHttps = 19;
    public static final int KeyIsGetObjectId = 51;
    public static final int KeyIsObjectType = 54;
    public static final int KeyIsPolicyParams = 55;
    public static final int keyIsConfigString = 56;
    public static final int KeyIsSetTranTimeOutUnit = 64;
    public static final int KeyIsSetDeviceID = 66;
    public static final int KeyIsSetOpenBoe = 67;
    public static final int KeyIsSetTraceId = 69;
    public static final int KeyIsApplyAuth = 71;
    public static final int KeyIsCommitAuth = 72;
    public static final int KeyIsEncryptionInfo = 73;
    public static final int KeyIsOptionInfo = 75;
    public static final int KeyIsTemplateId = 76;
    public static final int KeyIsOpenTop = 77;
    public static final int KeyIsSpace = 78;
    public static final int KeyIsProcessActionTypeTop = 79;
    public static final int KeyIsSetImageX = 80;
    public static final int KeyIsAccessKey = 81;
    public static final int KeyIsSecretAccessKey = 82;
    public static final int KeyIsSessionToken = 83;
    public static final int KeyIsExpiredTime = 84;
    public static final int KeyIsRegionName = 85;
    public static final int KeyIsGetLog = 100;
    public static final int MsgIsComplete = 0;
    public static final int MsgIsUpdateProgress = 1;
    public static final int MsgIsFail = 2;
    public static final int MsgIsSingleImageComplete = 3;
    public static final int MsgIsSingleImageFail = 4;
    public static final int IsInit = 0;
    public static final int IsStart = 1;
    public static final int IsFail = 2;
    public static final int IsComplete = 3;
    public static final int IsStop = 4;
    public static final int IsClose = 5;
    private int mState = -1;
    private int mImageNum = 0;
    private static boolean IsErrored = false;
    private long mHandle;
    private long mSartTime;
    private long mEndTime;
    public static String imageHost = "vod.bytedanceapi.com";
    private Handler mHandler = null;
    private final ReentrantReadWriteLock.ReadLock mReadLock;
    private final ReentrantReadWriteLock.WriteLock mWriteLock;
    private final ReentrantReadWriteLock mReadWritedLock = new ReentrantReadWriteLock();
    private TTImageUploaderListenerTop mListener = null;
    private static final String TAG = "TTImageUploaderTop";
    public static String KEY_VOD_TOP_HOST = "byte_vod_host";
    public static String videoSettingKey = "com.video.ttvideosetting";
    private static Context mSettingContext;
    private TTLogUpload mTTLogUpload = new TTLogUploadTob();
    private SharedPreferences mSp;
    private Context mContext;

    private SharedPreferences getSharedPreferences(Context context) {
        return context.getSharedPreferences(videoSettingKey, 0);
    }

    public TTImageUploaderTop() throws Exception {
        try {
            this.mHandle = this._imageUploaderCreate(0, 1);
        }
        catch (Throwable e) {
            this.mHandle = 0L;
        }
        if (this.mHandle == 0L) {
            Log.v((String)"ttmn", (String)"create native uploader fail");
            throw new Exception("create native uploader fail");
        }
        this.mHandler = Looper.myLooper() != null ? new Handler((Handler.Callback)this) : new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        this.mReadLock = this.mReadWritedLock.readLock();
        this.mWriteLock = this.mReadWritedLock.writeLock();
        TTImageUploaderTop._imageUploaderSetIntValue(this.mHandle, 77, 1);
        this.mState = 0;
    }

    public static int setAppInfo(Context context, Map<String, Object> infoMap) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (infoMap != null && infoMap.size() > 0) {
            Log.d((String)TAG, (String)("setAppInfo:" + infoMap.toString()));
            if (infoMap != null && !infoMap.isEmpty()) {
                config.putAll(infoMap);
            }
        }
        imageHost = "vod.bytedanceapi.com";
        if (infoMap.containsKey("region")) {
            String region = (String)infoMap.get("region");
            imageHost = region.equalsIgnoreCase("cn-north-1") ? "vod.bytedanceapi.com" : (region.equalsIgnoreCase("us-east-1") ? "vod.us-east-1.bytedanceapi.com" : (region.equalsIgnoreCase("ap-singapore-1") ? "vod.ap-singapore-1.bytedanceapi.com" : "vod.bytedanceapi.com"));
        } else {
            return -1;
        }
        mSettingContext = context;
        return 1;
    }

    public static boolean isError() {
        return IsErrored;
    }

    public void setHandler(Handler handler) {
        this.mHandler = handler;
    }

    public void setListener(TTImageUploaderListenerTop listener) {
        this.mListener = listener;
    }

    public void onNotify(int what, long parameter, int code) {
        if (this.mState != 1) {
            return;
        }
        TTImageInfoTop info = null;
        String log = null;
        int fileIndex = (int)parameter;
        Object infoList = null;
        switch (what) {
            case 3: {
                this.mEndTime = System.currentTimeMillis();
                String uri = null;
                uri = TTImageUploaderTop._imageUploaderGetImageUri(this.mHandle, fileIndex);
                String metainfo = TTImageUploaderTop._imageUploaderGetImageMetaInfo(this.mHandle, fileIndex);
                String encryptInfo = TTImageUploaderTop._imageUploaderGetImageEncryptInfo(this.mHandle, fileIndex);
                info = new TTImageInfoTop(uri, parameter, fileIndex, metainfo, encryptInfo);
                break;
            }
            case 4: {
                info = new TTImageInfoTop(null, code, fileIndex, null, null);
                break;
            }
            case 0: {
                log = TTImageUploaderTop._imageUploaderGetStringValue(this.mHandle, 100);
                this.addLogToManager(log);
                this.mState = 3;
                break;
            }
            case 2: {
                log = TTImageUploaderTop._imageUploaderGetStringValue(this.mHandle, 100);
                this.addLogToManager(log);
                this.mState = 2;
                break;
            }
            case 1: {
                info = new TTImageInfoTop(null, code, fileIndex, null, null);
            }
        }
        Message msg = this.mHandler.obtainMessage();
        msg.what = what;
        msg.obj = info;
        msg.sendToTarget();
    }

    public void onLogInfo(int what, int code, String info) {
        if (this.mListener == null) {
            return;
        }
    }

    public boolean handleMessage(Message msg) {
        int what = msg.what;
        long parameter = 0L;
        if (this.mListener == null) {
            return true;
        }
        TTImageInfoTop info = (TTImageInfoTop)msg.obj;
        if (info != null) {
            parameter = info.mProgress;
        }
        this.mListener.onNotify(what, parameter, info);
        return true;
    }

    public void setUploadConfig(TTImageUploaderConfig config) {
        String configStr;
        String policyParamsStr;
        String optionInfoStr;
        if (config.mFilePathNames != null && config.mFilePathNames.length > 0 && config.mFileCount > 0) {
            TTImageUploaderTop._imageUploaderSetFilePath(this.mHandle, config.mFileCount, config.mFilePathNames);
        }
        if (config.mFileNames != null && config.mFileNames.length > 0) {
            TTImageUploaderTop._imageUploaderSetFileName(this.mHandle, config.mFileNames.length, config.mFileNames);
        }
        String topHost = imageHost;
        JSONArray topHosts = null;
        this.mContext = mSettingContext.getApplicationContext();
        this.mSp = this.getSharedPreferences(this.mContext);
        String hostStr = this.mSp.getString(KEY_VOD_TOP_HOST, null);
        try {
            if (!TextUtils.isEmpty((CharSequence)hostStr) && hostStr.length() != 0) {
                topHosts = new JSONArray(hostStr);
                Log.v((String)"ttmn", (String)String.format("hostStr:%s", hostStr));
            } else {
                JSONObject mSettings = TTVideoSettingManager.getSettingsJson();
                if (mSettings != null) {
                    Log.v((String)"ttmn", (String)String.format("mSettings:%s", mSettings.toString()));
                    try {
                        topHosts = new JSONArray(mSettings.getString("byte_vod_host"));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (topHosts != null && topHosts.length() > 0) {
            topHost = (String)topHosts.opt(0);
        }
        if (config.mImageHostName != null && !config.mImageHostName.isEmpty()) {
            Log.v((String)"ttmn", (String)String.format("mImageHostName:%s", config.mImageHostName));
            this.setStringValue(3, config.mImageHostName);
        } else {
            Log.v((String)"ttmn", (String)String.format("topHost:%s", topHost));
            this.setStringValue(3, topHost);
        }
        if (config.mServerParameter != null && !config.mServerParameter.isEmpty()) {
            this.setStringValue(16, config.mServerParameter);
        }
        if (config.mFileType != null && !config.mFileType.isEmpty()) {
            this.setStringValue(54, config.mFileType);
        }
        if (config.mUploadToken != null && !config.mUploadToken.isEmpty()) {
            byte[] decodeStringbytes = Base64.decode((byte[])config.mUploadToken.getBytes(), (int)2);
            String decodeString = new String(decodeStringbytes);
            try {
                JSONObject authJson = new JSONObject(decodeString);
                String applyAuth = authJson.getString("ApplyUploadToken");
                String commitAuht = authJson.getString("CommitUploadToken");
                if (applyAuth != null && !applyAuth.isEmpty()) {
                    this.setStringValue(71, applyAuth);
                }
                if (commitAuht != null && !commitAuht.isEmpty()) {
                    this.setStringValue(72, commitAuht);
                }
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"uploadToken is encode json error !!!");
                e.printStackTrace();
            }
        }
        if (config.mUploadCookie != null && !config.mUploadCookie.isEmpty()) {
            this.setStringValue(4, config.mUploadCookie);
        }
        if (config.mDeviceID > 0L) {
            TTImageUploaderTop._setInt64Value(this.mHandle, 66, config.mDeviceID);
        }
        if (config.mTraceID != null && !config.mTraceID.isEmpty()) {
            this.setStringValue(69, config.mTraceID);
        }
        if (config.mEnableBoe) {
            TTImageUploaderTop._imageUploaderSetIntValue(this.mHandle, 67, 1);
        } else {
            TTImageUploaderTop._imageUploaderSetIntValue(this.mHandle, 67, 0);
        }
        if (config.mSliceRetryCount > 0) {
            TTImageUploaderTop._imageUploaderSetIntValue(this.mHandle, 5, config.mSliceRetryCount);
        }
        if (config.mFileRetryCount > 0) {
            TTImageUploaderTop._imageUploaderSetIntValue(this.mHandle, 6, config.mFileRetryCount);
        }
        if (config.mSocketNum > 0) {
            TTImageUploaderTop._imageUploaderSetIntValue(this.mHandle, 9, config.mSocketNum);
        }
        if (config.mMaxFailTime > 0) {
            TTImageUploaderTop._imageUploaderSetIntValue(this.mHandle, 13, config.mMaxFailTime);
        }
        if (config.mEnableHttps) {
            TTImageUploaderTop._imageUploaderSetIntValue(this.mHandle, 19, 1);
        } else {
            TTImageUploaderTop._imageUploaderSetIntValue(this.mHandle, 19, 0);
        }
        if (config.mTranTimeout > 0) {
            TTImageUploaderTop._imageUploaderSetIntValue(this.mHandle, 64, config.mTranTimeout);
        }
        if (config.mSliceTimeout > 0) {
            TTImageUploaderTop._imageUploaderSetIntValue(this.mHandle, 7, config.mSliceTimeout);
        }
        TTImageUploaderTop._imageUploaderSetIntValue(this.mHandle, 79, config.mProcessAction);
        if (config.mOptionInfo != null && !config.mOptionInfo.isEmpty() && (optionInfoStr = TTUploadUtil.mapToString(config.mPolicyParams)) != null && !optionInfoStr.isEmpty()) {
            this.setStringValue(75, optionInfoStr);
        }
        if (config.mTemplateId != null && !config.mTemplateId.isEmpty()) {
            this.setStringValue(76, config.mTemplateId);
        }
        if (config.mPolicyParams != null && !config.mPolicyParams.isEmpty() && (policyParamsStr = TTUploadUtil.mapToString(config.mPolicyParams)) != null && !policyParamsStr.isEmpty()) {
            this.setStringValue(55, policyParamsStr);
        }
        if (config.mConfig != null && !config.mConfig.isEmpty() && (configStr = TTUploadUtil.mapToString(config.mConfig)) != null && !configStr.isEmpty()) {
            this.setStringValue(56, configStr);
        }
        if (config.mRegion != null && !config.mRegion.isEmpty()) {
            this.setStringValue(85, config.mRegion);
        }
        if (config.mAccessKeyId != null && !config.mAccessKeyId.isEmpty()) {
            this.setStringValue(81, config.mAccessKeyId);
        }
        if (config.mSecretAccessKey != null && !config.mSecretAccessKey.isEmpty()) {
            this.setStringValue(82, config.mSecretAccessKey);
        }
        if (config.mSessionToken != null && !config.mSessionToken.isEmpty()) {
            this.setStringValue(83, config.mSessionToken);
        }
        if (config.mSpace != null && !config.mSpace.isEmpty()) {
            this.setStringValue(78, config.mSpace);
        }
        if (config.mExpiredTime != null && !config.mExpiredTime.isEmpty()) {
            this.setStringValue(84, config.mExpiredTime);
        }
    }

    public void start() {
        this.mReadLock.lock();
        try {
            if (this.mHandle != 0L) {
                this.mState = 1;
                this.mSartTime = System.currentTimeMillis();
                TTImageUploaderTop._imageUploaderStart(this.mHandle);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public void stop() {
        this.mWriteLock.lock();
        try {
            if (this.mHandle != 0L) {
                String log = TTImageUploaderTop._imageUploaderStop(this.mHandle);
                this.addLogToManager(log);
                this.mState = 4;
            }
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    public void close() {
        this.mWriteLock.lock();
        try {
            if (this.mHandle != 0L) {
                TTImageUploaderTop._imageUploaderClose(this.mHandle);
                this.mHandle = 0L;
                this.mState = 5;
                this.mHandler.removeCallbacksAndMessages(null);
            }
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    public void addLogToManager(String log) {
        JSONObject jsonStr = null;
        try {
            jsonStr = new JSONObject(log);
        }
        catch (Exception e) {
            jsonStr = null;
        }
        if (jsonStr != null) {
            this.mTTLogUpload.onUploadLog("image_upload", jsonStr);
        }
        UploadEventManager.instance.addImageEvent(jsonStr);
    }

    public void setStringValue(int key, String value) {
        if (this.mHandle == 0L || value == null) {
            return;
        }
        TTImageUploaderTop._imageUploaderSetStringValue(this.mHandle, key, value);
    }

    public String getDeviceId() {
        return TTLogUploadTob.getDeviceID();
    }

    public void onUpdated(JSONObject jsonObject) {
        this.saveData(jsonObject);
    }

    public void saveData(JSONObject data) {
        if (data == null) {
            return;
        }
        JSONArray topHosts = data.optJSONArray(KEY_VOD_TOP_HOST);
        this.mContext = mSettingContext.getApplicationContext();
        this.mSp = this.getSharedPreferences(this.mContext);
        String hostStr = this.mSp.getString(KEY_VOD_TOP_HOST, null);
        if (!(topHosts == null || topHosts.length() <= 0 || hostStr != null && topHosts.toString().equals(hostStr))) {
            SharedPreferences.Editor editor = this.mSp.edit();
            editor.putString(KEY_VOD_TOP_HOST, topHosts.toString());
            editor.apply();
        }
    }

    private final native long _imageUploaderCreate(int var1, int var2);

    private static native void _imageUploaderSetStringValue(long var0, int var2, String var3);

    private static native void _imageUploaderSetFilePath(long var0, int var2, String[] var3);

    private static native void _imageUploaderSetFileName(long var0, int var2, String[] var3);

    private static native String _imageUploaderGetStringValue(long var0, int var2);

    private static native String _imageUploaderGetImageUri(long var0, int var2);

    private static native String _imageUploaderGetImageMetaInfo(long var0, int var2);

    private static native String _imageUploaderGetImageEncryptInfo(long var0, int var2);

    private static native void _imageUploaderSetIntValue(long var0, int var2, int var3);

    private static native void _imageUploaderClose(long var0);

    private static native void _imageUploaderStart(long var0);

    private static native String _imageUploaderStop(long var0);

    private static native void _setInt64Value(long var0, int var2, long var3);

    static {
        try {
            System.loadLibrary("ttvideouploader");
        }
        catch (Throwable e) {
            Log.v((String)"ttmn", (String)"loadLibrary err");
            IsErrored = true;
            e.printStackTrace();
        }
    }
}

