/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttuploader;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TTUploadResolver {
    private static final String TAG = "ttmj";
    private String mHostName;
    private boolean mRet = false;
    private Thread mThread = null;
    private String mError;
    private String[] mIPStr;
    private HostInfo mHostInfo;
    public static int HOST_MAX_CACHE_TIME = 600000;
    private static final int MAX_CACHED = 128;
    private static final Hashtable<String, HostInfo> mCacheHosts = new Hashtable();

    public void getAddressInfo(String hostname) {
        this.mHostName = hostname;
        if (hostname != null && hostname.length() >= 1 && !"".equals(hostname)) {
            if (TTUploadResolver.isIP(this.mHostName)) {
                this.mIPStr = new String[1];
                this.mIPStr[0] = this.mHostName;
                this.mRet = true;
            } else {
                this.mHostInfo = mCacheHosts.get(hostname);
                if (this.mHostInfo != null) {
                    if (this.mHostInfo.ip != null && System.currentTimeMillis() - this.mHostInfo.time < (long)HOST_MAX_CACHE_TIME) {
                        this.mIPStr = new String[1];
                        this.mIPStr[0] = this.mHostInfo.ip;
                        this.mRet = true;
                        return;
                    }
                    mCacheHosts.remove(hostname);
                    this.mHostInfo = null;
                }
                try {
                    this.mThread = new Thread(new ParserHost(this, this.mHostName));
                    this.mThread.start();
                }
                catch (Exception var3) {
                    this.mRet = true;
                    this.mError = var3.getMessage();
                }
            }
        } else {
            this.mRet = true;
        }
    }

    public int isSuccess() {
        return this.mRet ? (this.mIPStr != null && this.mIPStr[0] != null ? 1 : -1) : 0;
    }

    public String getAddress() {
        return this.mRet && this.mIPStr != null && this.mIPStr[0] != null ? this.mIPStr[0] : "parser host name: " + this.mHostName + " error.err msg:" + this.mError;
    }

    public void freeAddress() {
        if (this.mThread != null) {
            try {
                this.mThread.interrupt();
            }
            catch (Exception var2) {
                var2.printStackTrace();
            }
        }
    }

    static synchronized void putHostInfo(String host, HostInfo info) {
        long dropHostTime = System.currentTimeMillis();
        String key = null;
        HostInfo dropHostInfo = null;
        HostInfo cur = null;
        if (mCacheHosts.size() > 128) {
            Set<Map.Entry<String, HostInfo>> set = mCacheHosts.entrySet();
            Iterator<Map.Entry<String, HostInfo>> it = set.iterator();
            while (it.hasNext()) {
                cur = it.next().getValue();
                key = it.next().getKey();
                if (cur == null || cur.time >= dropHostTime) continue;
                dropHostInfo = cur;
                dropHostTime = cur.time;
            }
        }
        if (dropHostInfo != null && key != null) {
            mCacheHosts.remove(key);
        }
        mCacheHosts.put(host, info);
    }

    public static final boolean isIP(String addr) {
        if (addr.length() >= 7 && addr.length() <= 15) {
            String rexp = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
            Pattern pat = Pattern.compile(rexp);
            Matcher mat = pat.matcher(addr);
            boolean ipAddress = mat.find();
            return ipAddress;
        }
        return addr.charAt(0) == '[' && addr.charAt(addr.length() - 1) == ']';
    }

    static /* synthetic */ String[] access$202(TTUploadResolver x0, String[] x1) {
        x0.mIPStr = x1;
        return x1;
    }

    static class HostInfo {
        public String ip;
        public long time;

        HostInfo() {
        }
    }

    static class ParserHost
    implements Runnable {
        TTUploadResolver mResolver = null;
        String mHostName;

        public ParserHost(TTUploadResolver resolver, String hostName) {
            this.mResolver = resolver;
            this.mHostName = hostName;
        }

        @Override
        public void run() {
            InetAddress mAddress = null;
            try {
                mAddress = InetAddress.getByName(this.mHostName);
            }
            catch (UnknownHostException var4) {
                var4.printStackTrace();
                this.mResolver.mError = var4.getMessage();
            }
            this.mResolver.mRet = true;
            if (mAddress != null) {
                String strIP = mAddress.getHostAddress();
                TTUploadResolver.access$202(this.mResolver, new String[1]);
                ((TTUploadResolver)this.mResolver).mIPStr[0] = strIP;
                HostInfo hostInfo = new HostInfo();
                hostInfo.time = System.currentTimeMillis();
                hostInfo.ip = strIP;
                TTUploadResolver.putHostInfo(this.mHostName, hostInfo);
                hostInfo.time = System.currentTimeMillis();
            }
        }
    }
}

