/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttuploader;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.pandora.common.env.Env;
import com.pandora.common.settings.ISettingsListener;
import com.pandora.common.settings.TTVideoSettingManager;
import com.ss.ttuploader.AbstractListenner;
import com.ss.ttuploader.TTLogUpload;
import com.ss.ttuploader.TTLogUploadTob;
import com.ss.ttuploader.TTUploadUtil;
import com.ss.ttuploader.TTVideoInfoTop;
import com.ss.ttuploader.TTVideoUploaderConfigTop;
import com.ss.ttuploader.TTVideoUploaderListenerTop;
import com.ss.ttuploader.UploadEventManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TTVideoUploaderTop
implements Handler.Callback,
ISettingsListener {
    public static final int KeyIsPathName = 0;
    public static final int KeyIsVideoUploadDomain = 3;
    public static final int KeyIsUploadCookie = 4;
    public static final int KeyIsSliceRetryCount = 5;
    public static final int KeyIsFileRetryCount = 6;
    public static final int KeyIsSliceTimeout = 7;
    public static final int KeyIsSliceSize = 8;
    public static final int KeyIsSocketNum = 9;
    public static final int KeyIsGetVideoId = 10;
    public static final int KeyIsGetCoverUrI = 12;
    public static final int KeyIsMaxFailTime = 13;
    public static final int KeyIsServerParameter = 16;
    public static final int KeyIsEnableHttps = 19;
    public static final int KeyIsEnableKeepAlive = 20;
    public static final int KeyIsEnableExternDNS = 21;
    public static final int KeyIsAliveMaxFailTime = 22;
    public static final int KeyIsEnablePostMethod = 23;
    public static final int KeyIsTcpOpenTimeOutMilliSec = 24;
    public static final int KeyIsEnableFileTryHttps = 25;
    public static final int KeyIsEnableExternNet = 26;
    public static final int KeyIsObjectType = 54;
    public static final int KeyIsPolicyParams = 55;
    public static final int keyIsConfigString = 56;
    public static final int KeyIsSetTranTimeOutUnit = 64;
    public static final int KeyIsSetDeviceID = 66;
    public static final int KeyIsSetOpenBoe = 67;
    public static final int KeyIsSetTraceId = 69;
    public static final int KeyIsApplyAuth = 71;
    public static final int KeyIsCommitAuth = 72;
    public static final int KeyIsEncryptionInfo = 73;
    public static final int KeyIsOptionInfo = 75;
    public static final int KeyIsTemplateId = 76;
    public static final int KeyIsOpenTop = 77;
    public static final int KeyIsSpace = 78;
    public static final int KeyIsProcessActionTypeTop = 79;
    public static final int KeyIsAccessKey = 81;
    public static final int KeyIsSecretAccessKey = 82;
    public static final int KeyIsSessionToken = 83;
    public static final int KeyIsExpiredTime = 84;
    public static final int KeyIsRegionName = 85;
    public static final int KeyIsCallbackArgs = 86;
    public static final int KeyIsSourceInfo = 87;
    public static final int KeyIsGetLog = 100;
    public static final int KeyIsGetTosKey = 300;
    public static final int MsgIsComplete = 0;
    public static final int MsgIsUpdateProgress = 1;
    public static final int MsgIsFail = 2;
    public static final int MsgIsUpdateSetting = 3;
    private SharedPreferences mSp;
    private int mState = -1;
    public static final int IsInit = 0;
    public static final int IsStart = 1;
    public static final int IsFail = 2;
    public static final int IsComplete = 3;
    public static final int IsStop = 4;
    public static final int IsClose = 5;
    public static String videoHost = "vod.bytedanceapi.com";
    public JSONObject mSettings = null;
    private static final String TAG = "TTVideoUploaderTop";
    public static String KEY_VOD_TOP_HOST = "byte_vod_host";
    public static String videoSettingKey = "com.video.ttvideosetting";
    private static boolean IsErrored = false;
    private long mHandle;
    private Handler mHandler = null;
    private final ReentrantReadWriteLock.ReadLock mReadLock;
    private final ReentrantReadWriteLock.WriteLock mWriteLock;
    private TTVideoUploaderListenerTop mListener = null;
    private static Context mSettingContext;
    private TTLogUpload mTTVideoLogUpload = new TTLogUploadTob();
    private AbstractListenner mAbstractListener = null;
    private Context mContext;
    private final ReentrantReadWriteLock mReadWritedLock = new ReentrantReadWriteLock();

    private SharedPreferences getSharedPreferences(Context context) {
        return context.getSharedPreferences(videoSettingKey, 0);
    }

    public TTVideoUploaderTop() throws Exception {
        try {
            this.mHandle = this._create(0, 1);
        }
        catch (Throwable e) {
            this.mHandle = 0L;
        }
        if (this.mHandle == 0L) {
            throw new Exception("create native uploader fail");
        }
        this.mHandler = Looper.myLooper() != null ? new Handler((Handler.Callback)this) : new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        TTVideoUploaderTop._setIntValue(this.mHandle, 77, 1);
        this.mReadLock = this.mReadWritedLock.readLock();
        this.mWriteLock = this.mReadWritedLock.writeLock();
        this.mState = 0;
    }

    public static void setAppInfo(Context context, Map<String, Object> infoMap) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (infoMap != null && infoMap.size() > 0 && infoMap != null && !infoMap.isEmpty()) {
            config.putAll(infoMap);
        }
        videoHost = "vod.bytedanceapi.com";
        if (infoMap.containsKey("region")) {
            String region = (String)infoMap.get("region");
            if (region.equalsIgnoreCase("cn-north-1")) {
                videoHost = "vod.bytedanceapi.com";
            } else if (region.equalsIgnoreCase("us-east-1")) {
                videoHost = "vod.us-east-1.bytedanceapi.com";
            } else if (region.equalsIgnoreCase("ap-singapore-1")) {
                videoHost = "vod.ap-singapore-1.bytedanceapi.com";
            }
        }
        mSettingContext = context;
    }

    public static boolean isError() {
        return IsErrored;
    }

    public void setHandler(Handler handler) {
        this.mHandler = handler;
    }

    public void setListener(TTVideoUploaderListenerTop listener) {
        this.mListener = listener;
    }

    public void onNotify(int what, long parameter, int code) {
        if (this.mState != 1) {
            return;
        }
        TTVideoInfoTop info = null;
        String log = null;
        switch (what) {
            case 0: {
                String vid = TTVideoUploaderTop._getStringValue(this.mHandle, 10);
                String coverUri = TTVideoUploaderTop._getStringValue(this.mHandle, 12);
                String tosKey = TTVideoUploaderTop._getStringValue(this.mHandle, 300);
                String encryption = "";
                encryption = TTVideoUploaderTop._getStringValue(this.mHandle, 73);
                String callbackArgs = "";
                callbackArgs = TTVideoUploaderTop._getStringValue(this.mHandle, 86);
                String sourceInfo = "";
                sourceInfo = TTVideoUploaderTop._getStringValue(this.mHandle, 87);
                info = new TTVideoInfoTop(vid, coverUri, parameter, tosKey, encryption, callbackArgs, sourceInfo);
                log = TTVideoUploaderTop._getStringValue(this.mHandle, 100);
                this.addLogToManager(log);
                this.mState = 3;
                break;
            }
            case 2: {
                log = TTVideoUploaderTop._getStringValue(this.mHandle, 100);
                info = new TTVideoInfoTop(null, null, parameter, null, null, null, null);
                this.addLogToManager(log);
                this.mState = 2;
                break;
            }
            case 1: {
                info = new TTVideoInfoTop(null, null, parameter, null, null, null, null);
            }
        }
        Message msg = this.mHandler.obtainMessage();
        msg.what = what;
        msg.obj = info;
        msg.sendToTarget();
    }

    public void onLogInfo(int what, int code, String info) {
        if (this.mListener == null) {
            return;
        }
        this.mListener.onLog(what, code, info);
    }

    public boolean handleMessage(Message msg) {
        int what = msg.what;
        long parameter = 0L;
        if (this.mListener == null) {
            return true;
        }
        TTVideoInfoTop info = (TTVideoInfoTop)msg.obj;
        if (info != null) {
            parameter = info.mProgress;
        }
        this.mListener.onNotify(what, parameter, info);
        return true;
    }

    public void addLogToManager(String log) {
        JSONObject jsonStr = null;
        try {
            jsonStr = new JSONObject(log);
        }
        catch (Exception e) {
            jsonStr = null;
        }
        if (jsonStr != null && Env.getAppLogClient() != null) {
            Log.v((String)"ttmn", (String)"Env.getAppLogClient");
            try {
                jsonStr.put("module_id", 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Env.getAppLogClient().onUpload("video_upload", jsonStr);
        }
        Log.v((String)"ttmn", (String)log);
        UploadEventManager.instance.addEvent(jsonStr);
    }

    public void setUploadConfig(TTVideoUploaderConfigTop config) {
        String configStr;
        String policyParamsStr;
        String optionInfoStr;
        if (config.mFilePathName != null && !config.mFilePathName.isEmpty()) {
            this.setStringValue(0, config.mFilePathName);
        }
        String topHost = videoHost;
        JSONArray Hosts = null;
        this.mContext = mSettingContext.getApplicationContext();
        this.mSp = this.getSharedPreferences(this.mContext);
        String hostStr = this.mSp.getString(KEY_VOD_TOP_HOST, null);
        try {
            if (!TextUtils.isEmpty((CharSequence)hostStr) && hostStr.length() != 0) {
                Hosts = new JSONArray(hostStr);
                Log.v((String)"ttmn", (String)String.format("hostStr:%s", hostStr));
            } else {
                JSONObject mSettings = TTVideoSettingManager.getSettingsJson();
                if (mSettings != null) {
                    try {
                        Hosts = new JSONArray(mSettings.getString("byte_vod_host"));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (Hosts != null && Hosts.length() > 0) {
            topHost = (String)Hosts.opt(0);
        }
        Log.v((String)"ttmn", (String)String.format("topHost:%s", topHost));
        if (config.mVideoHostName != null && !config.mVideoHostName.isEmpty()) {
            topHost = config.mVideoHostName;
        }
        this.setStringValue(3, topHost);
        if (config.mUploadToken != null && !config.mUploadToken.isEmpty()) {
            byte[] decodeStringbytes = Base64.decode((byte[])config.mUploadToken.getBytes(), (int)2);
            String decodeString = new String(decodeStringbytes);
            try {
                JSONObject authJson = new JSONObject(decodeString);
                String applyAuth = authJson.getString("ApplyUploadToken");
                String commitAuht = authJson.getString("CommitUploadToken");
                if (applyAuth != null && !applyAuth.isEmpty()) {
                    this.setStringValue(71, applyAuth);
                }
                if (commitAuht != null && !commitAuht.isEmpty()) {
                    this.setStringValue(72, commitAuht);
                }
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"uploadToken is encode json error !!!");
                e.printStackTrace();
            }
        }
        if (config.mFileType != null && !config.mFileType.isEmpty()) {
            this.setStringValue(54, config.mFileType);
        }
        if (config.mUploadCookie != null && !config.mUploadCookie.isEmpty()) {
            this.setStringValue(4, config.mUploadCookie);
        }
        if (config.mServerParameter != null && !config.mServerParameter.isEmpty()) {
            this.setStringValue(16, config.mServerParameter);
        }
        if (config.mDeviceID > 0L) {
            TTVideoUploaderTop._setInt64Value(this.mHandle, 66, config.mDeviceID);
        }
        if (config.mTraceID != null && !config.mTraceID.isEmpty()) {
            this.setStringValue(69, config.mTraceID);
        }
        if (config.mSpace != null && !config.mSpace.isEmpty()) {
            this.setStringValue(78, config.mSpace);
        }
        if (config.mEnableBoe) {
            TTVideoUploaderTop._setIntValue(this.mHandle, 67, 1);
        } else {
            TTVideoUploaderTop._setIntValue(this.mHandle, 67, 0);
        }
        if (config.mSliceRetryCount > 0) {
            TTVideoUploaderTop._setIntValue(this.mHandle, 5, config.mSliceRetryCount);
        }
        if (config.mFileRetryCount > 0) {
            TTVideoUploaderTop._setIntValue(this.mHandle, 6, config.mFileRetryCount);
        }
        if (config.mSliceTimeout > 0) {
            TTVideoUploaderTop._setIntValue(this.mHandle, 7, config.mSliceTimeout);
        }
        if (config.mSliceSize > 0) {
            TTVideoUploaderTop._setIntValue(this.mHandle, 8, config.mSliceSize);
        }
        if (config.mSoucketNum > 0) {
            TTVideoUploaderTop._setIntValue(this.mHandle, 9, config.mSoucketNum);
        }
        if (config.mMaxFailTime > 0) {
            TTVideoUploaderTop._setIntValue(this.mHandle, 13, config.mMaxFailTime);
        }
        if (config.mEnableHttps) {
            TTVideoUploaderTop._setIntValue(this.mHandle, 19, 1);
        } else {
            TTVideoUploaderTop._setIntValue(this.mHandle, 19, 0);
        }
        if (config.mEnableKeepAlive) {
            TTVideoUploaderTop._setIntValue(this.mHandle, 20, 1);
        }
        if (config.mEnableExtrernDNS) {
            TTVideoUploaderTop._setIntValue(this.mHandle, 21, 1);
        }
        if (config.mAliveMaxFailTime > 0) {
            TTVideoUploaderTop._setIntValue(this.mHandle, 22, config.mAliveMaxFailTime);
        }
        if (config.mEnablePostMethod) {
            TTVideoUploaderTop._setIntValue(this.mHandle, 23, 1);
        } else {
            TTVideoUploaderTop._setIntValue(this.mHandle, 23, 0);
        }
        if (config.mTcpOpenTimeOutMissiSec > 0) {
            TTVideoUploaderTop._setIntValue(this.mHandle, 24, config.mTcpOpenTimeOutMissiSec);
        }
        if (config.mEnableFileTryHttps) {
            TTVideoUploaderTop._setIntValue(this.mHandle, 25, 1);
        } else {
            TTVideoUploaderTop._setIntValue(this.mHandle, 25, 0);
        }
        if (config.mTranTimeout > 0) {
            TTVideoUploaderTop._setIntValue(this.mHandle, 64, config.mTranTimeout);
        }
        TTVideoUploaderTop._setIntValue(this.mHandle, 79, config.mProcessAction);
        if (config.mOptionInfo != null && !config.mOptionInfo.isEmpty() && (optionInfoStr = TTUploadUtil.mapToString(config.mOptionInfo)) != null && !optionInfoStr.isEmpty()) {
            this.setStringValue(75, optionInfoStr);
        }
        if (config.mTemplateId != null && !config.mTemplateId.isEmpty()) {
            this.setStringValue(76, config.mTemplateId);
        }
        if (config.mPolicyParams != null && !config.mPolicyParams.isEmpty() && (policyParamsStr = TTUploadUtil.mapToString(config.mPolicyParams)) != null && !policyParamsStr.isEmpty()) {
            this.setStringValue(55, policyParamsStr);
        }
        if (config.mConfig != null && !config.mConfig.isEmpty() && (configStr = TTUploadUtil.mapToString(config.mConfig)) != null && !configStr.isEmpty()) {
            this.setStringValue(56, configStr);
        }
        if (config.mAccessKeyId != null && !config.mAccessKeyId.isEmpty()) {
            this.setStringValue(81, config.mAccessKeyId);
        }
        if (config.mSecretAccessKey != null && !config.mSecretAccessKey.isEmpty()) {
            this.setStringValue(82, config.mSecretAccessKey);
        }
        if (config.mSessionToken != null && !config.mSessionToken.isEmpty()) {
            this.setStringValue(83, config.mSessionToken);
        }
        if (config.mExpiredTime != null && !config.mExpiredTime.isEmpty()) {
            this.setStringValue(84, config.mExpiredTime);
        }
        if (config.mRegion != null && !config.mRegion.isEmpty()) {
            this.setStringValue(85, config.mRegion);
        }
        TTVideoUploaderTop._setPoster(this.mHandle, config.snapshotTime);
    }

    public void start() {
        this.mReadLock.lock();
        try {
            if (this.mHandle != 0L) {
                this.mState = 1;
                Log.v((String)"ttmn", (String)"real start upload");
                TTVideoUploaderTop._start(this.mHandle);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public void stop() {
        this.mWriteLock.lock();
        try {
            if (this.mHandle != 0L) {
                String log = TTVideoUploaderTop._stop(this.mHandle);
                this.addLogToManager(log);
                this.mState = 4;
            }
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    public void close() {
        this.mWriteLock.lock();
        try {
            if (this.mHandle != 0L) {
                TTVideoUploaderTop._close(this.mHandle);
                this.mHandle = 0L;
                this.mState = 5;
                this.mHandler.removeCallbacksAndMessages(null);
            }
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    public void setStringValue(int key, String value) {
        if (this.mHandle == 0L || value == null) {
            return;
        }
        TTVideoUploaderTop._setStringValue(this.mHandle, key, value);
    }

    public String getDeviceId() {
        if (Env.getAppLogClient() != null) {
            return Env.getAppLogClient().getDeviceID();
        }
        return "";
    }

    public void onUpdated(JSONObject jsonObject) {
        this.saveData(jsonObject);
    }

    public void saveData(JSONObject data) {
        if (data == null) {
            return;
        }
        JSONArray topHosts = data.optJSONArray(KEY_VOD_TOP_HOST);
        if (mSettingContext != null) {
            this.mContext = mSettingContext.getApplicationContext();
        }
        this.mSp = this.getSharedPreferences(this.mContext);
        String hostStr = this.mSp.getString(KEY_VOD_TOP_HOST, null);
        if (!(topHosts == null || topHosts.length() <= 0 || hostStr != null && topHosts.toString().equals(hostStr))) {
            SharedPreferences.Editor editor = this.mSp.edit();
            editor.putString(KEY_VOD_TOP_HOST, topHosts.toString());
            editor.apply();
        }
    }

    private final native long _create(int var1, int var2);

    private static native void _setStringValue(long var0, int var2, String var3);

    private static native String _getStringValue(long var0, int var2);

    private static native void _setPoster(long var0, float var2);

    private static native void _setIntValue(long var0, int var2, int var3);

    private static native void _setInt64Value(long var0, int var2, long var3);

    private static native void _close(long var0);

    private static native void _start(long var0);

    private static native String _stop(long var0);

    private static native void _setObject(long var0, int var2, Object var3);

    static {
        try {
            System.loadLibrary("ttvideouploader");
        }
        catch (Throwable e) {
            Log.v((String)"ttmn", (String)"loadLibrary err");
            IsErrored = true;
            e.printStackTrace();
        }
    }
}

