/*
 * Decompiled with CFR 0.152.
 */
package com.byteowls.jopencage.model;

import com.byteowls.jopencage.model.JOpenCageComponents;
import com.byteowls.jopencage.model.JOpenCageLatLng;
import com.byteowls.jopencage.model.JOpenCageLicence;
import com.byteowls.jopencage.model.JOpenCageRate;
import com.byteowls.jopencage.model.JOpenCageResult;
import com.byteowls.jopencage.model.JOpenCageStatus;
import com.byteowls.jopencage.model.JOpenCageStayInformed;
import com.byteowls.jopencage.model.JOpenCageTimestamp;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JOpenCageResponse {
    private String documentation;
    private List<JOpenCageLicence> licenses;
    private JOpenCageRate rate;
    private List<JOpenCageResult> results;
    private JOpenCageStatus status;
    @JsonProperty(value="stay_informed")
    private JOpenCageStayInformed stayInformed;
    private String thanks;
    private JOpenCageTimestamp timestamp;
    @JsonProperty(value="total_results")
    private int totalResults;

    public String getDocumentation() {
        return this.documentation;
    }

    public List<JOpenCageLicence> getLicenses() {
        return this.licenses;
    }

    public JOpenCageRate getRate() {
        return this.rate;
    }

    public List<JOpenCageResult> getResults() {
        return this.results;
    }

    public JOpenCageStatus getStatus() {
        return this.status;
    }

    public String getThanks() {
        return this.thanks;
    }

    public JOpenCageTimestamp getTimestamp() {
        return this.timestamp;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public void orderResultByConfidence() {
        Collections.sort(this.results);
        Collections.reverse(this.results);
    }

    public JOpenCageLatLng getFirstPosition() {
        if (this.results != null) {
            this.orderResultByConfidence();
            Iterator<JOpenCageResult> iterator = this.results.iterator();
            if (iterator.hasNext()) {
                JOpenCageResult r = iterator.next();
                return r.getGeometry();
            }
        }
        return null;
    }

    public JOpenCageComponents getFirstComponents() {
        if (this.results != null) {
            this.orderResultByConfidence();
            Iterator<JOpenCageResult> iterator = this.results.iterator();
            if (iterator.hasNext()) {
                JOpenCageResult r = iterator.next();
                return r.getComponents();
            }
        }
        return null;
    }
}

