/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.ark.runtime.model.completion.chat;

import com.byteplus.ark.runtime.model.completion.chat.ChatCompletionContentPart;
import com.byteplus.ark.runtime.model.completion.chat.ChatFunctionCall;
import com.byteplus.ark.runtime.model.completion.chat.ChatMessageRole;
import com.byteplus.ark.runtime.model.completion.chat.ChatToolCall;
import com.byteplus.ark.runtime.utils.Converter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ChatMessage {
    ChatMessageRole role;
    Object content;
    @JsonProperty(value="reasoning_content")
    String reasoningContent;
    private String name;
    @JsonProperty(value="function_call")
    ChatFunctionCall functionCall;
    @JsonProperty(value="tool_calls")
    List<ChatToolCall> toolCalls;
    @JsonProperty(value="tool_call_id")
    String toolCallId;

    public ChatMessageRole getRole() {
        return this.role;
    }

    public void setRole(ChatMessageRole role) {
        this.role = role;
    }

    public Object getContent() {
        return this.content;
    }

    public String stringContent() {
        return (String)String.class.cast(this.content);
    }

    public List<ChatCompletionContentPart> multiContent() {
        return Converter.castList(this.content, ChatCompletionContentPart.class);
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ChatFunctionCall getFunctionCall() {
        return this.functionCall;
    }

    public void setFunctionCall(ChatFunctionCall functionCall) {
        this.functionCall = functionCall;
    }

    public List<ChatToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public void setToolCalls(List<ChatToolCall> toolCalls) {
        this.toolCalls = toolCalls;
    }

    public String getToolCallId() {
        return this.toolCallId;
    }

    public void setToolCallId(String toolCallId) {
        this.toolCallId = toolCallId;
    }

    public String getReasoningContent() {
        return this.reasoningContent;
    }

    public void setReasoningContent(String reasoningContent) {
        this.reasoningContent = reasoningContent;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ChatMessage{role=" + (Object)((Object)this.role) + ", content=" + this.content + ", reasoningContent='" + this.reasoningContent + '\'' + ", name='" + this.name + '\'' + ", functionCall=" + this.functionCall + ", toolCalls=" + this.toolCalls + ", toolCallId='" + this.toolCallId + '\'' + '}';
    }

    public static class Builder {
        private ChatMessageRole role;
        private Object content;
        @JsonProperty(value="reasoning_content")
        private String reasoningContent;
        private String name;
        @JsonProperty(value="function_call")
        private ChatFunctionCall functionCall;
        @JsonProperty(value="tool_calls")
        private List<ChatToolCall> toolCalls;
        @JsonProperty(value="tool_call_id")
        private String toolCallId;

        public Builder role(ChatMessageRole role) {
            this.role = role;
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder multiContent(List<ChatCompletionContentPart> multiContent) {
            this.content = multiContent;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder functionCall(ChatFunctionCall functionCall) {
            this.functionCall = functionCall;
            return this;
        }

        public Builder toolCalls(List<ChatToolCall> toolCalls) {
            this.toolCalls = toolCalls;
            return this;
        }

        public Builder toolCallId(String toolCallId) {
            this.toolCallId = toolCallId;
            return this;
        }

        public Builder reasoningContent(String reasoningContent) {
            this.reasoningContent = reasoningContent;
            return this;
        }

        public ChatMessage build() {
            ChatMessage chatMessage = new ChatMessage();
            chatMessage.setRole(this.role);
            chatMessage.setContent(this.content);
            chatMessage.setReasoningContent(this.reasoningContent);
            chatMessage.setName(this.name);
            chatMessage.setFunctionCall(this.functionCall);
            chatMessage.setToolCalls(this.toolCalls);
            chatMessage.setToolCallId(this.toolCallId);
            return chatMessage;
        }
    }
}

