/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.ark.runtime.model.images.generation;

import com.byteplus.ark.runtime.model.images.generation.ImageDeserializer;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.List;

public class GenerateImagesRequest {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="prompt")
    private String prompt;
    @JsonProperty(value="image")
    @JsonDeserialize(using=ImageDeserializer.class)
    private List<String> image;
    @JsonProperty(value="response_format")
    private String responseFormat;
    @JsonProperty(value="seed")
    private Integer seed;
    @JsonProperty(value="guidance_scale")
    private Double guidanceScale;
    @JsonProperty(value="size")
    private String size;
    @JsonProperty(value="watermark")
    private Boolean watermark;
    @JsonProperty(value="optimize_prompt")
    private Boolean optimizePrompt;
    @JsonProperty(value="sequential_image_generation")
    private String sequentialImageGeneration;
    @JsonProperty(value="sequential_image_generation_options")
    private SequentialImageGenerationOptions sequentialImageGenerationOptions;
    @JsonProperty(value="stream")
    private Boolean stream;

    public GenerateImagesRequest() {
    }

    public GenerateImagesRequest(String model, String prompt, List<String> image, String responseFormat, Integer seed, Double guidanceScale, String size, Boolean watermark, String sequentialImageGeneration, SequentialImageGenerationOptions sequentialImageGenerationOptions, Boolean optimizePrompt, Boolean stream) {
        this.model = model;
        this.prompt = prompt;
        this.image = image;
        this.responseFormat = responseFormat;
        this.seed = seed;
        this.guidanceScale = guidanceScale;
        this.size = size;
        this.watermark = watermark;
        this.optimizePrompt = optimizePrompt;
        this.sequentialImageGeneration = sequentialImageGeneration;
        this.sequentialImageGenerationOptions = sequentialImageGenerationOptions;
        this.stream = stream;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public List<String> getImage() {
        return this.image;
    }

    public void setImage(List<String> image) {
        this.image = image;
    }

    public void setImage(String image) {
        this.image = image == null ? null : Collections.singletonList(image);
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(String responseFormat) {
        this.responseFormat = responseFormat;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public Double getGuidanceScale() {
        return this.guidanceScale;
    }

    public void setGuidanceScale(Double guidanceScale) {
        this.guidanceScale = guidanceScale;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public Boolean getWatermark() {
        return this.watermark;
    }

    public void setWatermark(Boolean watermark) {
        this.watermark = watermark;
    }

    public Boolean getOptimizePrompt() {
        return this.optimizePrompt;
    }

    public void setOptimizePrompt(Boolean optimizePrompt) {
        this.optimizePrompt = optimizePrompt;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public SequentialImageGenerationOptions getSequentialImageGenerationOptions() {
        return this.sequentialImageGenerationOptions;
    }

    public void setSequentialImageGenerationOptions(SequentialImageGenerationOptions sequentialImageGenerationOptions) {
        this.sequentialImageGenerationOptions = sequentialImageGenerationOptions;
    }

    public String getSequentialImageGeneration() {
        return this.sequentialImageGeneration;
    }

    public void setSequentialImageGeneration(String sequentialImageGeneration) {
        this.sequentialImageGeneration = sequentialImageGeneration;
    }

    public String toString() {
        return "GenerateImagesRequest{model='" + this.model + '\'' + ", prompt=" + this.prompt + ", image=" + this.image + ", responseFormat=" + this.responseFormat + ", seed=" + this.seed + ", guidanceScale=" + this.guidanceScale + ", size=" + this.size + ", watermark=" + this.watermark + ", optimizePrompt=" + this.optimizePrompt + ", stream=" + this.stream + ", sequentialImageGeneration=" + this.sequentialImageGeneration + ", sequentialImageGenerationOptions=" + this.sequentialImageGenerationOptions + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String model;
        private String prompt;
        @JsonDeserialize(using=ImageDeserializer.class)
        private List<String> image;
        private String responseFormat;
        private Integer seed;
        private Double guidanceScale;
        private String size;
        private Boolean watermark;
        private Boolean optimizePrompt;
        private String sequentialImageGeneration;
        private SequentialImageGenerationOptions sequentialImageGenerationOptions;
        private Boolean stream;

        private Builder() {
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder image(List<String> image) {
            this.image = image;
            return this;
        }

        public Builder image(String image) {
            this.image = image == null ? null : Collections.singletonList(image);
            return this;
        }

        public Builder responseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public Builder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public Builder guidanceScale(Double guidanceScale) {
            this.guidanceScale = guidanceScale;
            return this;
        }

        public Builder size(String size) {
            this.size = size;
            return this;
        }

        public Builder watermark(Boolean watermark) {
            this.watermark = watermark;
            return this;
        }

        public Builder optimizePrompt(Boolean optimizePrompt) {
            this.optimizePrompt = optimizePrompt;
            return this;
        }

        public Builder sequentialImageGeneration(String sequentialImageGeneration) {
            this.sequentialImageGeneration = sequentialImageGeneration;
            return this;
        }

        public Builder sequentialImageGenerationOptions(SequentialImageGenerationOptions sequentialImageGenerationOptions) {
            this.sequentialImageGenerationOptions = sequentialImageGenerationOptions;
            return this;
        }

        public Builder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public GenerateImagesRequest build() {
            GenerateImagesRequest generateImagesRequest = new GenerateImagesRequest();
            generateImagesRequest.setModel(this.model);
            generateImagesRequest.setPrompt(this.prompt);
            generateImagesRequest.setImage(this.image);
            generateImagesRequest.setResponseFormat(this.responseFormat);
            generateImagesRequest.setSeed(this.seed);
            generateImagesRequest.setGuidanceScale(this.guidanceScale);
            generateImagesRequest.setSize(this.size);
            generateImagesRequest.setWatermark(this.watermark);
            generateImagesRequest.setOptimizePrompt(this.optimizePrompt);
            generateImagesRequest.setSequentialImageGeneration(this.sequentialImageGeneration);
            generateImagesRequest.setSequentialImageGenerationOptions(this.sequentialImageGenerationOptions);
            generateImagesRequest.setStream(this.stream);
            return generateImagesRequest;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SequentialImageGenerationOptions {
        private Integer maxImages;

        public Integer getMaxImages() {
            return this.maxImages;
        }

        public void setMaxImages(Integer maxImages) {
            this.maxImages = maxImages;
        }

        public String toString() {
            return "SequentialImageGenerationOptions{maxImages=" + this.maxImages + '}';
        }
    }
}

