/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.ark.runtime.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;

public class JacksonUtil {
    private static final ObjectMapper objectMapper = JacksonUtil.defaultObjectMapper();

    private static ObjectMapper defaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        return mapper;
    }

    public static JsonNode clsToJsonNode(Object o) {
        return objectMapper.valueToTree(o);
    }

    public static <T> T jsonNodeToCls(JsonNode j, Class<T> cls) {
        return (T)objectMapper.convertValue((Object)j, cls);
    }
}

