/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.ark.runtime.interceptor;

import java.io.InterruptedIOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RetryInterceptor
implements Interceptor {
    private final int retryTimes;
    private final double INITIAL_RETRY_DELAY = 0.5;
    private final double MAX_RETRY_DELAY = 8.0;

    public RetryInterceptor(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public Response intercept(Interceptor.Chain chain) throws RuntimeException, InterruptedIOException {
        Exception exception;
        Request request = chain.request();
        int requestRetryTimes = this.getRetryTimes(request);
        Response response = null;
        int tryCount = 0;
        while (true) {
            boolean shouldRetry;
            if (response != null) {
                response.close();
            }
            exception = null;
            try {
                response = chain.proceed(request);
                shouldRetry = response.code() >= 500 || response.code() == 429;
            }
            catch (Exception e) {
                shouldRetry = true;
                exception = e;
            }
            if (!shouldRetry || ++tryCount > requestRetryTimes) break;
            try {
                double interval = this.retryInterval(requestRetryTimes, requestRetryTimes - tryCount) * 1000.0;
                Thread.sleep(Math.round(interval));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }
        if (response != null) {
            return response;
        }
        throw new RuntimeException(exception);
    }

    public double retryInterval(int max, int remain) {
        double nbRetries = Math.min((double)(max - remain), 16.0);
        double sleepSeconds = Math.min(0.5 * Math.pow(2.0, nbRetries), 8.0);
        double jitter = 1.0 - 0.25 * Math.random();
        return sleepSeconds * jitter;
    }

    public int getRetryTimes(Request request) {
        String path = request.url().encodedPath();
        if (path.equals("/api/v3/batch/chat/completions")) {
            return 259200;
        }
        return this.retryTimes;
    }
}

