/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.rec.core;

import com.byteplus.rec.core.Utils;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;

public class Auth {
    private static final TimeZone tz = TimeZone.getTimeZone("UTC");
    private static final Set<String> H_INCLUDE = new HashSet<String>();
    private static final String TIME_FORMAT_V4 = "yyyyMMdd'T'HHmmss'Z'";

    protected static Headers sign(Request request, byte[] reqBytes, Credential credential) throws Exception {
        Headers.Builder headerBuilder = request.headers().newBuilder();
        String formatDate = Auth.getCurrentFormatDate();
        headerBuilder.set("X-Date", formatDate);
        MetaData meta = new MetaData();
        meta.setAlgorithm("HMAC-SHA256");
        meta.setService(credential.getService());
        meta.setRegion(credential.getRegion());
        meta.setDate(Auth.toDate(formatDate));
        String bodyHash = Auth.hashSHA256(reqBytes);
        headerBuilder.set("X-Content-Sha256", bodyHash);
        meta.setCredentialScope(String.join((CharSequence)"/", meta.getDate(), meta.getRegion(), meta.getService(), "request"));
        String stringToSign = String.join((CharSequence)"\n", meta.getAlgorithm(), formatDate, meta.getCredentialScope(), Auth.hashCanonicalRequest(request, bodyHash, meta));
        byte[] signingKey = Auth.genSigningSecretKeyV4(credential.getSecretAccessKey(), meta.getDate(), meta.getRegion(), meta.getService());
        String signature = Utils.bytes2Hex(Auth.hmacSHA256(signingKey, stringToSign));
        headerBuilder.set("Authorization", Auth.buildAuthHeaderV4(signature, meta, credential));
        return headerBuilder.build();
    }

    private static String hashCanonicalRequest(Request request, String bodyHash, MetaData meta) throws Exception {
        ArrayList<String> signedHeaders = new ArrayList<String>();
        for (String string : request.headers().names()) {
            if (!H_INCLUDE.contains(string) && !string.startsWith("X-")) continue;
            signedHeaders.add(string.toLowerCase());
        }
        Collections.sort(signedHeaders);
        StringBuilder signedHeadersToSignStr = new StringBuilder();
        for (String header : signedHeaders) {
            String[] split;
            String port;
            String value = Objects.requireNonNull(request.header(header)).trim();
            if (header.equals("host") && value.contains(":") && ((port = (split = value.split(":"))[1]).equals("80") || port.equals("443"))) {
                value = split[0];
            }
            signedHeadersToSignStr.append(header).append(":").append(value).append("\n");
        }
        meta.setSignedHeaders(String.join((CharSequence)";", signedHeaders));
        String string = String.join((CharSequence)"\n", request.method(), Auth.normUri(request.url().encodedPath()), Auth.normQuery(request.url()), signedHeadersToSignStr.toString(), meta.getSignedHeaders(), bodyHash);
        return Auth.hashSHA256(string.getBytes());
    }

    private static byte[] genSigningSecretKeyV4(String secretKey, String date, String region, String service) throws Exception {
        byte[] kDate = Auth.hmacSHA256(secretKey.getBytes(), date);
        byte[] kRegion = Auth.hmacSHA256(kDate, region);
        byte[] kService = Auth.hmacSHA256(kRegion, service);
        return Auth.hmacSHA256(kService, "request");
    }

    private static String buildAuthHeaderV4(String signature, MetaData meta, Credential credentials) {
        String credential = credentials.getAccessKeyID() + "/" + meta.getCredentialScope();
        return meta.getAlgorithm() + " Credential=" + credential + ", SignedHeaders=" + meta.getSignedHeaders() + ", Signature=" + signature;
    }

    private static String getCurrentFormatDate() {
        SimpleDateFormat df = new SimpleDateFormat(TIME_FORMAT_V4);
        df.setTimeZone(tz);
        return df.format(new Date());
    }

    private static String toDate(String timestamp) {
        return timestamp.substring(0, 8);
    }

    private static String normUri(String encodedPath) {
        return encodedPath.replace("%2F", "/").replace("+", "%20");
    }

    private static String normQuery(HttpUrl url) {
        HttpUrl.Builder urlBuilder = url.newBuilder();
        HttpUrl finalUrl = url;
        url.queryParameterNames().stream().sorted().forEach(queryName -> urlBuilder.setQueryParameter((String)queryName, finalUrl.queryParameter((String)queryName)));
        String sortedQuery = urlBuilder.build().encodedQuery();
        if (Objects.nonNull(sortedQuery)) {
            return sortedQuery.replace("+", "%20");
        }
        return "";
    }

    private static String hashSHA256(byte[] content) throws Exception {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return Utils.bytes2Hex(md.digest(content));
        }
        catch (Exception e) {
            throw new Exception("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    private static byte[] hmacSHA256(byte[] key, String content) throws Exception {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac.doFinal(content.getBytes());
        }
        catch (Exception e) {
            throw new Exception("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    static {
        H_INCLUDE.add("Content-Type");
        H_INCLUDE.add("Content-Md5");
        H_INCLUDE.add("Host");
    }

    private static class MetaData {
        private String algorithm;
        private String credentialScope;
        private String signedHeaders;
        private String date;
        private String region;
        private String service;

        private void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        private void setCredentialScope(String credentialScope) {
            this.credentialScope = credentialScope;
        }

        private void setSignedHeaders(String signedHeaders) {
            this.signedHeaders = signedHeaders;
        }

        private void setDate(String date) {
            this.date = date;
        }

        private void setRegion(String region) {
            this.region = region;
        }

        private void setService(String service) {
            this.service = service;
        }

        private String getAlgorithm() {
            return this.algorithm;
        }

        private String getCredentialScope() {
            return this.credentialScope;
        }

        private String getSignedHeaders() {
            return this.signedHeaders;
        }

        private String getDate() {
            return this.date;
        }

        private String getRegion() {
            return this.region;
        }

        private String getService() {
            return this.service;
        }

        private MetaData() {
        }
    }

    protected static class Credential {
        private String accessKeyID;
        private String secretAccessKey;
        private String service;
        private String region;
        private String sessionToken;

        protected Credential(String ak, String sk, String service, String region) {
            this.accessKeyID = ak;
            this.secretAccessKey = sk;
            this.region = region;
            this.service = service;
        }

        protected void setAccessKeyID(String accessKeyID) {
            this.accessKeyID = accessKeyID;
        }

        protected void setSecretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
        }

        protected void setService(String service) {
            this.service = service;
        }

        protected void setRegion(String region) {
            this.region = region;
        }

        protected void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        protected String getAccessKeyID() {
            return this.accessKeyID;
        }

        protected String getSecretAccessKey() {
            return this.secretAccessKey;
        }

        protected String getService() {
            return this.service;
        }

        protected String getRegion() {
            return this.region;
        }

        protected String getSessionToken() {
            return this.sessionToken;
        }
    }
}

