/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.rec.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.byteplus.rec.core.Auth;
import com.byteplus.rec.core.BizException;
import com.byteplus.rec.core.Constant;
import com.byteplus.rec.core.HostAvailabler;
import com.byteplus.rec.core.NetException;
import com.byteplus.rec.core.Options;
import com.byteplus.rec.core.Utils;
import com.byteplus.rec.core.metrics.Metrics;
import com.byteplus.rec.core.metrics.MetricsLog;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPCaller {
    private static final Logger log = LoggerFactory.getLogger(HTTPCaller.class);
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(5L);
    private static final String DEFAULT_PING_URL_FORMAT = "%s://%s/predict/api/ping";
    private final Clock clock = Clock.systemDefaultZone();
    private volatile Map<Duration, OkHttpClient> timeoutHTTPCliMap = new HashMap<Duration, OkHttpClient>();
    private final ThreadLocal<String> requestID = new ThreadLocal();
    private final String projectID;
    private final String tenantID;
    private boolean useAirAuth;
    private String airAuthToken;
    private Auth.Credential authCredential;
    private final HostAvailabler hostAvailabler;
    private final Config config;
    private final String schema;
    private final boolean keepAlive;
    private ScheduledExecutorService heartbeatExecutor;
    private ExecutorService keepAliveExecutor;

    protected HTTPCaller(String projectID, String tenantID, String air_auth_token, HostAvailabler hostAvailabler, Config callerConfig, String schema, boolean keepAlive) {
        this.config = this.fillDefaultConfig(callerConfig);
        this.useAirAuth = true;
        this.projectID = projectID;
        this.tenantID = tenantID;
        this.airAuthToken = air_auth_token;
        this.hostAvailabler = hostAvailabler;
        this.schema = schema;
        this.keepAlive = keepAlive;
        if (this.keepAlive) {
            this.initHeartbeatExecutor(this.config.getKeepAlivePingInterval());
        }
    }

    protected HTTPCaller(String projectID, String tenantID, Auth.Credential authCredential, HostAvailabler hostAvailabler, Config callerConfig, String schema, boolean keepAlive) {
        this.config = this.fillDefaultConfig(callerConfig);
        this.projectID = projectID;
        this.tenantID = tenantID;
        this.authCredential = authCredential;
        this.hostAvailabler = hostAvailabler;
        this.schema = schema;
        this.keepAlive = keepAlive;
        if (this.keepAlive) {
            this.initHeartbeatExecutor(this.config.getKeepAlivePingInterval());
        }
    }

    private String getReqID() {
        return this.requestID.get();
    }

    private Config fillDefaultConfig(Config config) {
        if ((config = config.toBuilder().build()).maxIdleConnections <= 0) {
            config.maxIdleConnections = 32;
        }
        if (Objects.isNull(config.keepAliveDuration) || config.keepAliveDuration.isZero()) {
            config.keepAliveDuration = Constant.DEFAULT_KEEPALIVE_DURATION;
        }
        if (Objects.isNull(config.keepAlivePingInterval) || config.keepAlivePingInterval.isZero()) {
            config.keepAlivePingInterval = Constant.DEFAULT_KEEPALIVE_PING_INTERVAL;
        }
        if (config.maxKeepAliveConnections <= 0) {
            config.maxKeepAliveConnections = 3;
        }
        return config;
    }

    protected void initHeartbeatExecutor(Duration keepAlivePingInterval) {
        this.heartbeatExecutor = Executors.newSingleThreadScheduledExecutor();
        this.keepAliveExecutor = Executors.newFixedThreadPool(this.config.maxKeepAliveConnections);
        this.heartbeatExecutor.scheduleAtFixedRate(this::heartbeat, 1L, keepAlivePingInterval.getSeconds(), TimeUnit.SECONDS);
    }

    private void heartbeat() {
        for (final String host : this.hostAvailabler.getHosts()) {
            for (Map.Entry<Duration, OkHttpClient> entry : this.timeoutHTTPCliMap.entrySet()) {
                final long timeoutMs = entry.getKey().toMillis();
                final OkHttpClient client = entry.getValue();
                for (int i = 0; i < this.config.maxKeepAliveConnections; ++i) {
                    this.keepAliveExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            String[] metricsTags = new String[]{"from:http_caller", "project_id:" + HTTPCaller.this.getProjectID(), "timeout:" + timeoutMs, "host:" + Utils.escapeMetricsTagValue(host)};
                            Metrics.counter("heartbeat.count", 1L, metricsTags);
                            Utils.ping(HTTPCaller.this.getProjectID(), client, HTTPCaller.DEFAULT_PING_URL_FORMAT, HTTPCaller.this.schema, host);
                        }
                    });
                }
            }
        }
    }

    protected <Rsp extends Message, Req extends Message> Rsp doPBRequest(String url, Req request, Parser<Rsp> rspParser, Options options) throws NetException, BizException {
        byte[] reqBytes = request.toByteArray();
        String contentType = "application/x-protobuf";
        byte[] rspBytes = this.doRequest(url, reqBytes, contentType, options);
        try {
            return (Rsp)((Message)rspParser.parseFrom(rspBytes));
        }
        catch (InvalidProtocolBufferException e) {
            String[] metricsTags = new String[]{"type:parse_response_fail", "project_id:" + this.getProjectID()};
            Metrics.counter("common.err", 1L, metricsTags);
            MetricsLog.error(this.getReqID(), "[ByteplusSDK]parse response fail, project_id:%s, url:%s err:%s ", this.getProjectID(), url, e.getMessage());
            log.error("[ByteplusSDK]parse response fail, url:{} err:{} ", (Object)url, (Object)e.getMessage());
            throw new BizException("parse response fail");
        }
    }

    protected <Rsp> Rsp doJSONRequest(String url, Object request, Rsp resp, Options options) throws NetException, BizException {
        byte[] reqBytes = JSON.toJSONBytes(request, new SerializerFeature[0]);
        String contentType = "application/json";
        byte[] rspBytes = this.doRequest(url, reqBytes, contentType, options);
        return (Rsp)JSON.parseObject(rspBytes, resp.getClass(), new Feature[0]);
    }

    private byte[] doRequest(String url, byte[] reqBytes, String contentType, Options options) throws NetException, BizException {
        reqBytes = this.gzipCompress(reqBytes);
        Headers headers = this.buildHeaders(options, contentType);
        url = this.buildUrlWithQueries(options, url);
        return this.doHTTPRequest(url, headers, reqBytes, options.getTimeout());
    }

    private byte[] gzipCompress(byte[] bodyBytes) {
        if (bodyBytes == null || bodyBytes.length == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(bodyBytes);
            gzip.finish();
            gzip.close();
        }
        catch (IOException e) {
            log.error("[ByteplusSDK] gzip compress http request bytes error {}", (Object)e.getMessage());
            return bodyBytes;
        }
        return out.toByteArray();
    }

    private Headers buildHeaders(Options options, String contentType) {
        Headers.Builder builder = new Headers.Builder();
        builder.set("Content-Encoding", "gzip");
        builder.set("Accept-Encoding", "gzip");
        builder.set("Content-Type", contentType);
        builder.set("Accept", contentType);
        builder.set("Tenant-Id", this.getTenantID());
        builder.set("Project-Id", this.getProjectID());
        this.withOptionHeaders(builder, options);
        return builder.build();
    }

    private String buildUrlWithQueries(Options options, String url) {
        HashMap<String, String> queries = new HashMap<String, String>();
        if (Objects.nonNull(options.getQueries())) {
            queries.putAll(options.getQueries());
        }
        if (queries.isEmpty()) {
            return url;
        }
        ArrayList queryParts = new ArrayList();
        queries.forEach((queryName, queryValue) -> queryParts.add(queryName + "=" + queryValue));
        String queryString = String.join((CharSequence)"&", queryParts);
        if (url.contains("?")) {
            return url + "&" + queryString;
        }
        return url + "?" + queryString;
    }

    private void withOptionHeaders(Headers.Builder builder, Options options) {
        String requestID;
        if (Objects.nonNull(options.getHeaders())) {
            options.getHeaders().forEach(builder::set);
        }
        if (Objects.isNull(requestID = options.getRequestID())) {
            requestID = UUID.randomUUID().toString();
            log.info("[ByteplusSDK] requestID is generated by sdk: '{}'", (Object)requestID);
            builder.set("Request-Id", requestID);
        } else {
            builder.set("Request-Id", options.getRequestID());
        }
        if (Objects.nonNull(options.getServerTimeout())) {
            builder.set("Timeout-Millis", options.getServerTimeout().toMillis() + "");
        }
        this.requestID.set(requestID);
    }

    private String calSignature(byte[] httpBody, String ts, String nonce) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ignored) {
            return "";
        }
        digest.update(this.getAirAuthToken().getBytes(StandardCharsets.UTF_8));
        digest.update(httpBody);
        digest.update(this.getTenantID().getBytes(StandardCharsets.UTF_8));
        digest.update(ts.getBytes(StandardCharsets.UTF_8));
        digest.update(nonce.getBytes(StandardCharsets.UTF_8));
        return Utils.bytes2Hex(digest.digest());
    }

    /*
     * Exception decompiling
     */
    private byte[] doHTTPRequest(String url, Headers headers, byte[] bodyBytes, Duration timeout) throws NetException, BizException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Headers withAuthHeaders(Request request, byte[] bodyBytes) throws BizException {
        if (this.useAirAuth) {
            Headers originHeaders = request.headers();
            return this.withAirAuthHeaders(originHeaders, bodyBytes);
        }
        try {
            return Auth.sign(request, bodyBytes, this.getAuthCredential());
        }
        catch (Exception e) {
            throw new BizException(e.getMessage());
        }
    }

    private Headers withAirAuthHeaders(Headers originHeaders, byte[] reqBytes) {
        String ts = "" + this.clock.millis() / 1000L;
        String nonce = UUID.randomUUID().toString().substring(0, 8);
        String signature = this.calSignature(reqBytes, ts, nonce);
        return originHeaders.newBuilder().set("Tenant-Id", this.getTenantID()).set("Tenant-Ts", ts).set("Tenant-Nonce", nonce).set("Tenant-Signature", signature).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OkHttpClient selectHTTPClient(Duration timeout2) {
        OkHttpClient httpClient;
        if (Objects.isNull(timeout2) || timeout2.isZero()) {
            timeout2 = DEFAULT_TIMEOUT;
        }
        if (Objects.nonNull(httpClient = this.timeoutHTTPCliMap.get(timeout2))) {
            return httpClient;
        }
        Class<HTTPCaller> clazz = HTTPCaller.class;
        synchronized (HTTPCaller.class) {
            httpClient = this.timeoutHTTPCliMap.get(timeout2);
            if (Objects.nonNull(httpClient)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return httpClient;
            }
            httpClient = Utils.buildOkHTTPClient(timeout2, this.config.maxIdleConnections, this.config.keepAliveDuration);
            HashMap<Duration, OkHttpClient> timeoutHTTPCliMapTemp = new HashMap<Duration, OkHttpClient>(this.timeoutHTTPCliMap.size());
            timeoutHTTPCliMapTemp.putAll(this.timeoutHTTPCliMap);
            timeoutHTTPCliMapTemp.put(timeout2, httpClient);
            this.timeoutHTTPCliMap = timeoutHTTPCliMapTemp;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return httpClient;
        }
    }

    private void logErrHTTPResponse(String url, Response response) throws IOException {
        String[] metricsTags = new String[]{"type:rsp_status_not_ok", "url:" + Utils.escapeMetricsTagValue(url), "project_id:" + this.getProjectID(), "status:" + response.code()};
        Metrics.counter("common.err", 1L, metricsTags);
        ResponseBody rspBody = response.body();
        if (Objects.isNull(rspBody)) {
            String logFormat = "[ByteplusSDK] http status not 200, project_id:%s, url:%s, code:%d, msg:%s, headers:\\n%s";
            MetricsLog.error(this.getReqID(), logFormat, this.getProjectID(), url, response.code(), response.message(), response.headers());
            log.error("[ByteplusSDK] http status not 200, url:{} code:{} msg:{} headers:\n{}", url, response.code(), response.message(), response.headers());
            return;
        }
        String rspEncoding = response.header("Content-Encoding");
        byte[] rspBodyBytes = Objects.isNull(rspEncoding) || !rspEncoding.contains("gzip") ? rspBody.bytes() : this.gzipDecompress(rspBody.bytes(), url);
        String bodyStr = new String(rspBodyBytes, StandardCharsets.UTF_8);
        String logFormat = "[ByteplusSDK] http status not 200, project_id:%s, url:%s, code:%d, msg:%s, headers:\\n%s, body:\n%s";
        MetricsLog.error(this.getReqID(), logFormat, this.getProjectID(), url, response.code(), response.message(), response.headers(), bodyStr);
        log.error("[ByteplusSDK] http status not 200, url:{} code:{} msg:{} headers:\n{} body:\n{}", url, response.code(), response.message(), response.headers(), bodyStr);
    }

    private byte[] gzipDecompress(byte[] bodyBytes, String url) {
        if (bodyBytes == null || bodyBytes.length == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(bodyBytes);
        try {
            int n;
            GZIPInputStream ungzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            while ((n = ungzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
        }
        catch (Exception e) {
            log.error("[ByteplusSDK] gzip decompress http response error, msg:{} url:{}", (Object)e.getMessage(), (Object)url);
        }
        return out.toByteArray();
    }

    public void shutdown() {
        if (!Objects.isNull(this.heartbeatExecutor)) {
            this.heartbeatExecutor.shutdown();
        }
        if (!Objects.isNull(this.keepAliveExecutor)) {
            this.keepAliveExecutor.shutdown();
        }
    }

    protected static Config getDefaultConfig() {
        return new Config(32, Constant.DEFAULT_KEEPALIVE_DURATION, Constant.DEFAULT_KEEPALIVE_PING_INTERVAL, 3);
    }

    private Clock getClock() {
        return this.clock;
    }

    private Map<Duration, OkHttpClient> getTimeoutHTTPCliMap() {
        return this.timeoutHTTPCliMap;
    }

    private ThreadLocal<String> getRequestID() {
        return this.requestID;
    }

    private String getProjectID() {
        return this.projectID;
    }

    private String getTenantID() {
        return this.tenantID;
    }

    private boolean isUseAirAuth() {
        return this.useAirAuth;
    }

    private String getAirAuthToken() {
        return this.airAuthToken;
    }

    private Auth.Credential getAuthCredential() {
        return this.authCredential;
    }

    private HostAvailabler getHostAvailabler() {
        return this.hostAvailabler;
    }

    private Config getConfig() {
        return this.config;
    }

    private String getSchema() {
        return this.schema;
    }

    private boolean isKeepAlive() {
        return this.keepAlive;
    }

    private ScheduledExecutorService getHeartbeatExecutor() {
        return this.heartbeatExecutor;
    }

    private ExecutorService getKeepAliveExecutor() {
        return this.keepAliveExecutor;
    }

    public static class Config {
        private int maxIdleConnections;
        private Duration keepAliveDuration;
        private Duration keepAlivePingInterval;
        private int maxKeepAliveConnections;

        public static ConfigBuilder builder() {
            return new ConfigBuilder();
        }

        public ConfigBuilder toBuilder() {
            return new ConfigBuilder().maxIdleConnections(this.maxIdleConnections).keepAliveDuration(this.keepAliveDuration).keepAlivePingInterval(this.keepAlivePingInterval).maxKeepAliveConnections(this.maxKeepAliveConnections);
        }

        public int getMaxIdleConnections() {
            return this.maxIdleConnections;
        }

        public Duration getKeepAliveDuration() {
            return this.keepAliveDuration;
        }

        public Duration getKeepAlivePingInterval() {
            return this.keepAlivePingInterval;
        }

        public int getMaxKeepAliveConnections() {
            return this.maxKeepAliveConnections;
        }

        public Config() {
        }

        public Config(int maxIdleConnections, Duration keepAliveDuration, Duration keepAlivePingInterval, int maxKeepAliveConnections) {
            this.maxIdleConnections = maxIdleConnections;
            this.keepAliveDuration = keepAliveDuration;
            this.keepAlivePingInterval = keepAlivePingInterval;
            this.maxKeepAliveConnections = maxKeepAliveConnections;
        }

        public static class ConfigBuilder {
            private int maxIdleConnections;
            private Duration keepAliveDuration;
            private Duration keepAlivePingInterval;
            private int maxKeepAliveConnections;

            ConfigBuilder() {
            }

            public ConfigBuilder maxIdleConnections(int maxIdleConnections) {
                this.maxIdleConnections = maxIdleConnections;
                return this;
            }

            public ConfigBuilder keepAliveDuration(Duration keepAliveDuration) {
                this.keepAliveDuration = keepAliveDuration;
                return this;
            }

            public ConfigBuilder keepAlivePingInterval(Duration keepAlivePingInterval) {
                this.keepAlivePingInterval = keepAlivePingInterval;
                return this;
            }

            public ConfigBuilder maxKeepAliveConnections(int maxKeepAliveConnections) {
                this.maxKeepAliveConnections = maxKeepAliveConnections;
                return this;
            }

            public Config build() {
                return new Config(this.maxIdleConnections, this.keepAliveDuration, this.keepAlivePingInterval, this.maxKeepAliveConnections);
            }

            public String toString() {
                return "HTTPCaller.Config.ConfigBuilder(maxIdleConnections=" + this.maxIdleConnections + ", keepAliveDuration=" + this.keepAliveDuration + ", keepAlivePingInterval=" + this.keepAlivePingInterval + ", maxKeepAliveConnections=" + this.maxKeepAliveConnections + ")";
            }
        }
    }
}

