/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.rec.core;

import com.byteplus.rec.core.Utils;
import com.byteplus.rec.core.metrics.Metrics;
import com.byteplus.rec.core.metrics.MetricsLog;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkListener
extends EventListener {
    private static final Logger log = LoggerFactory.getLogger(NetworkListener.class);
    static InetAddress addr;

    public static EventListener.Factory get() {
        return new EventListener.Factory(){

            @Override
            @NotNull
            public EventListener create(@NotNull Call call) {
                return new NetworkListener();
            }
        };
    }

    public String getReqID(@NotNull Call call) {
        List<String> values2 = call.request().headers("Request-Id");
        if (Objects.isNull(values2) || values2.isEmpty()) {
            return "non-reqId";
        }
        return values2.get(0);
    }

    public String getProjectID(@NotNull Call call) {
        List<String> values2 = call.request().headers("Project-Id");
        if (Objects.isNull(values2) || values2.isEmpty()) {
            return "non-projectId";
        }
        return call.request().headers("Project-Id").get(0);
    }

    @Override
    public void callStart(@NotNull Call call) {
        long currentTimestamp = System.currentTimeMillis();
        MetricsLog.info(this.getReqID(call), "[ByteplusSDK][NetworkListener] project_id=%s, host=%s, callStart=%d, url=%s", this.getProjectID(call), addr, currentTimestamp, call.request().url());
    }

    @Override
    public void dnsStart(@NotNull Call call, @NotNull String domainName) {
        String[] metricsTags = new String[]{"url:" + Utils.escapeMetricsTagValue(call.request().url().toString()), "project_id:" + this.getProjectID(call)};
        Metrics.counter("network.dns.start", 1L, metricsTags);
        long currentTimestamp = System.currentTimeMillis();
        MetricsLog.info(this.getReqID(call), "[ByteplusSDK][NetworkListener] project_id=%s, host=%s, dnsStart=%d", this.getProjectID(call), addr, currentTimestamp);
    }

    @Override
    public void dnsEnd(@NotNull Call call, @NotNull String domainName, @NotNull List<InetAddress> inetAddressList) {
        long currentTimestamp = System.currentTimeMillis();
        MetricsLog.info(this.getReqID(call), "[ByteplusSDK][NetworkListener] project_id=%s, host=%s, dnsEnd=%d", this.getProjectID(call), addr, currentTimestamp);
    }

    @Override
    public void connectStart(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy) {
        String[] metricsTags = new String[]{"url:" + Utils.escapeMetricsTagValue(call.request().url().toString()), "project_id:" + this.getProjectID(call)};
        Metrics.counter("network.connect.start", 1L, metricsTags);
        long currentTimestamp = System.currentTimeMillis();
        MetricsLog.info(this.getReqID(call), "[ByteplusSDK][NetworkListener] project_id=%s, host=%s, connectStart=%d", this.getProjectID(call), addr, currentTimestamp);
    }

    @Override
    public void secureConnectStart(@NotNull Call call) {
        String[] metricsTags = new String[]{"url:" + Utils.escapeMetricsTagValue(call.request().url().toString()), "project_id:" + this.getProjectID(call)};
        Metrics.counter("network.secure.connect.start", 1L, metricsTags);
        long currentTimestamp = System.currentTimeMillis();
        MetricsLog.info(this.getReqID(call), "[ByteplusSDK][NetworkListener] project_id=%s, host=%s, secureConnectStart=%d", this.getProjectID(call), addr, currentTimestamp);
    }

    @Override
    public void secureConnectEnd(@NotNull Call call, @Nullable Handshake handshake2) {
        long currentTimestamp = System.currentTimeMillis();
        MetricsLog.info(this.getReqID(call), "[ByteplusSDK][NetworkListener] project_id=%s, host=%s, secureConnectEnd=%d", this.getProjectID(call), addr, currentTimestamp);
    }

    @Override
    public void connectEnd(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy, @Nullable Protocol protocol) {
        long currentTimestamp = System.currentTimeMillis();
        MetricsLog.info(this.getReqID(call), "[ByteplusSDK][NetworkListener] project_id=%s, host=%s, connectEnd=%d", this.getProjectID(call), addr, currentTimestamp);
    }

    @Override
    public void connectFailed(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy, @Nullable Protocol protocol, @NotNull IOException ioe) {
        String[] metricsTags = new String[]{"url:" + Utils.escapeMetricsTagValue(call.request().url().toString()), "project_id:" + this.getProjectID(call)};
        Metrics.counter("network.connect.fail", 1L, metricsTags);
        long currentTimestamp = System.currentTimeMillis();
        MetricsLog.info(this.getReqID(call), "[ByteplusSDK][NetworkListener] project_id=%s, host=%s, connectFailed=%d", this.getProjectID(call), addr, currentTimestamp);
    }

    @Override
    public void requestHeadersStart(@NotNull Call call) {
        long currentTimestamp = System.currentTimeMillis();
        MetricsLog.info(this.getReqID(call), "[ByteplusSDK][NetworkListener] project_id=%s, host=%s, requestHeadersStart=%d", this.getProjectID(call), addr, currentTimestamp);
    }

    @Override
    public void requestHeadersEnd(@NotNull Call call, @NotNull Request request) {
        long currentTimestamp = System.currentTimeMillis();
        MetricsLog.info(this.getReqID(call), "[ByteplusSDK][NetworkListener] project_id=%s, host=%s, requestHeadersEnd=%d", this.getProjectID(call), addr, currentTimestamp);
    }

    @Override
    public void requestBodyStart(@NotNull Call call) {
        long currentTimestamp = System.currentTimeMillis();
        MetricsLog.info(this.getReqID(call), "[ByteplusSDK][NetworkListener] project_id=%s, host=%s, requestBodyStart=%d", this.getProjectID(call), addr, currentTimestamp);
    }

    @Override
    public void requestBodyEnd(@NotNull Call call, long byteCount) {
        long currentTimestamp = System.currentTimeMillis();
        MetricsLog.info(this.getReqID(call), "[ByteplusSDK][NetworkListener] project_id=%s, host=%s, requestBodyEnd=%d", this.getProjectID(call), addr, currentTimestamp);
    }

    @Override
    public void responseHeadersStart(@NotNull Call call) {
        long currentTimestamp = System.currentTimeMillis();
        MetricsLog.info(this.getReqID(call), "[ByteplusSDK][NetworkListener] project_id=%s, host=%s, responseHeadersStart=%d", this.getProjectID(call), addr, currentTimestamp);
    }

    @Override
    public void responseHeadersEnd(@NotNull Call call, @NotNull Response response) {
        long currentTimestamp = System.currentTimeMillis();
        MetricsLog.info(this.getReqID(call), "[ByteplusSDK][NetworkListener] project_id=%s, host=%s, responseHeadersEnd=%d", this.getProjectID(call), addr, currentTimestamp);
    }

    @Override
    public void responseBodyStart(@NotNull Call call) {
        long currentTimestamp = System.currentTimeMillis();
        MetricsLog.info(this.getReqID(call), "[ByteplusSDK][NetworkListener] project_id=%s, host=%s, responseBodyStart=%d", this.getProjectID(call), addr, currentTimestamp);
    }

    @Override
    public void responseBodyEnd(@NotNull Call call, long byteCount) {
        long currentTimestamp = System.currentTimeMillis();
        MetricsLog.info(this.getReqID(call), "[ByteplusSDK][NetworkListener] project_id=%s, host=%s, responseBodyEnd=%d", this.getProjectID(call), addr, currentTimestamp);
    }

    @Override
    public void callEnd(@NotNull Call call) {
        long currentTimestamp = System.currentTimeMillis();
        MetricsLog.info(this.getReqID(call), "[ByteplusSDK][NetworkListener] project_id=%s, host=%s, callEnd=%d, url=%s", this.getProjectID(call), addr, currentTimestamp, call.request().url());
    }

    @Override
    public void callFailed(@NotNull Call call, @NotNull IOException ioe) {
        String[] metricsTags = new String[]{"url:" + Utils.escapeMetricsTagValue(call.request().url().toString()), "project_id:" + this.getProjectID(call)};
        Metrics.counter("network.call.fail", 1L, metricsTags);
        long currentTimestamp = System.currentTimeMillis();
        MetricsLog.info(this.getReqID(call), "[ByteplusSDK][NetworkListener] project_id=%s, host=%s, callFailed=%d, err=%s", this.getProjectID(call), addr, currentTimestamp, ioe.getMessage());
    }

    static {
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

