/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.rec.core;

import com.byteplus.rec.core.Options;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public interface Option {
    public void fill(Options var1);

    public static Options conv2Options(Option[] opts) {
        Options options = new Options();
        if (Objects.isNull(opts) || opts.length == 0) {
            return options;
        }
        for (Option opt : opts) {
            opt.fill(options);
        }
        return options;
    }

    public static Option withRequestID(String requestID) {
        return options -> options.setRequestID(requestID);
    }

    public static Option withTimeout(Duration timeout2) {
        return options -> {
            if (timeout2.toMillis() <= 0L) {
                return;
            }
            options.setTimeout(timeout2);
        };
    }

    public static Option withHTTPHeader(String key, String value) {
        return options -> {
            Map<String, String> headers = options.getHeaders();
            if (headers == null) {
                headers = new HashMap<String, String>();
            }
            headers.put(key, value);
            options.setHeaders(headers);
        };
    }

    public static Option withHTTPQuery(String key, String value) {
        return options -> {
            Map<String, String> queries = options.getQueries();
            if (queries == null) {
                queries = new HashMap<String, String>();
            }
            queries.put(key, value);
            options.setQueries(queries);
        };
    }

    public static Option withServerTimeout(Duration timeout2) {
        return options -> options.setServerTimeout(timeout2);
    }
}

