/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.rec.core.metrics;

import com.byteplus.rec.core.metrics.Metrics;
import com.byteplus.rec.core.metrics.MetricsCollector;
import com.byteplus.rec.core.metrics.MetricsLog;
import com.byteplus.rec.core.metrics.MetricsOption;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class MetricsExample {
    static int times = 1500;

    public static void metricsInit() {
        MetricsCollector.Init(MetricsOption.withMetricsHttpSchema("http"), MetricsOption.enableMetrics(), MetricsOption.enableMetricsLog(), MetricsOption.withReportInterval(Duration.ofSeconds(5L)), MetricsOption.withMetricsPrefix("test.byteplus.sdk"), MetricsOption.withMetricsTimeout(Duration.ofSeconds(1L)), MetricsOption.withMetricsDomain("10.244.245.79:9235"));
    }

    public static void storeReport() {
        System.out.println("start store reporting...");
        for (int i = 0; i < times; ++i) {
            Metrics.store("java.request.store", 200L, "type:test_metrics1", "url:https://asfwe.sds.com/test?qu1=xxx&qu2=yyy", "error:");
            Metrics.store("java.request.store", 100L, "type:test_metrics2", "url:https://asfwe.sds.com/test?qu1=xxx&qu2=yyy", "error");
            Metrics.store("java.request.store", 200L, "type:test_metrics3", "url:https://asfwe.sds.com/test?qu1=xxx&qu2=yyy", "error:");
            Metrics.store("java.request.store", 100L, "type:test_metrics4", "url:https://asfwe.sds.com/test?qu1<eq>xxx&qu2<eq>yyy", "error");
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("stop store reporting");
    }

    public static void counterReport() {
        System.out.println("start counter reporting...");
        for (int i = 0; i < times; ++i) {
            Metrics.counter("java.request.counter", 1L, "type:test_counter1");
            Metrics.counter("java.request.counter", 1L, "type:test_counter2");
            try {
                TimeUnit.MILLISECONDS.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("stop counter reporting");
    }

    public static void timerReport() {
        System.out.println("start timer reporting...");
        for (int i = 0; i < times; ++i) {
            long begin = System.currentTimeMillis();
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
                Metrics.latency("java.request.timer", begin, "type:test_timer1");
                begin = System.currentTimeMillis();
                TimeUnit.MILLISECONDS.sleep(150L);
                Metrics.latency("java.request.timer", begin, "type:test_timer2");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("stop timer reporting");
    }

    public static void main(String[] args2) {
        MetricsLog.info(String.valueOf(UUID.randomUUID()), "this is a test log: %d", 2);
    }

    static {
        MetricsExample.metricsInit();
    }
}

