/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.rec.core.metrics;

import com.byteplus.rec.core.metrics.MetricsCollector;
import java.time.Duration;
import java.util.Objects;

public interface MetricsOption {
    public void fill(MetricsCollector.MetricsCfg var1);

    public static MetricsOption withMetricsDomain(String domain) {
        return options -> {
            if (Objects.nonNull(domain) && !domain.equals("")) {
                options.setDomain(domain);
            }
        };
    }

    public static MetricsOption withMetricsPrefix(String prefix) {
        return options -> {
            if (Objects.nonNull(prefix) && !prefix.equals("")) {
                options.setPrefix(prefix);
            }
        };
    }

    public static MetricsOption withMetricsHttpSchema(String schema) {
        return options -> {
            if ("http".equals(schema) || "https".equals(schema)) {
                options.setHttpSchema(schema);
            }
        };
    }

    public static MetricsOption enableMetrics() {
        return options -> options.setEnableMetrics(true);
    }

    public static MetricsOption enableMetricsLog() {
        return options -> options.setEnableMetricsLog(true);
    }

    public static MetricsOption withReportInterval(Duration reportInterval) {
        return options -> {
            if (reportInterval.toMillis() > 1000L) {
                options.setReportInterval(reportInterval);
            }
        };
    }

    public static MetricsOption withMetricsTimeout(Duration timeout2) {
        return options -> options.setHttpTimeout(timeout2);
    }
}

