/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.rec.sdk.content.example;

import com.alibaba.fastjson.JSON;
import com.byteplus.rec.core.BizException;
import com.byteplus.rec.core.NetException;
import com.byteplus.rec.core.Option;
import com.byteplus.rec.core.StatusHelper;
import com.byteplus.rec.sdk.content.ContentClient;
import com.byteplus.rec.sdk.content.ContentClientBuilder;
import com.byteplus.rec.sdk.content.example.MockHelper;
import com.byteplus.rec.sdk.content.example.entity.DemoContent;
import com.byteplus.rec.sdk.content.example.entity.DemoUser;
import com.byteplus.rec.sdk.content.example.entity.DemoUserEvent;
import com.byteplus.rec.sdk.content.protocol.ByteplusSaasContent;
import com.byteplus.rec.sdk.region.Region;
import java.time.Duration;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static ContentClient client;
    private static final int DEFAULT_RETRY_TIMES = 2;
    private static final Duration DEFAULT_WRITE_TIMEOUT;
    private static final Duration DEFAULT_PREDICT_TIMEOUT;
    private static final Duration DEFAULT_FINISH_TIMEOUT;
    private static final Duration DEFAULT_ACK_IMPRESSIONS_TIMEOUT;
    public static final String PROJECT_ID = "*********";
    public static final String SCENE_NAME = "*********";

    public static void main(String[] args2) {
        Main.writeUsersExample();
        Main.writeContentsExample();
        Main.writeUserEventsExample();
        Main.recommendExample();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        client.release();
        System.exit(0);
    }

    public static void writeUsersExample() {
        ByteplusSaasContent.WriteResponse response;
        ByteplusSaasContent.WriteDataRequest request = Main.buildWriteUsersRequest(1);
        Option[] opts = Main.defaultOptions(DEFAULT_WRITE_TIMEOUT);
        try {
            response = client.writeUsers(request, opts);
        }
        catch (BizException | NetException e) {
            log.error("write user occur err, msg:{}", (Object)e.getMessage());
            return;
        }
        if (StatusHelper.isUploadSuccess(response.getStatus().getCode())) {
            log.info("write user success");
            return;
        }
        log.error("write user find failure info, msg:{} errItems:{}", (Object)response.getStatus(), (Object)response.getErrorsList());
    }

    private static ByteplusSaasContent.WriteDataRequest buildWriteUsersRequest(int count) {
        List<DemoUser> users = MockHelper.mockUsers(count);
        ByteplusSaasContent.WriteDataRequest.Builder requestBuilder = ByteplusSaasContent.WriteDataRequest.newBuilder().setStage("incremental_sync_streaming");
        for (DemoUser user : users) {
            requestBuilder.addData(JSON.toJSONString(user));
        }
        return requestBuilder.build();
    }

    public static void writeContentsExample() {
        ByteplusSaasContent.WriteResponse response;
        ByteplusSaasContent.WriteDataRequest request = Main.buildWriteContentsRequest(1);
        Option[] options = Main.defaultOptions(DEFAULT_WRITE_TIMEOUT);
        try {
            response = client.writeContents(request, options);
        }
        catch (BizException | NetException e) {
            log.error("write content occur err, msg:{}", (Object)e.getMessage());
            return;
        }
        if (StatusHelper.isUploadSuccess(response.getStatus().getCode())) {
            log.info("write content success");
            return;
        }
        log.error("write content find failure info, msg:{} errItems:{}", (Object)response.getStatus(), (Object)response.getErrorsList());
    }

    private static ByteplusSaasContent.WriteDataRequest buildWriteContentsRequest(int count) {
        List<DemoContent> contents = MockHelper.mockContents(count);
        ByteplusSaasContent.WriteDataRequest.Builder requestBuilder = ByteplusSaasContent.WriteDataRequest.newBuilder().setStage("incremental_sync_streaming");
        for (DemoContent content : contents) {
            requestBuilder.addData(JSON.toJSONString(content));
        }
        return requestBuilder.build();
    }

    public static void writeUserEventsExample() {
        ByteplusSaasContent.WriteResponse response;
        ByteplusSaasContent.WriteDataRequest request = Main.buildWriteUserEventsRequest(1);
        Option[] options = Main.defaultOptions(DEFAULT_WRITE_TIMEOUT);
        try {
            response = client.writeUserEvents(request, options);
        }
        catch (BizException | NetException e) {
            log.error("write user events occur err, msg:{}", (Object)e.getMessage());
            return;
        }
        if (StatusHelper.isUploadSuccess(response.getStatus().getCode())) {
            log.info("write user events success");
            return;
        }
        log.error("write user events find failure info, msg:{} errItems:{}", (Object)response.getStatus(), (Object)response.getErrorsList());
    }

    private static ByteplusSaasContent.WriteDataRequest buildWriteUserEventsRequest(int count) {
        List<DemoUserEvent> userEvents = MockHelper.mockUserEvents(count);
        ByteplusSaasContent.WriteDataRequest.Builder requestBuilder = ByteplusSaasContent.WriteDataRequest.newBuilder().setStage("incremental_sync_streaming");
        for (DemoUserEvent userEvent : userEvents) {
            requestBuilder.addData(JSON.toJSONString(userEvent));
        }
        return requestBuilder.build();
    }

    private static List<ByteplusSaasContent.Date> buildDateList(LocalDate date) {
        List<LocalDate> dateList = Collections.singletonList(date);
        ArrayList<ByteplusSaasContent.Date> dates = new ArrayList<ByteplusSaasContent.Date>();
        for (LocalDate singleDay : dateList) {
            Main.addFinishDate(dates, singleDay);
        }
        return dates;
    }

    private static void addFinishDate(List<ByteplusSaasContent.Date> dateMapList, LocalDate date) {
        dateMapList.add(Main.buildFinishDate(date));
    }

    private static ByteplusSaasContent.Date buildFinishDate(LocalDate date) {
        return ByteplusSaasContent.Date.newBuilder().setYear(date.getYear()).setMonth(date.getMonthValue()).setDay(date.getDayOfMonth()).build();
    }

    public static void writeOthersExample() {
        ByteplusSaasContent.WriteResponse response;
        String topic = "video";
        ByteplusSaasContent.WriteDataRequest request = Main.buildWriteOthersRequest(topic);
        Option[] opts = Main.defaultOptions(DEFAULT_WRITE_TIMEOUT);
        try {
            response = client.writeOthers(request, opts);
        }
        catch (BizException | NetException e) {
            log.error("write other data occur err, msg:{}", (Object)e.getMessage());
            return;
        }
        if (StatusHelper.isUploadSuccess(response.getStatus().getCode())) {
            log.info("write other data success");
            return;
        }
        log.error("write other data find failure info, msg:{} errItems:{}", (Object)response.getStatus(), (Object)response.getErrorsList());
    }

    private static ByteplusSaasContent.WriteDataRequest buildWriteOthersRequest(String topic) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("field1", 1);
        data.put("field2", "value2");
        return ByteplusSaasContent.WriteDataRequest.newBuilder().setStage("incremental_sync_streaming").setTopic(topic).addData(((Object)data).toString()).build();
    }

    public static void finishWriteExample() {
        ByteplusSaasContent.WriteResponse response;
        String topic = "user";
        ByteplusSaasContent.FinishWriteDataRequest request = Main.buildFinishRequest(topic);
        Option[] opts = Main.defaultOptions(DEFAULT_FINISH_TIMEOUT);
        try {
            response = client.finishWrite(request, opts);
        }
        catch (BizException | NetException e) {
            log.error("run finish occur error, msg:{}", (Object)e.getMessage());
            return;
        }
        if (StatusHelper.isUploadSuccess(response.getStatus().getCode())) {
            log.info("finish writing data");
            return;
        }
        log.error("fail to finish, msg:{} errItems:{}", (Object)response.getStatus(), (Object)response.getInitializationErrorString());
    }

    private static ByteplusSaasContent.FinishWriteDataRequest buildFinishRequest(String topic) {
        LocalDate date = LocalDate.of(2022, 8, 1);
        return ByteplusSaasContent.FinishWriteDataRequest.newBuilder().setStage("incremental_sync_streaming").setTopic(topic).addAllDataDates(Main.buildDateList(date)).build();
    }

    public static void recommendExample() {
        ByteplusSaasContent.PredictResponse response;
        ByteplusSaasContent.PredictRequest predictRequest = Main.buildPredictRequest();
        Option[] predict_opts = Main.defaultOptions(DEFAULT_PREDICT_TIMEOUT);
        try {
            response = client.predict(predictRequest, predict_opts);
        }
        catch (Exception e) {
            log.error("predict occur error, msg:{}", (Object)e.getMessage());
            return;
        }
        if (!StatusHelper.isSuccess(response.getStatus().getCode())) {
            log.error("predict find failure info, msg:{}", (Object)response.getStatus());
            return;
        }
        log.info("predict success");
        List<ByteplusSaasContent.AckServerImpressionsRequest.AlteredContent> alteredContents = Main.doSomethingWithPredictResult(response.getContentValue());
        ByteplusSaasContent.AckServerImpressionsRequest ackRequest = Main.buildAckRequest(response.getRequestId(), predictRequest, alteredContents);
        Option[] ack_opts = Main.defaultOptions(DEFAULT_ACK_IMPRESSIONS_TIMEOUT);
        try {
            client.ackServerImpressions(ackRequest, ack_opts);
        }
        catch (Exception e) {
            log.error("[AckServerImpressions] occur error, msg:{}", (Object)e.getMessage());
        }
    }

    private static ByteplusSaasContent.PredictRequest buildPredictRequest() {
        ByteplusSaasContent.Scene scene = ByteplusSaasContent.Scene.newBuilder().setSceneName("*********").setOffset(10).build();
        ByteplusSaasContent.Content rootContent = MockHelper.mockPredictContent();
        ByteplusSaasContent.Device device = MockHelper.mockDevice();
        List<ByteplusSaasContent.Content> candidateContents = Arrays.asList(MockHelper.mockPredictContent(), MockHelper.mockPredictContent());
        ByteplusSaasContent.PredictRequest.Context context = ByteplusSaasContent.PredictRequest.Context.newBuilder().setRootContent(rootContent).setDevice(device).addAllCandidateContents(candidateContents).build();
        return ByteplusSaasContent.PredictRequest.newBuilder().setModelId("*********").setUserId("1457789").setSize(20).setScene(scene).setContentContext(context).build();
    }

    private static List<ByteplusSaasContent.AckServerImpressionsRequest.AlteredContent> doSomethingWithPredictResult(ByteplusSaasContent.PredictResult predictResult) {
        return Main.conv2AlteredContents(predictResult.getResponseContentsList());
    }

    @NotNull
    private static List<ByteplusSaasContent.AckServerImpressionsRequest.AlteredContent> conv2AlteredContents(List<ByteplusSaasContent.PredictResult.ResponseContent> contents) {
        if (Objects.isNull(contents) || contents.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ByteplusSaasContent.AckServerImpressionsRequest.AlteredContent> alteredContents = new ArrayList<ByteplusSaasContent.AckServerImpressionsRequest.AlteredContent>(contents.size());
        for (int i = 0; i < contents.size(); ++i) {
            ByteplusSaasContent.PredictResult.ResponseContent responseContent = contents.get(i);
            ByteplusSaasContent.AckServerImpressionsRequest.AlteredContent alteredContent = ByteplusSaasContent.AckServerImpressionsRequest.AlteredContent.newBuilder().setAlteredReason("kept").setContentId(responseContent.getContentId()).setRank(i + 1).build();
            alteredContents.add(alteredContent);
        }
        return alteredContents;
    }

    private static ByteplusSaasContent.AckServerImpressionsRequest buildAckRequest(String predictRequestId, ByteplusSaasContent.PredictRequest predictRequest, List<ByteplusSaasContent.AckServerImpressionsRequest.AlteredContent> alteredContents) {
        return ByteplusSaasContent.AckServerImpressionsRequest.newBuilder().setModelId(predictRequest.getModelId()).setPredictRequestId(predictRequestId).setUserId(predictRequest.getUserId()).setScene(predictRequest.getScene()).setTrafficSource("byteplus").addAllAlteredContents(alteredContents).build();
    }

    private static Option[] defaultOptions(Duration timeout2) {
        return new Option[]{Option.withRequestID(UUID.randomUUID().toString()), Option.withTimeout(timeout2)};
    }

    static {
        DEFAULT_WRITE_TIMEOUT = Duration.ofMillis(800L);
        DEFAULT_PREDICT_TIMEOUT = Duration.ofMillis(800L);
        DEFAULT_FINISH_TIMEOUT = Duration.ofMillis(800L);
        DEFAULT_ACK_IMPRESSIONS_TIMEOUT = Duration.ofMillis(800L);
        try {
            client = new ContentClientBuilder().accountID("*********").projectID("*********").region(Region.SG).authAK("*********").authSK("*********").build();
        }
        catch (BizException e) {
            log.error("fail to create byteplus rec client", e);
        }
    }
}

