/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.http;

import com.byteplus.http.ClientConfiguration;
import com.byteplus.http.IdleConnectionMonitorThread;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;

public class HttpClientFactory {
    public static HttpRequestRetryHandler httpRequestRetryHandler = new HttpRequestRetryHandler(){

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (executionCount >= 5) {
                return false;
            }
            if (exception instanceof NoHttpResponseException) {
                return true;
            }
            if (exception instanceof InterruptedIOException) {
                return false;
            }
            if (exception instanceof UnknownHostException) {
                return false;
            }
            if (exception instanceof ConnectTimeoutException) {
                return false;
            }
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            HttpRequest request = clientContext.getRequest();
            return !(request instanceof HttpEntityEnclosingRequest);
        }
    };
    private static ConnectionKeepAliveStrategy connectionKeepAliveStrategy;

    public static HttpClient create(ClientConfiguration configuration) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        int maxCon = configuration.getMaxConnections();
        int maxConPerRoute = configuration.getMaxConPerRoute();
        connectionManager.setMaxTotal(maxCon);
        connectionManager.setDefaultMaxPerRoute(maxConPerRoute);
        ConnectionKeepAliveStrategy strategy = connectionKeepAliveStrategy != null ? connectionKeepAliveStrategy : HttpClientFactory.getConnectionKeepAliveStrategy();
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setKeepAliveStrategy(strategy).setRetryHandler(httpRequestRetryHandler).setDefaultRequestConfig(RequestConfig.custom().setStaleConnectionCheckEnabled(true).build()).build();
        Thread deamonThread = new Thread(new IdleConnectionMonitorThread((HttpClientConnectionManager)connectionManager));
        deamonThread.setDaemon(true);
        deamonThread.start();
        return httpClient;
    }

    public static ClientInstance create(ClientConfiguration configuration, HttpHost proxy) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        int maxCon = configuration.getMaxConnections();
        int maxConPerRoute = configuration.getMaxConPerRoute();
        connectionManager.setMaxTotal(maxCon);
        connectionManager.setDefaultMaxPerRoute(maxConPerRoute);
        ConnectionKeepAliveStrategy strategy = connectionKeepAliveStrategy != null ? connectionKeepAliveStrategy : HttpClientFactory.getConnectionKeepAliveStrategy();
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setKeepAliveStrategy(strategy).setRetryHandler(httpRequestRetryHandler).setDefaultRequestConfig(RequestConfig.custom().setStaleConnectionCheckEnabled(true).build()).setProxy(proxy).build();
        IdleConnectionMonitorThread daemonThread = new IdleConnectionMonitorThread((HttpClientConnectionManager)connectionManager);
        daemonThread.setDaemon(true);
        daemonThread.start();
        return new ClientInstance((HttpClient)httpClient, daemonThread);
    }

    public static ConnectionKeepAliveStrategy getConnectionKeepAliveStrategy() {
        return new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                    return Long.parseLong(value) * 1000L;
                }
                return 60000L;
            }
        };
    }

    public static void setConnectionKeepAliveStrategy(ConnectionKeepAliveStrategy connectionKeepAliveStrategy) {
        HttpClientFactory.connectionKeepAliveStrategy = connectionKeepAliveStrategy;
    }

    public static class ClientInstance {
        private HttpClient httpClient;
        private IdleConnectionMonitorThread daemonThread;

        public HttpClient getHttpClient() {
            return this.httpClient;
        }

        public IdleConnectionMonitorThread getDaemonThread() {
            return this.daemonThread;
        }

        public ClientInstance(HttpClient httpClient, IdleConnectionMonitorThread daemonThread) {
            this.httpClient = httpClient;
            this.daemonThread = daemonThread;
        }
    }
}

