/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations.keycloak;

import com.c4_soft.springaddons.security.oauth2.test.annotations.IntClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.JsonArrayClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.JsonObjectClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.OpenIdAddress;
import com.c4_soft.springaddons.security.oauth2.test.annotations.OpenIdClaims;
import java.time.Instant;
import org.keycloak.representations.AddressClaimSet;
import org.keycloak.representations.IDToken;
import org.springframework.util.StringUtils;

class IDTokenBuilderHelper {
    private IDTokenBuilderHelper() {
    }

    public static IDToken feed(IDToken token, OpenIdClaims claimsAnnotation) {
        token.setAcr(claimsAnnotation.acr());
        token.audience(claimsAnnotation.aud());
        if (StringUtils.hasLength((String)claimsAnnotation.authTime())) {
            token.setAuth_time(Long.valueOf(Instant.parse(claimsAnnotation.authTime()).getEpochSecond()));
        }
        token.issuedFor(claimsAnnotation.azp());
        if (StringUtils.hasLength((String)claimsAnnotation.exp())) {
            token.exp(Long.valueOf(Instant.parse(claimsAnnotation.exp()).getEpochSecond()));
        }
        if (StringUtils.hasLength((String)claimsAnnotation.iat())) {
            token.iat(Long.valueOf(Instant.parse(claimsAnnotation.iat()).getEpochSecond()));
        }
        if (StringUtils.hasText((String)claimsAnnotation.iss())) {
            token.issuer(claimsAnnotation.iss());
        }
        if (StringUtils.hasText((String)claimsAnnotation.jti())) {
            token.id(claimsAnnotation.jti());
        }
        if (StringUtils.hasText((String)claimsAnnotation.nbf())) {
            token.nbf(Long.valueOf(Instant.parse(claimsAnnotation.nbf()).getEpochSecond()));
        }
        token.setNonce(claimsAnnotation.nonce());
        token.setSessionState(IDTokenBuilderHelper.nullIfEmpty(claimsAnnotation.sessionState()));
        token.subject(claimsAnnotation.sub());
        if (StringUtils.hasLength((String)claimsAnnotation.updatedAt())) {
            token.setUpdatedAt(Long.valueOf(Instant.parse(claimsAnnotation.updatedAt()).getEpochSecond()));
        }
        token.setAddress(IDTokenBuilderHelper.build(claimsAnnotation.address()));
        token.setBirthdate(IDTokenBuilderHelper.nullIfEmpty(claimsAnnotation.birthdate()));
        token.setEmail(IDTokenBuilderHelper.nullIfEmpty(claimsAnnotation.email()));
        token.setEmailVerified(Boolean.valueOf(claimsAnnotation.emailVerified()));
        token.setFamilyName(IDTokenBuilderHelper.nullIfEmpty(claimsAnnotation.familyName()));
        token.setGender(IDTokenBuilderHelper.nullIfEmpty(claimsAnnotation.gender()));
        token.setGivenName(IDTokenBuilderHelper.nullIfEmpty(claimsAnnotation.givenName()));
        token.setLocale(IDTokenBuilderHelper.nullIfEmpty(claimsAnnotation.locale()));
        token.setMiddleName(IDTokenBuilderHelper.nullIfEmpty(claimsAnnotation.middleName()));
        token.setName(IDTokenBuilderHelper.nullIfEmpty(claimsAnnotation.name()));
        token.setNickName(IDTokenBuilderHelper.nullIfEmpty(claimsAnnotation.nickName()));
        token.setPhoneNumber(IDTokenBuilderHelper.nullIfEmpty(claimsAnnotation.phoneNumber()));
        token.setPhoneNumberVerified(Boolean.valueOf(claimsAnnotation.phoneNumberVerified()));
        token.setPreferredUsername(IDTokenBuilderHelper.nullIfEmpty(claimsAnnotation.preferredUsername()));
        token.setPicture(IDTokenBuilderHelper.nullIfEmpty(claimsAnnotation.picture()));
        token.setProfile(IDTokenBuilderHelper.nullIfEmpty(claimsAnnotation.profile()));
        token.setWebsite(IDTokenBuilderHelper.nullIfEmpty(claimsAnnotation.website()));
        for (IntClaim intClaim : claimsAnnotation.otherClaims().intClaims()) {
            token.setOtherClaims(intClaim.name(), (Object)intClaim.value());
        }
        for (IntClaim intClaim : claimsAnnotation.otherClaims().longClaims()) {
            token.setOtherClaims(intClaim.name(), (Object)intClaim.value());
        }
        for (IntClaim intClaim : claimsAnnotation.otherClaims().stringClaims()) {
            token.setOtherClaims(intClaim.name(), (Object)intClaim.value());
        }
        for (IntClaim intClaim : claimsAnnotation.otherClaims().stringArrayClaims()) {
            token.setOtherClaims(intClaim.name(), (Object)intClaim.value());
        }
        for (IntClaim intClaim : claimsAnnotation.otherClaims().jsonObjectClaims()) {
            token.setOtherClaims(intClaim.name(), JsonObjectClaim.Support.parse((JsonObjectClaim)intClaim));
        }
        for (IntClaim intClaim : claimsAnnotation.otherClaims().jsonArrayClaims()) {
            token.setOtherClaims(intClaim.name(), JsonArrayClaim.Support.parse((JsonArrayClaim)intClaim));
        }
        return token;
    }

    private static AddressClaimSet build(OpenIdAddress addressAnnotation) {
        AddressClaimSet claims = new AddressClaimSet();
        claims.setCountry(IDTokenBuilderHelper.nullIfEmpty(addressAnnotation.country()));
        claims.setFormattedAddress(IDTokenBuilderHelper.nullIfEmpty(addressAnnotation.formattedAddress()));
        claims.setLocality(IDTokenBuilderHelper.nullIfEmpty(addressAnnotation.locality()));
        claims.setPostalCode(IDTokenBuilderHelper.nullIfEmpty(addressAnnotation.postalCode()));
        claims.setRegion(IDTokenBuilderHelper.nullIfEmpty(addressAnnotation.region()));
        claims.setStreetAddress(IDTokenBuilderHelper.nullIfEmpty(addressAnnotation.streetAddress()));
        return claims;
    }

    private static String nullIfEmpty(String str) {
        return StringUtils.hasText((String)str) ? str : null;
    }
}

