/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations;

import com.c4_soft.springaddons.security.oauth2.test.OpenidClaimSetBuilder;
import com.c4_soft.springaddons.security.oauth2.test.annotations.OpenIdClaims;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.test.context.support.WithSecurityContextFactory;

public abstract class AbstractAnnotatedAuthenticationBuilder<A extends Annotation, T extends Authentication>
implements WithSecurityContextFactory<A> {
    protected abstract T authentication(A var1);

    public SecurityContext createSecurityContext(A annotation) {
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        context.setAuthentication(this.authentication(annotation));
        return context;
    }

    public Set<GrantedAuthority> authorities(String ... authorities) {
        return Stream.of(authorities).map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
    }

    public OpenidClaimSetBuilder claims(OpenIdClaims annotation) {
        return OpenIdClaims.Builder.of(annotation).usernameClaim(annotation.usernameClaim());
    }

    protected T downcast() {
        return (T)((Authentication)this);
    }
}

