/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations;

import com.c4_soft.springaddons.security.oauth2.test.MockAuthenticationBuilder;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.mockito.Mockito;
import org.springframework.core.annotation.AliasFor;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.test.context.support.TestExecutionEvent;
import org.springframework.security.test.context.support.WithSecurityContext;
import org.springframework.security.test.context.support.WithSecurityContextFactory;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Inherited
@Documented
@WithSecurityContext(factory=Factory.class)
public @interface WithMockAuthentication {
    @AliasFor(value="authType")
    public Class<? extends Authentication> value() default Authentication.class;

    @AliasFor(value="value")
    public Class<? extends Authentication> authType() default Authentication.class;

    public Class<?> principalType() default String.class;

    public String name() default "user";

    public String[] authorities() default {};

    @AliasFor(annotation=WithSecurityContext.class)
    public TestExecutionEvent setupBefore() default TestExecutionEvent.TEST_METHOD;

    public static final class Factory
    implements WithSecurityContextFactory<WithMockAuthentication> {
        public SecurityContext createSecurityContext(WithMockAuthentication annotation) {
            SecurityContext context = SecurityContextHolder.createEmptyContext();
            context.setAuthentication(this.authentication(annotation));
            return context;
        }

        public Authentication authentication(WithMockAuthentication annotation) {
            return ((MockAuthenticationBuilder)((MockAuthenticationBuilder)new MockAuthenticationBuilder(annotation.authType(), Mockito.mock(annotation.principalType())).name(annotation.name())).authorities(annotation.authorities())).build();
        }
    }
}

