/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations;

import com.c4_soft.springaddons.security.oauth2.OpenidClaimSet;
import com.c4_soft.springaddons.security.oauth2.test.annotations.AbstractAnnotatedAuthenticationBuilder;
import com.c4_soft.springaddons.security.oauth2.test.annotations.OpenIdClaims;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AliasFor;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionAuthenticatedPrincipal;
import org.springframework.security.test.context.support.TestExecutionEvent;
import org.springframework.security.test.context.support.WithSecurityContext;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Inherited
@Documented
@WithSecurityContext(factory=AuthenticationFactory.class)
public @interface WithMockBearerTokenAuthentication {
    @AliasFor(value="authorities")
    public String[] value() default {};

    @AliasFor(value="value")
    public String[] authorities() default {};

    public OpenIdClaims attributes() default @OpenIdClaims;

    public String bearerString() default "machin.truc.chose";

    @AliasFor(annotation=WithSecurityContext.class)
    public TestExecutionEvent setupBefore() default TestExecutionEvent.TEST_METHOD;

    public static final class AuthenticationFactory
    extends AbstractAnnotatedAuthenticationBuilder<WithMockBearerTokenAuthentication, BearerTokenAuthentication> {
        @Override
        public BearerTokenAuthentication authentication(WithMockBearerTokenAuthentication annotation) {
            OpenidClaimSet claims = super.claims(annotation.attributes()).build();
            Set<GrantedAuthority> authorities = super.authorities(annotation.authorities(), annotation.value());
            OAuth2IntrospectionAuthenticatedPrincipal principal = new OAuth2IntrospectionAuthenticatedPrincipal(claims.getName(), (Map)claims, authorities);
            OAuth2AccessToken credentials = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, annotation.bearerString(), claims.getAsInstant("iat"), claims.getAsInstant("exp"));
            return new BearerTokenAuthentication((OAuth2AuthenticatedPrincipal)principal, credentials, authorities);
        }
    }
}

