/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations.parameterized;

import com.c4_soft.springaddons.security.oauth2.OAuthentication;
import com.c4_soft.springaddons.security.oauth2.OpenidClaimSet;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.junit.jupiter.params.converter.ConvertWith;
import org.junit.jupiter.params.converter.TypedArgumentConverter;
import org.springframework.security.core.context.SecurityContextHolder;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@ConvertWith(value=AuthenticationArgumentProcessor.class)
public @interface ParameterizedOpenId {

    public static class AuthenticationArgumentProcessor
    extends TypedArgumentConverter<OAuthentication<OpenidClaimSet>, OAuthentication<OpenidClaimSet>> {
        private static Class<OAuthentication<OpenidClaimSet>> clazz;

        protected AuthenticationArgumentProcessor() {
            super(clazz, clazz);
        }

        protected OAuthentication<OpenidClaimSet> convert(OAuthentication<OpenidClaimSet> source) {
            SecurityContextHolder.getContext().setAuthentication(source);
            return source;
        }

        static {
            try {
                clazz = Class.forName(OAuthentication.class.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

