/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations;

import com.c4_soft.springaddons.security.oauth2.test.annotations.InvalidJsonException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StringUtils;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface ClasspathClaims {
    public String value() default "";

    public static final class Support {
        private Support() {
        }

        public static Map<String, Object> parse(ClasspathClaims claim) {
            InputStream cpRessource;
            if (claim == null || !StringUtils.hasText((String)claim.value())) {
                return Map.of();
            }
            try {
                cpRessource = new ClassPathResource(claim.value()).getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load classpath resource %s as OpenID claims".formatted(claim.value()), e);
            }
            try {
                return (Map)new JSONParser(-1).parse(cpRessource, JSONObject.class);
            }
            catch (UnsupportedEncodingException | ParseException e) {
                throw new InvalidJsonException(e);
            }
        }
    }
}

