/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations;

import com.c4_soft.springaddons.security.oauth2.test.annotations.ClasspathClaims;
import com.c4_soft.springaddons.security.oauth2.test.annotations.DoubleClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.IntClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.JsonFileClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.JsonObjectArrayClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.JsonObjectClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.LongClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.StringArrayClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.StringClaim;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface NestedClaims {
    public String name();

    public IntClaim[] intClaims() default {};

    public LongClaim[] longClaims() default {};

    public DoubleClaim[] doubleClaims() default {};

    public StringClaim[] stringClaims() default {};

    public StringClaim[] uriClaims() default {};

    public StringClaim[] urlClaims() default {};

    public IntClaim[] epochSecondClaims() default {};

    public StringClaim[] dateClaims() default {};

    public StringArrayClaim[] stringArrayClaims() default {};

    public JsonFileClaim[] jsonFiles() default {};

    public JsonObjectClaim[] jsonObjectClaims() default {};

    public JsonObjectArrayClaim[] jsonObjectArrayClaims() default {};

    public static class Support {
        private static final SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");

        private Support() {
        }

        public static Map<String, Object> parse(NestedClaims annotation) throws MalformedURLException, ParseException {
            HashMap<String, Object> claims = new HashMap<String, Object>();
            for (JsonFileClaim jsonFileClaim : annotation.jsonFiles()) {
                claims.put(jsonFileClaim.name(), ClasspathClaims.Support.parse(jsonFileClaim.value()));
            }
            for (Annotation annotation2 : annotation.jsonObjectClaims()) {
                claims.put(annotation2.name(), JsonObjectClaim.Support.parse((JsonObjectClaim)annotation2));
            }
            for (Annotation annotation3 : annotation.intClaims()) {
                claims.put(annotation3.name(), annotation3.value());
            }
            for (Annotation annotation4 : annotation.longClaims()) {
                claims.put(annotation4.name(), annotation4.value());
            }
            for (Annotation annotation5 : annotation.doubleClaims()) {
                claims.put(annotation5.name(), annotation5.value());
            }
            for (Annotation annotation6 : annotation.stringClaims()) {
                claims.put(annotation6.name(), annotation6.value());
            }
            for (Annotation annotation7 : annotation.uriClaims()) {
                claims.put(annotation7.name(), URI.create(annotation7.value()));
            }
            for (Annotation annotation8 : annotation.urlClaims()) {
                claims.put(annotation8.name(), new URL(annotation8.value()));
            }
            for (Annotation annotation9 : annotation.epochSecondClaims()) {
                claims.put(annotation9.name(), new Date(1000L * (long)annotation9.value()));
            }
            for (Annotation annotation10 : annotation.dateClaims()) {
                claims.put(annotation10.name(), isoFormat.parse(annotation10.value()));
            }
            for (Annotation annotation11 : annotation.stringArrayClaims()) {
                claims.put(annotation11.name(), annotation11.value());
            }
            for (Annotation annotation12 : annotation.jsonObjectArrayClaims()) {
                claims.put(annotation12.name(), JsonObjectArrayClaim.Support.parse((JsonObjectArrayClaim)annotation12));
            }
            return Collections.unmodifiableMap(claims);
        }
    }
}

