/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations.parameterized;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.junit.jupiter.params.converter.ConvertWith;
import org.junit.jupiter.params.converter.TypedArgumentConverter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@ConvertWith(value=AuthenticationArgumentProcessor.class)
public @interface ParameterizedBearerAuth {

    public static class AuthenticationArgumentProcessor
    extends TypedArgumentConverter<BearerTokenAuthentication, BearerTokenAuthentication> {
        protected AuthenticationArgumentProcessor() {
            super(BearerTokenAuthentication.class, BearerTokenAuthentication.class);
        }

        protected BearerTokenAuthentication convert(BearerTokenAuthentication source) {
            SecurityContextHolder.getContext().setAuthentication((Authentication)source);
            return source;
        }
    }
}

