/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.springframework.core.annotation.AliasFor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.test.context.support.WithSecurityContext;
import org.springframework.security.test.context.support.WithSecurityContextFactory;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Inherited
@Documented
@WithSecurityContext(factory=AuthenticationFactory.class)
public @interface WithJwt {
    @AliasFor(value="file")
    public String value() default "";

    @AliasFor(value="value")
    public String file() default "";

    public String json() default "";

    public String bearerString() default "test.jwt.bearer";

    public String headers() default "{\"alg\": \"none\"}";

    public static final class AuthenticationFactory
    implements WithSecurityContextFactory<WithJwt> {
        static final String DEFAULT_BEARER = "test.jwt.bearer";
        static final String DEFAULT_HEADERS = "{\"alg\": \"none\"}";
        private final Optional<Converter<Jwt, ? extends AbstractAuthenticationToken>> jwtAuthenticationConverter;
        private final Optional<Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>>> reactiveJwtAuthenticationConverter;

        public SecurityContext createSecurityContext(WithJwt annotation) {
            AbstractAuthenticationToken auth = this.authentication(annotation);
            SecurityContext securityContext = SecurityContextHolder.createEmptyContext();
            securityContext.setAuthentication((Authentication)auth);
            return securityContext;
        }

        public AbstractAuthenticationToken authentication(WithJwt annotation) {
            Map<String, Object> headers = AuthenticationFactory.parseJson(annotation.headers());
            HashMap<String, Object> claims = new HashMap<String, Object>();
            if (StringUtils.hasText((String)annotation.value())) {
                claims.putAll(AuthenticationFactory.parseFile(annotation.value()));
            }
            if (StringUtils.hasText((String)annotation.file())) {
                claims.putAll(AuthenticationFactory.parseFile(annotation.file()));
            }
            if (StringUtils.hasText((String)annotation.json())) {
                claims.putAll(AuthenticationFactory.parseJson(annotation.json()));
            }
            return this.authentication(claims, headers, annotation.bearerString());
        }

        public AbstractAuthenticationToken authentication(Map<String, Object> claims, Map<String, Object> headers, String bearerString) {
            Instant now = Instant.now();
            Instant iat = Optional.ofNullable((Integer)claims.get("iat")).map(Instant::ofEpochSecond).orElse(now);
            Instant exp = Optional.ofNullable((Integer)claims.get("exp")).map(Instant::ofEpochSecond).orElse(now.plusSeconds(42L));
            Jwt jwt = new Jwt(bearerString, iat, exp, headers, claims);
            return this.jwtAuthenticationConverter.map(c -> {
                AbstractAuthenticationToken auth = (AbstractAuthenticationToken)c.convert((Object)jwt);
                return auth;
            }).orElseGet(() -> this.reactiveJwtAuthenticationConverter.map(c -> {
                AbstractAuthenticationToken auth = (AbstractAuthenticationToken)((Mono)c.convert((Object)jwt)).block();
                return auth;
            }).orElseThrow(() -> new RuntimeException("Missing jwtAuthenticationConverter bean")));
        }

        public Stream<AbstractAuthenticationToken> authenticationsFrom(String ... classpathResources) {
            return Stream.of(classpathResources).map(AuthenticationFactory::parseFile).map(claims -> this.authentication((Map<String, Object>)claims, AuthenticationFactory.parseJson(DEFAULT_HEADERS), DEFAULT_BEARER));
        }

        public static Map<String, Object> parseFile(String fileName) {
            InputStream cpRessource;
            if (!StringUtils.hasText((String)fileName)) {
                return Map.of();
            }
            try {
                cpRessource = new ClassPathResource(fileName).getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load classpath resource %s".formatted(fileName), e);
            }
            try {
                return (Map)new JSONParser(-1).parse(cpRessource, JSONObject.class);
            }
            catch (UnsupportedEncodingException | ParseException e) {
                throw new RuntimeException("Invalid JWT payload in classpath resource %s".formatted(fileName));
            }
        }

        public static Map<String, Object> parseJson(String json) {
            if (!StringUtils.hasText((String)json)) {
                return Map.of();
            }
            try {
                return (Map)new JSONParser(-1).parse(json, JSONObject.class);
            }
            catch (ParseException e) {
                throw new RuntimeException("Invalid JSON payload in @WithJwt");
            }
        }

        @Generated
        public AuthenticationFactory(Optional<Converter<Jwt, ? extends AbstractAuthenticationToken>> jwtAuthenticationConverter, Optional<Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>>> reactiveJwtAuthenticationConverter) {
            this.jwtAuthenticationConverter = jwtAuthenticationConverter;
            this.reactiveJwtAuthenticationConverter = reactiveJwtAuthenticationConverter;
        }
    }
}

