/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.springframework.core.annotation.AliasFor;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenAuthenticationConverter;
import org.springframework.security.test.context.support.WithSecurityContext;
import org.springframework.security.test.context.support.WithSecurityContextFactory;
import org.springframework.util.StringUtils;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Inherited
@Documented
@WithSecurityContext(factory=AuthenticationFactory.class)
public @interface WithOpaqueToken {
    @AliasFor(value="file")
    public String value() default "";

    @AliasFor(value="value")
    public String file() default "";

    public String json() default "";

    public String bearerString() default "test.jwt.bearer";

    public static final class AuthenticationFactory
    implements WithSecurityContextFactory<WithOpaqueToken> {
        static final String DEFAULT_BEARER = "test.jwt.bearer";
        private final Optional<OpaqueTokenAuthenticationConverter> opaqueTokenAuthenticationConverter;
        private final Optional<ReactiveOpaqueTokenAuthenticationConverter> reactiveOpaqueTokenAuthenticationConverter;

        public SecurityContext createSecurityContext(WithOpaqueToken annotation) {
            Authentication auth = this.authentication(annotation);
            SecurityContext securityContext = SecurityContextHolder.createEmptyContext();
            securityContext.setAuthentication(auth);
            return securityContext;
        }

        public Authentication authentication(WithOpaqueToken annotation) {
            HashMap<String, Object> claims = new HashMap<String, Object>();
            if (StringUtils.hasText((String)annotation.value())) {
                claims.putAll(AuthenticationFactory.parseFile(annotation.value()));
            }
            if (StringUtils.hasText((String)annotation.file())) {
                claims.putAll(AuthenticationFactory.parseFile(annotation.file()));
            }
            if (StringUtils.hasText((String)annotation.json())) {
                claims.putAll(AuthenticationFactory.parseJson(annotation.json()));
            }
            return this.authentication(claims, annotation.bearerString());
        }

        public Authentication authentication(final Map<String, Object> claims, String bearerString) {
            OAuth2AuthenticatedPrincipal principal = new OAuth2AuthenticatedPrincipal(){

                public String getName() {
                    return null;
                }

                public Collection<? extends GrantedAuthority> getAuthorities() {
                    return null;
                }

                public Map<String, Object> getAttributes() {
                    return claims;
                }
            };
            return this.opaqueTokenAuthenticationConverter.map(arg_0 -> AuthenticationFactory.lambda$authentication$0(bearerString, principal, arg_0)).orElseGet(() -> this.lambda$authentication$3(bearerString, principal));
        }

        public Stream<Authentication> authenticationsFrom(String ... classpathResources) {
            return Stream.of(classpathResources).map(AuthenticationFactory::parseFile).map(claims -> this.authentication((Map<String, Object>)claims, DEFAULT_BEARER));
        }

        public static Map<String, Object> parseFile(String fileName) {
            InputStream cpRessource;
            if (!StringUtils.hasText((String)fileName)) {
                return Map.of();
            }
            try {
                cpRessource = new ClassPathResource(fileName).getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load classpath resource %s".formatted(fileName), e);
            }
            try {
                return (Map)new JSONParser(-1).parse(cpRessource, JSONObject.class);
            }
            catch (UnsupportedEncodingException | ParseException e) {
                throw new RuntimeException("Invalid user claims payload in classpath resource %s".formatted(fileName));
            }
        }

        public static Map<String, Object> parseJson(String json) {
            if (!StringUtils.hasText((String)json)) {
                return Map.of();
            }
            try {
                return (Map)new JSONParser(-1).parse(json, JSONObject.class);
            }
            catch (ParseException e) {
                throw new RuntimeException("Invalid JSON payload in @WithOpaqueToken");
            }
        }

        @Generated
        public AuthenticationFactory(Optional<OpaqueTokenAuthenticationConverter> opaqueTokenAuthenticationConverter, Optional<ReactiveOpaqueTokenAuthenticationConverter> reactiveOpaqueTokenAuthenticationConverter) {
            this.opaqueTokenAuthenticationConverter = opaqueTokenAuthenticationConverter;
            this.reactiveOpaqueTokenAuthenticationConverter = reactiveOpaqueTokenAuthenticationConverter;
        }

        private /* synthetic */ Authentication lambda$authentication$3(String bearerString, 1 principal) {
            return this.reactiveOpaqueTokenAuthenticationConverter.map(c -> {
                Authentication auth = (Authentication)c.convert(bearerString, (OAuth2AuthenticatedPrincipal)principal).block();
                return auth;
            }).orElseThrow(() -> new RuntimeException("Missing opaque token authentication converter bean"));
        }

        private static /* synthetic */ Authentication lambda$authentication$0(String bearerString, 1 principal, OpaqueTokenAuthenticationConverter c) {
            Authentication auth = c.convert(bearerString, (OAuth2AuthenticatedPrincipal)principal);
            return auth;
        }
    }
}

