/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test;

import com.c4_soft.springaddons.security.oauth2.test.AuthenticationBuilder;
import com.c4_soft.springaddons.security.oauth2.test.Defaults;
import com.c4_soft.springaddons.security.oauth2.test.OpenidClaimSetBuilder;
import com.c4_soft.springaddons.security.oidc.OAuthentication;
import com.c4_soft.springaddons.security.oidc.OpenidClaimSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class OAuthenticationTestingBuilder<T extends OAuthenticationTestingBuilder<T>>
implements AuthenticationBuilder<OAuthentication<OpenidClaimSet>> {
    protected final OpenidClaimSetBuilder tokenBuilder = new OpenidClaimSetBuilder().subject("user").name("user");
    private final Set<String> authorities = new HashSet<String>(Defaults.AUTHORITIES);
    private String bearerString = "machin.truc.chose";

    @Override
    public OAuthentication<OpenidClaimSet> build() {
        return new OAuthentication((Map)this.tokenBuilder.build(), (Collection)this.authorities.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toSet()), this.bearerString);
    }

    public T authorities(String ... authorities) {
        this.authorities.clear();
        this.authorities.addAll(Arrays.asList(authorities));
        return this.downcast();
    }

    public T token(Consumer<OpenidClaimSetBuilder> tokenBuilderConsumer) {
        tokenBuilderConsumer.accept(this.tokenBuilder);
        return this.downcast();
    }

    public T bearerString(String bearerString) {
        this.bearerString = bearerString;
        return this.downcast();
    }

    protected T downcast() {
        return (T)this;
    }
}

