/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations;

import com.c4_soft.springaddons.security.oauth2.test.OpenidClaimSetBuilder;
import com.c4_soft.springaddons.security.oauth2.test.annotations.Claims;
import com.c4_soft.springaddons.security.oauth2.test.annotations.ClasspathClaims;
import com.c4_soft.springaddons.security.oauth2.test.annotations.InvalidClaimException;
import com.c4_soft.springaddons.security.oauth2.test.annotations.InvalidJsonException;
import com.c4_soft.springaddons.security.oauth2.test.annotations.OpenIdAddress;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.springframework.util.StringUtils;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface OpenIdClaims {
    public String acr() default "";

    public String[] amr() default {};

    public String[] aud() default {};

    public String azp() default "";

    public String authTime() default "";

    public String exp() default "";

    public String iat() default "";

    public String jti() default "";

    public String nbf() default "";

    public String iss() default "";

    public String nonce() default "";

    public String sub() default "user";

    public String sessionState() default "";

    public String accessTokenHash() default "";

    public String authorizationCodeHash() default "";

    public OpenIdAddress address() default @OpenIdAddress;

    public String birthdate() default "";

    public String email() default "";

    public boolean emailVerified() default false;

    public String familyName() default "";

    public String gender() default "";

    public String givenName() default "";

    public String locale() default "";

    public String middleName() default "";

    public String name() default "";

    public String nickName() default "";

    public String phoneNumber() default "";

    public boolean phoneNumberVerified() default false;

    public String picture() default "";

    public String preferredUsername() default "";

    public String profile() default "";

    public String updatedAt() default "";

    public String website() default "";

    public String zoneinfo() default "";

    public Claims otherClaims() default @Claims;

    public String usernameClaim() default "sub";

    public ClasspathClaims jsonFile() default @ClasspathClaims;

    public String json() default "";

    public static class Builder {
        private Builder() {
        }

        public static OpenidClaimSetBuilder of(OpenIdClaims tokenAnnotation) {
            OpenidClaimSetBuilder token = new OpenidClaimSetBuilder();
            token.putAll(ClasspathClaims.Support.parse(tokenAnnotation.jsonFile().value()));
            if (StringUtils.hasText((String)tokenAnnotation.json())) {
                try {
                    token.putAll((Map)new JSONParser(-8193).parse(tokenAnnotation.json(), JSONObject.class));
                }
                catch (ParseException e) {
                    throw new InvalidJsonException(e);
                }
            }
            token.putAll((Map)Claims.Token.of(tokenAnnotation.otherClaims()));
            token.name(tokenAnnotation.usernameClaim());
            if (StringUtils.hasText((String)tokenAnnotation.iss())) {
                try {
                    token.issuer(new URL(tokenAnnotation.iss()));
                }
                catch (MalformedURLException e) {
                    throw new InvalidClaimException(e);
                }
            }
            if (StringUtils.hasLength((String)tokenAnnotation.exp())) {
                token.expiresAt(Instant.parse(tokenAnnotation.exp()));
            }
            if (StringUtils.hasLength((String)tokenAnnotation.iat())) {
                token.issuedAt(Instant.parse(tokenAnnotation.iat()));
            }
            if (StringUtils.hasLength((String)tokenAnnotation.authTime())) {
                token.authTime(Instant.parse(tokenAnnotation.authTime()));
            }
            if (StringUtils.hasLength((String)tokenAnnotation.sessionState())) {
                token.sessionState(tokenAnnotation.sessionState());
            }
            if (StringUtils.hasLength((String)tokenAnnotation.sessionState())) {
                token.accessTokenHash(tokenAnnotation.accessTokenHash());
            }
            if (StringUtils.hasLength((String)tokenAnnotation.sessionState())) {
                token.authorizationCodeHash(tokenAnnotation.authorizationCodeHash());
            }
            ((OpenidClaimSetBuilder)((Object)((OpenidClaimSetBuilder)((Object)((OpenidClaimSetBuilder)((Object)((OpenidClaimSetBuilder)((Object)((OpenidClaimSetBuilder)((Object)token.subject(tokenAnnotation.sub()))).audience(Arrays.asList(tokenAnnotation.aud())))).nonce(tokenAnnotation.nonce()))).acr(tokenAnnotation.acr()))).amr(Arrays.asList(tokenAnnotation.amr())))).azp(tokenAnnotation.azp());
            if (StringUtils.hasLength((String)tokenAnnotation.updatedAt())) {
                token.updatedAt(Instant.parse(tokenAnnotation.updatedAt()));
            }
            if (StringUtils.hasLength((String)tokenAnnotation.preferredUsername())) {
                token.preferredUsername(tokenAnnotation.preferredUsername());
            }
            return ((OpenidClaimSetBuilder)((Object)((OpenidClaimSetBuilder)((Object)((OpenidClaimSetBuilder)((Object)((OpenidClaimSetBuilder)((Object)((OpenidClaimSetBuilder)((Object)((OpenidClaimSetBuilder)((Object)((OpenidClaimSetBuilder)((Object)((OpenidClaimSetBuilder)((Object)((OpenidClaimSetBuilder)((Object)((OpenidClaimSetBuilder)((Object)((OpenidClaimSetBuilder)((Object)((OpenidClaimSetBuilder)((Object)((OpenidClaimSetBuilder)((Object)((OpenidClaimSetBuilder)((Object)((OpenidClaimSetBuilder)((Object)((OpenidClaimSetBuilder)((Object)token.address(OpenIdAddress.Claim.of(tokenAnnotation.address())))).birthdate(Builder.nullIfEmpty(tokenAnnotation.birthdate())))).email(Builder.nullIfEmpty(tokenAnnotation.email())))).emailVerified(tokenAnnotation.emailVerified()))).familyName(Builder.nullIfEmpty(tokenAnnotation.familyName())))).gender(Builder.nullIfEmpty(tokenAnnotation.gender())))).givenName(Builder.nullIfEmpty(tokenAnnotation.givenName())))).jwtId(tokenAnnotation.jti()))).locale(Builder.nullIfEmpty(tokenAnnotation.locale())))).middleName(Builder.nullIfEmpty(tokenAnnotation.middleName())))).name(Builder.nullIfEmpty(tokenAnnotation.name())))).nickname(Builder.nullIfEmpty(tokenAnnotation.nickName())))).phoneNumber(Builder.nullIfEmpty(tokenAnnotation.phoneNumber())))).phoneNumberVerified(tokenAnnotation.phoneNumberVerified()))).picture(Builder.nullIfEmpty(tokenAnnotation.picture())))).profile(Builder.nullIfEmpty(tokenAnnotation.profile())))).website(Builder.nullIfEmpty(tokenAnnotation.website()));
        }

        private static String nullIfEmpty(String str) {
            return StringUtils.hasText((String)str) ? str : null;
        }
    }
}

