/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.test.support.web;

import com.c4_soft.springaddons.test.support.web.ByteArrayHttpOutputMessage;
import com.c4_soft.springaddons.test.support.web.ConversionFailedException;
import java.io.IOException;
import java.util.List;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverters;

public class SerializationHelper {
    private final ObjectFactory<HttpMessageConverters> messageConverters;

    public SerializationHelper(ObjectFactory<HttpMessageConverters> messageConverters) {
        this.messageConverters = messageConverters;
    }

    public <T> ByteArrayHttpOutputMessage outputMessage(T payload, MediaType mediaType) {
        if (payload == null) {
            return null;
        }
        List<HttpMessageConverter> relevantConverters = StreamSupport.stream(((HttpMessageConverters)this.messageConverters.getObject()).spliterator(), false).filter(converter -> converter.canWrite(payload.getClass(), mediaType)).map(c -> c).toList();
        ByteArrayHttpOutputMessage converted = new ByteArrayHttpOutputMessage();
        boolean isConverted = false;
        for (HttpMessageConverter converter2 : relevantConverters) {
            try {
                converted.headers.setContentType(mediaType);
                converter2.write(payload, mediaType, (HttpOutputMessage)converted);
                isConverted = true;
                break;
            }
            catch (IOException iOException) {
            }
        }
        if (!isConverted) {
            throw new ConversionFailedException("Could not convert " + payload.getClass() + " to " + mediaType.toString());
        }
        return converted;
    }

    public <T> String asString(T payload, MediaType mediaType) {
        return payload == null ? null : this.outputMessage(payload, (MediaType)mediaType).out.toString();
    }

    public <T> String asJsonString(T payload) {
        return this.asString(payload, MediaType.APPLICATION_JSON);
    }

    public <T> String asXmlnString(T payload) {
        return this.asString(payload, MediaType.APPLICATION_XML);
    }
}

