/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config;

import java.net.URI;
import java.util.Arrays;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="com.c4-soft.springaddons.security")
public class SpringAddonsSecurityProperties {
    private IssuerProperties[] issuers = new IssuerProperties[0];
    private CorsProperties[] cors = new CorsProperties[0];
    private String[] permitAll = new String[]{"/actuator/**", "/v3/api-docs/**", "/swagger-ui/**", "/swagger-ui.html", "/webjars/swagger-ui/**", "/favicon.ico"};
    private boolean redirectToLoginIfUnauthorizedOnRestrictedContent = false;
    private boolean statlessSessions = true;
    private Csrf csrf = Csrf.DEFAULT;

    @Generated
    public SpringAddonsSecurityProperties() {
    }

    @Generated
    public IssuerProperties[] getIssuers() {
        return this.issuers;
    }

    @Generated
    public CorsProperties[] getCors() {
        return this.cors;
    }

    @Generated
    public String[] getPermitAll() {
        return this.permitAll;
    }

    @Generated
    public boolean isRedirectToLoginIfUnauthorizedOnRestrictedContent() {
        return this.redirectToLoginIfUnauthorizedOnRestrictedContent;
    }

    @Generated
    public boolean isStatlessSessions() {
        return this.statlessSessions;
    }

    @Generated
    public Csrf getCsrf() {
        return this.csrf;
    }

    @Generated
    public void setIssuers(IssuerProperties[] issuers) {
        this.issuers = issuers;
    }

    @Generated
    public void setCors(CorsProperties[] cors) {
        this.cors = cors;
    }

    @Generated
    public void setPermitAll(String[] permitAll) {
        this.permitAll = permitAll;
    }

    @Generated
    public void setRedirectToLoginIfUnauthorizedOnRestrictedContent(boolean redirectToLoginIfUnauthorizedOnRestrictedContent) {
        this.redirectToLoginIfUnauthorizedOnRestrictedContent = redirectToLoginIfUnauthorizedOnRestrictedContent;
    }

    @Generated
    public void setStatlessSessions(boolean statlessSessions) {
        this.statlessSessions = statlessSessions;
    }

    @Generated
    public void setCsrf(Csrf csrf) {
        this.csrf = csrf;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringAddonsSecurityProperties)) {
            return false;
        }
        SpringAddonsSecurityProperties other = (SpringAddonsSecurityProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRedirectToLoginIfUnauthorizedOnRestrictedContent() != other.isRedirectToLoginIfUnauthorizedOnRestrictedContent()) {
            return false;
        }
        if (this.isStatlessSessions() != other.isStatlessSessions()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getIssuers(), other.getIssuers())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCors(), other.getCors())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPermitAll(), other.getPermitAll())) {
            return false;
        }
        Csrf this$csrf = this.getCsrf();
        Csrf other$csrf = other.getCsrf();
        return !(this$csrf == null ? other$csrf != null : !((Object)((Object)this$csrf)).equals((Object)other$csrf));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpringAddonsSecurityProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRedirectToLoginIfUnauthorizedOnRestrictedContent() ? 79 : 97);
        result = result * 59 + (this.isStatlessSessions() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getIssuers());
        result = result * 59 + Arrays.deepHashCode(this.getCors());
        result = result * 59 + Arrays.deepHashCode(this.getPermitAll());
        Csrf $csrf = this.getCsrf();
        result = result * 59 + ($csrf == null ? 43 : ((Object)((Object)$csrf)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SpringAddonsSecurityProperties(issuers=" + Arrays.deepToString(this.getIssuers()) + ", cors=" + Arrays.deepToString(this.getCors()) + ", permitAll=" + Arrays.deepToString(this.getPermitAll()) + ", redirectToLoginIfUnauthorizedOnRestrictedContent=" + this.isRedirectToLoginIfUnauthorizedOnRestrictedContent() + ", statlessSessions=" + this.isStatlessSessions() + ", csrf=" + (Object)((Object)this.getCsrf()) + ")";
    }

    public static enum Csrf {
        DEFAULT,
        DISABLE,
        SESSION,
        COOKIE_HTTP_ONLY,
        COOKIE_ACCESSIBLE_FROM_JS;

    }

    public static enum Case {
        UNCHANGED,
        UPPER,
        LOWER;

    }

    public static class SimpleAuthoritiesMappingProperties {
        private String[] claims = new String[]{"realm_access.roles"};
        private String prefix = "";
        private Case caze = Case.UNCHANGED;

        @Generated
        public SimpleAuthoritiesMappingProperties() {
        }

        @Generated
        public String[] getClaims() {
            return this.claims;
        }

        @Generated
        public String getPrefix() {
            return this.prefix;
        }

        @Generated
        public Case getCaze() {
            return this.caze;
        }

        @Generated
        public void setClaims(String[] claims) {
            this.claims = claims;
        }

        @Generated
        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Generated
        public void setCaze(Case caze) {
            this.caze = caze;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimpleAuthoritiesMappingProperties)) {
                return false;
            }
            SimpleAuthoritiesMappingProperties other = (SimpleAuthoritiesMappingProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getClaims(), other.getClaims())) {
                return false;
            }
            String this$prefix = this.getPrefix();
            String other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Case this$caze = this.getCaze();
            Case other$caze = other.getCaze();
            return !(this$caze == null ? other$caze != null : !((Object)((Object)this$caze)).equals((Object)other$caze));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SimpleAuthoritiesMappingProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getClaims());
            String $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Case $caze = this.getCaze();
            result = result * 59 + ($caze == null ? 43 : ((Object)((Object)$caze)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SpringAddonsSecurityProperties.SimpleAuthoritiesMappingProperties(claims=" + Arrays.deepToString(this.getClaims()) + ", prefix=" + this.getPrefix() + ", caze=" + (Object)((Object)this.getCaze()) + ")";
        }
    }

    public static class IssuerProperties {
        private URI location;
        private URI jwkSetUri;
        private SimpleAuthoritiesMappingProperties authorities = new SimpleAuthoritiesMappingProperties();

        @Generated
        public IssuerProperties() {
        }

        @Generated
        public URI getLocation() {
            return this.location;
        }

        @Generated
        public URI getJwkSetUri() {
            return this.jwkSetUri;
        }

        @Generated
        public SimpleAuthoritiesMappingProperties getAuthorities() {
            return this.authorities;
        }

        @Generated
        public void setLocation(URI location) {
            this.location = location;
        }

        @Generated
        public void setJwkSetUri(URI jwkSetUri) {
            this.jwkSetUri = jwkSetUri;
        }

        @Generated
        public void setAuthorities(SimpleAuthoritiesMappingProperties authorities) {
            this.authorities = authorities;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IssuerProperties)) {
                return false;
            }
            IssuerProperties other = (IssuerProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            URI this$location = this.getLocation();
            URI other$location = other.getLocation();
            if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
                return false;
            }
            URI this$jwkSetUri = this.getJwkSetUri();
            URI other$jwkSetUri = other.getJwkSetUri();
            if (this$jwkSetUri == null ? other$jwkSetUri != null : !((Object)this$jwkSetUri).equals(other$jwkSetUri)) {
                return false;
            }
            SimpleAuthoritiesMappingProperties this$authorities = this.getAuthorities();
            SimpleAuthoritiesMappingProperties other$authorities = other.getAuthorities();
            return !(this$authorities == null ? other$authorities != null : !((Object)this$authorities).equals(other$authorities));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof IssuerProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URI $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
            URI $jwkSetUri = this.getJwkSetUri();
            result = result * 59 + ($jwkSetUri == null ? 43 : ((Object)$jwkSetUri).hashCode());
            SimpleAuthoritiesMappingProperties $authorities = this.getAuthorities();
            result = result * 59 + ($authorities == null ? 43 : ((Object)$authorities).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SpringAddonsSecurityProperties.IssuerProperties(location=" + this.getLocation() + ", jwkSetUri=" + this.getJwkSetUri() + ", authorities=" + this.getAuthorities() + ")";
        }
    }

    public static class CorsProperties {
        private String path = "/**";
        private String[] allowedOrigins = new String[]{"*"};
        private String[] allowedMethods = new String[]{"*"};
        private String[] allowedHeaders = new String[]{"*"};
        private String[] exposedHeaders = new String[]{"*"};

        @Generated
        public CorsProperties() {
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public String[] getAllowedOrigins() {
            return this.allowedOrigins;
        }

        @Generated
        public String[] getAllowedMethods() {
            return this.allowedMethods;
        }

        @Generated
        public String[] getAllowedHeaders() {
            return this.allowedHeaders;
        }

        @Generated
        public String[] getExposedHeaders() {
            return this.exposedHeaders;
        }

        @Generated
        public void setPath(String path) {
            this.path = path;
        }

        @Generated
        public void setAllowedOrigins(String[] allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
        }

        @Generated
        public void setAllowedMethods(String[] allowedMethods) {
            this.allowedMethods = allowedMethods;
        }

        @Generated
        public void setAllowedHeaders(String[] allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
        }

        @Generated
        public void setExposedHeaders(String[] exposedHeaders) {
            this.exposedHeaders = exposedHeaders;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CorsProperties)) {
                return false;
            }
            CorsProperties other = (CorsProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAllowedOrigins(), other.getAllowedOrigins())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAllowedMethods(), other.getAllowedMethods())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAllowedHeaders(), other.getAllowedHeaders())) {
                return false;
            }
            return Arrays.deepEquals(this.getExposedHeaders(), other.getExposedHeaders());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CorsProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getAllowedOrigins());
            result = result * 59 + Arrays.deepHashCode(this.getAllowedMethods());
            result = result * 59 + Arrays.deepHashCode(this.getAllowedHeaders());
            result = result * 59 + Arrays.deepHashCode(this.getExposedHeaders());
            return result;
        }

        @Generated
        public String toString() {
            return "SpringAddonsSecurityProperties.CorsProperties(path=" + this.getPath() + ", allowedOrigins=" + Arrays.deepToString(this.getAllowedOrigins()) + ", allowedMethods=" + Arrays.deepToString(this.getAllowedMethods()) + ", allowedHeaders=" + Arrays.deepToString(this.getAllowedHeaders()) + ", exposedHeaders=" + Arrays.deepToString(this.getExposedHeaders()) + ")";
        }
    }
}

