/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2;

import com.c4_soft.springaddons.security.oauth2.UnparsableClaimException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public interface ClaimSet
extends Map<String, Object>,
Serializable {
    default public String getAsString(String name) {
        Object claim = this.get(name);
        return claim == null ? null : claim.toString();
    }

    @Nullable
    default public Instant getAsInstant(String name) {
        Object claim = this.get(name);
        if (claim == null) {
            return null;
        }
        if (claim instanceof Long) {
            return Instant.ofEpochSecond((Long)claim);
        }
        if (claim instanceof Instant) {
            return (Instant)claim;
        }
        if (claim instanceof String) {
            return Instant.parse((String)claim);
        }
        throw new UnparsableClaimException("claim " + name + " is of unsupported type " + claim.getClass().getName());
    }

    @Nullable
    default public Set<String> getAsStringSet(String name) {
        Object claim = this.get(name);
        if (claim == null) {
            return null;
        }
        if (claim instanceof Collection) {
            return ((Collection)claim).stream().flatMap(o -> Stream.of(o.toString().split(" "))).collect(Collectors.toSet());
        }
        return Stream.of(claim.toString().split(" ")).collect(Collectors.toSet());
    }

    @Nullable
    default public URI getAsUri(String name) throws URISyntaxException {
        Object claim = this.get(name);
        if (claim == null) {
            return null;
        }
        if (claim instanceof URI) {
            return (URI)claim;
        }
        return new URI(claim.toString());
    }

    @Nullable
    default public Boolean getAsBoolean(String name) {
        Object claim = this.get(name);
        if (claim == null) {
            return null;
        }
        if (claim instanceof Boolean) {
            return (Boolean)claim;
        }
        return Boolean.valueOf(claim.toString());
    }

    default public ClaimSet claim(String claimName, String claimValue) {
        Assert.hasLength((String)claimName, (String)"claimName can't be empty");
        if (StringUtils.hasLength((String)claimValue)) {
            this.put(claimName, claimValue);
        } else {
            this.remove(claimName);
        }
        return this;
    }

    default public ClaimSet claim(String claimName, Collection<?> claimValue) {
        Assert.hasLength((String)claimName, (String)"claimName can't be empty");
        if (claimValue == null || claimValue.isEmpty()) {
            this.remove(claimName);
        } else {
            this.put(claimName, claimValue);
        }
        return this;
    }

    default public ClaimSet claim(String claimName, Object claimValue) {
        Assert.hasLength((String)claimName, (String)"claimName can't be empty");
        if (claimValue == null) {
            this.remove(claimName);
        } else {
            this.put(claimName, claimValue);
        }
        return this;
    }
}

