/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config;

import com.c4_soft.springaddons.security.oauth2.config.OAuth2AuthoritiesConverter;
import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsSecurityProperties;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.StringUtils;

public class ConfigurableClaimSet2AuthoritiesConverter
implements OAuth2AuthoritiesConverter {
    private final SpringAddonsSecurityProperties properties;

    public Collection<? extends GrantedAuthority> convert(Map<String, Object> source) {
        SpringAddonsSecurityProperties.SimpleAuthoritiesMappingProperties[] authoritiesMappingProperties = this.getAuthoritiesMappingProperties(source);
        return Stream.of(authoritiesMappingProperties).flatMap(authoritiesMappingProps -> ConfigurableClaimSet2AuthoritiesConverter.getAuthorities(source, authoritiesMappingProps)).map(r -> new SimpleGrantedAuthority(r)).toList();
    }

    private static String processCase(String role, SpringAddonsSecurityProperties.Case caze) {
        switch (caze) {
            case UPPER: {
                return role.toUpperCase();
            }
            case LOWER: {
                return role.toLowerCase();
            }
        }
        return role;
    }

    private SpringAddonsSecurityProperties.SimpleAuthoritiesMappingProperties[] getAuthoritiesMappingProperties(Map<String, Object> claimSet) {
        Object iss = Optional.ofNullable(claimSet.get("iss")).orElse(null);
        return this.properties.getIssuerProperties((Object)iss).getAuthorities();
    }

    private static Stream<String> getAuthorities(Map<String, Object> claims, SpringAddonsSecurityProperties.SimpleAuthoritiesMappingProperties props) {
        return ConfigurableClaimSet2AuthoritiesConverter.getClaims(claims, props.getPath()).flatMap(claim -> Stream.of(claim.split(","))).flatMap(claim -> Stream.of(claim.split(" "))).filter(StringUtils::hasText).map(String::trim).map(r -> ConfigurableClaimSet2AuthoritiesConverter.processCase(r, props.getCaze())).map(r -> String.format("%s%s", props.getPrefix(), r));
    }

    private static Stream<String> getClaims(Map<String, Object> claims, String path) {
        try {
            Object res = JsonPath.read(claims, (String)path, (Predicate[])new Predicate[0]);
            if (res instanceof String) {
                String r = (String)res;
                return Stream.of(r);
            }
            if (res instanceof List) {
                List l = (List)res;
                if (l.size() == 0) {
                    return Stream.empty();
                }
                if (l.get(0) instanceof String) {
                    return l.stream();
                }
                if (l.get(0) instanceof List) {
                    return l.stream().flatMap(o -> ((List)o).stream());
                }
            }
            return Stream.empty();
        }
        catch (PathNotFoundException e) {
            return Stream.empty();
        }
    }

    @Generated
    public ConfigurableClaimSet2AuthoritiesConverter(SpringAddonsSecurityProperties properties) {
        this.properties = properties;
    }
}

