/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config;

import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsSecurityProperties;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.web.util.UriComponentsBuilder;

@AutoConfiguration
@ConfigurationProperties(prefix="com.c4-soft.springaddons.security.client")
public class SpringAddonsOAuth2ClientProperties {
    private boolean enabled = true;
    private URI clientUri = URI.create("/");
    private String postLogoutRedirectPath;
    @NestedConfigurationProperty
    private OAuth2LogoutProperties[] oauth2Logout = new OAuth2LogoutProperties[0];
    private boolean backChannelLogoutEnabled = false;
    private String[] securityMatchers;
    private String[] permitAll = new String[]{"/login/**", "/oauth2/**"};
    private Optional<String> loginPath = Optional.empty();
    private Optional<String> postLoginRedirectPath = Optional.empty();
    private SpringAddonsSecurityProperties.Csrf csrf = SpringAddonsSecurityProperties.Csrf.SESSION;
    @NestedConfigurationProperty
    private SpringAddonsSecurityProperties.CorsProperties[] cors = new SpringAddonsSecurityProperties.CorsProperties[0];

    public URI getPostLogoutRedirectUri() {
        return UriComponentsBuilder.fromUri((URI)this.clientUri).path(this.postLogoutRedirectPath).build(Map.of());
    }

    public Optional<OAuth2LogoutProperties> getLogoutProperties(String clientRegistrationId) {
        return Stream.of(this.oauth2Logout).filter(logoutProps -> Objects.equals(clientRegistrationId, logoutProps.getClientRegistrationId())).findAny();
    }

    @Generated
    public SpringAddonsOAuth2ClientProperties() {
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public URI getClientUri() {
        return this.clientUri;
    }

    @Generated
    public String getPostLogoutRedirectPath() {
        return this.postLogoutRedirectPath;
    }

    @Generated
    public OAuth2LogoutProperties[] getOauth2Logout() {
        return this.oauth2Logout;
    }

    @Generated
    public boolean isBackChannelLogoutEnabled() {
        return this.backChannelLogoutEnabled;
    }

    @Generated
    public String[] getSecurityMatchers() {
        return this.securityMatchers;
    }

    @Generated
    public String[] getPermitAll() {
        return this.permitAll;
    }

    @Generated
    public Optional<String> getLoginPath() {
        return this.loginPath;
    }

    @Generated
    public Optional<String> getPostLoginRedirectPath() {
        return this.postLoginRedirectPath;
    }

    @Generated
    public SpringAddonsSecurityProperties.Csrf getCsrf() {
        return this.csrf;
    }

    @Generated
    public SpringAddonsSecurityProperties.CorsProperties[] getCors() {
        return this.cors;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setClientUri(URI clientUri) {
        this.clientUri = clientUri;
    }

    @Generated
    public void setPostLogoutRedirectPath(String postLogoutRedirectPath) {
        this.postLogoutRedirectPath = postLogoutRedirectPath;
    }

    @Generated
    public void setOauth2Logout(OAuth2LogoutProperties[] oauth2Logout) {
        this.oauth2Logout = oauth2Logout;
    }

    @Generated
    public void setBackChannelLogoutEnabled(boolean backChannelLogoutEnabled) {
        this.backChannelLogoutEnabled = backChannelLogoutEnabled;
    }

    @Generated
    public void setSecurityMatchers(String[] securityMatchers) {
        this.securityMatchers = securityMatchers;
    }

    @Generated
    public void setPermitAll(String[] permitAll) {
        this.permitAll = permitAll;
    }

    @Generated
    public void setLoginPath(Optional<String> loginPath) {
        this.loginPath = loginPath;
    }

    @Generated
    public void setPostLoginRedirectPath(Optional<String> postLoginRedirectPath) {
        this.postLoginRedirectPath = postLoginRedirectPath;
    }

    @Generated
    public void setCsrf(SpringAddonsSecurityProperties.Csrf csrf) {
        this.csrf = csrf;
    }

    @Generated
    public void setCors(SpringAddonsSecurityProperties.CorsProperties[] cors) {
        this.cors = cors;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringAddonsOAuth2ClientProperties)) {
            return false;
        }
        SpringAddonsOAuth2ClientProperties other = (SpringAddonsOAuth2ClientProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isBackChannelLogoutEnabled() != other.isBackChannelLogoutEnabled()) {
            return false;
        }
        URI this$clientUri = this.getClientUri();
        URI other$clientUri = other.getClientUri();
        if (this$clientUri == null ? other$clientUri != null : !((Object)this$clientUri).equals(other$clientUri)) {
            return false;
        }
        String this$postLogoutRedirectPath = this.getPostLogoutRedirectPath();
        String other$postLogoutRedirectPath = other.getPostLogoutRedirectPath();
        if (this$postLogoutRedirectPath == null ? other$postLogoutRedirectPath != null : !this$postLogoutRedirectPath.equals(other$postLogoutRedirectPath)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOauth2Logout(), other.getOauth2Logout())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSecurityMatchers(), other.getSecurityMatchers())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPermitAll(), other.getPermitAll())) {
            return false;
        }
        Optional<String> this$loginPath = this.getLoginPath();
        Optional<String> other$loginPath = other.getLoginPath();
        if (this$loginPath == null ? other$loginPath != null : !((Object)this$loginPath).equals(other$loginPath)) {
            return false;
        }
        Optional<String> this$postLoginRedirectPath = this.getPostLoginRedirectPath();
        Optional<String> other$postLoginRedirectPath = other.getPostLoginRedirectPath();
        if (this$postLoginRedirectPath == null ? other$postLoginRedirectPath != null : !((Object)this$postLoginRedirectPath).equals(other$postLoginRedirectPath)) {
            return false;
        }
        SpringAddonsSecurityProperties.Csrf this$csrf = this.getCsrf();
        SpringAddonsSecurityProperties.Csrf other$csrf = other.getCsrf();
        if (this$csrf == null ? other$csrf != null : !((Object)((Object)this$csrf)).equals((Object)other$csrf)) {
            return false;
        }
        return Arrays.deepEquals(this.getCors(), other.getCors());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpringAddonsOAuth2ClientProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isBackChannelLogoutEnabled() ? 79 : 97);
        URI $clientUri = this.getClientUri();
        result = result * 59 + ($clientUri == null ? 43 : ((Object)$clientUri).hashCode());
        String $postLogoutRedirectPath = this.getPostLogoutRedirectPath();
        result = result * 59 + ($postLogoutRedirectPath == null ? 43 : $postLogoutRedirectPath.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getOauth2Logout());
        result = result * 59 + Arrays.deepHashCode(this.getSecurityMatchers());
        result = result * 59 + Arrays.deepHashCode(this.getPermitAll());
        Optional<String> $loginPath = this.getLoginPath();
        result = result * 59 + ($loginPath == null ? 43 : ((Object)$loginPath).hashCode());
        Optional<String> $postLoginRedirectPath = this.getPostLoginRedirectPath();
        result = result * 59 + ($postLoginRedirectPath == null ? 43 : ((Object)$postLoginRedirectPath).hashCode());
        SpringAddonsSecurityProperties.Csrf $csrf = this.getCsrf();
        result = result * 59 + ($csrf == null ? 43 : ((Object)((Object)$csrf)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getCors());
        return result;
    }

    @Generated
    public String toString() {
        return "SpringAddonsOAuth2ClientProperties(enabled=" + this.isEnabled() + ", clientUri=" + this.getClientUri() + ", postLogoutRedirectPath=" + this.getPostLogoutRedirectPath() + ", oauth2Logout=" + Arrays.deepToString(this.getOauth2Logout()) + ", backChannelLogoutEnabled=" + this.isBackChannelLogoutEnabled() + ", securityMatchers=" + Arrays.deepToString(this.getSecurityMatchers()) + ", permitAll=" + Arrays.deepToString(this.getPermitAll()) + ", loginPath=" + this.getLoginPath() + ", postLoginRedirectPath=" + this.getPostLoginRedirectPath() + ", csrf=" + this.getCsrf() + ", cors=" + Arrays.deepToString(this.getCors()) + ")";
    }

    public static class OAuth2LogoutProperties {
        private String clientRegistrationId;
        private URI uri;
        private Optional<String> clientIdRequestParam = Optional.empty();
        private Optional<String> postLogoutUriRequestParam = Optional.empty();
        private Optional<String> idTokenHintRequestParam = Optional.empty();

        @Generated
        public OAuth2LogoutProperties() {
        }

        @Generated
        public String getClientRegistrationId() {
            return this.clientRegistrationId;
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public Optional<String> getClientIdRequestParam() {
            return this.clientIdRequestParam;
        }

        @Generated
        public Optional<String> getPostLogoutUriRequestParam() {
            return this.postLogoutUriRequestParam;
        }

        @Generated
        public Optional<String> getIdTokenHintRequestParam() {
            return this.idTokenHintRequestParam;
        }

        @Generated
        public void setClientRegistrationId(String clientRegistrationId) {
            this.clientRegistrationId = clientRegistrationId;
        }

        @Generated
        public void setUri(URI uri) {
            this.uri = uri;
        }

        @Generated
        public void setClientIdRequestParam(Optional<String> clientIdRequestParam) {
            this.clientIdRequestParam = clientIdRequestParam;
        }

        @Generated
        public void setPostLogoutUriRequestParam(Optional<String> postLogoutUriRequestParam) {
            this.postLogoutUriRequestParam = postLogoutUriRequestParam;
        }

        @Generated
        public void setIdTokenHintRequestParam(Optional<String> idTokenHintRequestParam) {
            this.idTokenHintRequestParam = idTokenHintRequestParam;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OAuth2LogoutProperties)) {
                return false;
            }
            OAuth2LogoutProperties other = (OAuth2LogoutProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$clientRegistrationId = this.getClientRegistrationId();
            String other$clientRegistrationId = other.getClientRegistrationId();
            if (this$clientRegistrationId == null ? other$clientRegistrationId != null : !this$clientRegistrationId.equals(other$clientRegistrationId)) {
                return false;
            }
            URI this$uri = this.getUri();
            URI other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
                return false;
            }
            Optional<String> this$clientIdRequestParam = this.getClientIdRequestParam();
            Optional<String> other$clientIdRequestParam = other.getClientIdRequestParam();
            if (this$clientIdRequestParam == null ? other$clientIdRequestParam != null : !((Object)this$clientIdRequestParam).equals(other$clientIdRequestParam)) {
                return false;
            }
            Optional<String> this$postLogoutUriRequestParam = this.getPostLogoutUriRequestParam();
            Optional<String> other$postLogoutUriRequestParam = other.getPostLogoutUriRequestParam();
            if (this$postLogoutUriRequestParam == null ? other$postLogoutUriRequestParam != null : !((Object)this$postLogoutUriRequestParam).equals(other$postLogoutUriRequestParam)) {
                return false;
            }
            Optional<String> this$idTokenHintRequestParam = this.getIdTokenHintRequestParam();
            Optional<String> other$idTokenHintRequestParam = other.getIdTokenHintRequestParam();
            return !(this$idTokenHintRequestParam == null ? other$idTokenHintRequestParam != null : !((Object)this$idTokenHintRequestParam).equals(other$idTokenHintRequestParam));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OAuth2LogoutProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $clientRegistrationId = this.getClientRegistrationId();
            result = result * 59 + ($clientRegistrationId == null ? 43 : $clientRegistrationId.hashCode());
            URI $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
            Optional<String> $clientIdRequestParam = this.getClientIdRequestParam();
            result = result * 59 + ($clientIdRequestParam == null ? 43 : ((Object)$clientIdRequestParam).hashCode());
            Optional<String> $postLogoutUriRequestParam = this.getPostLogoutUriRequestParam();
            result = result * 59 + ($postLogoutUriRequestParam == null ? 43 : ((Object)$postLogoutUriRequestParam).hashCode());
            Optional<String> $idTokenHintRequestParam = this.getIdTokenHintRequestParam();
            result = result * 59 + ($idTokenHintRequestParam == null ? 43 : ((Object)$idTokenHintRequestParam).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SpringAddonsOAuth2ClientProperties.OAuth2LogoutProperties(clientRegistrationId=" + this.getClientRegistrationId() + ", uri=" + this.getUri() + ", clientIdRequestParam=" + this.getClientIdRequestParam() + ", postLogoutUriRequestParam=" + this.getPostLogoutUriRequestParam() + ", idTokenHintRequestParam=" + this.getIdTokenHintRequestParam() + ")";
        }
    }
}

