/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config;

import com.c4_soft.springaddons.security.oauth2.config.MissingAuthorizationServerConfigurationException;
import java.net.URI;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@AutoConfiguration
@ConfigurationProperties(prefix="com.c4-soft.springaddons.security")
public class SpringAddonsSecurityProperties {
    private boolean enabled = true;
    @NestedConfigurationProperty
    private IssuerProperties[] issuers = new IssuerProperties[0];
    @NestedConfigurationProperty
    private CorsProperties[] cors = new CorsProperties[0];
    private String[] permitAll = new String[0];
    private boolean redirectToLoginIfUnauthorizedOnRestrictedContent = false;
    private boolean statlessSessions = true;
    private Csrf csrf = Csrf.DEFAULT;

    public IssuerProperties getIssuerProperties(String iss) throws MissingAuthorizationServerConfigurationException {
        return Stream.of(this.issuers).filter(issuerProps -> Objects.equals(Optional.ofNullable(issuerProps.getLocation()).map(URI::toString).orElse(null), iss)).findAny().orElseThrow(() -> new MissingAuthorizationServerConfigurationException(iss));
    }

    public IssuerProperties getIssuerProperties(Object iss) throws MissingAuthorizationServerConfigurationException {
        if (iss == null && this.issuers.length == 1) {
            return this.issuers[0];
        }
        return this.getIssuerProperties((String)Optional.ofNullable(iss).map(Object::toString).orElse(null));
    }

    @Generated
    public SpringAddonsSecurityProperties() {
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public IssuerProperties[] getIssuers() {
        return this.issuers;
    }

    @Generated
    public CorsProperties[] getCors() {
        return this.cors;
    }

    @Generated
    public String[] getPermitAll() {
        return this.permitAll;
    }

    @Generated
    public boolean isRedirectToLoginIfUnauthorizedOnRestrictedContent() {
        return this.redirectToLoginIfUnauthorizedOnRestrictedContent;
    }

    @Generated
    public boolean isStatlessSessions() {
        return this.statlessSessions;
    }

    @Generated
    public Csrf getCsrf() {
        return this.csrf;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setIssuers(IssuerProperties[] issuers) {
        this.issuers = issuers;
    }

    @Generated
    public void setCors(CorsProperties[] cors) {
        this.cors = cors;
    }

    @Generated
    public void setPermitAll(String[] permitAll) {
        this.permitAll = permitAll;
    }

    @Generated
    public void setRedirectToLoginIfUnauthorizedOnRestrictedContent(boolean redirectToLoginIfUnauthorizedOnRestrictedContent) {
        this.redirectToLoginIfUnauthorizedOnRestrictedContent = redirectToLoginIfUnauthorizedOnRestrictedContent;
    }

    @Generated
    public void setStatlessSessions(boolean statlessSessions) {
        this.statlessSessions = statlessSessions;
    }

    @Generated
    public void setCsrf(Csrf csrf) {
        this.csrf = csrf;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringAddonsSecurityProperties)) {
            return false;
        }
        SpringAddonsSecurityProperties other = (SpringAddonsSecurityProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isRedirectToLoginIfUnauthorizedOnRestrictedContent() != other.isRedirectToLoginIfUnauthorizedOnRestrictedContent()) {
            return false;
        }
        if (this.isStatlessSessions() != other.isStatlessSessions()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getIssuers(), other.getIssuers())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCors(), other.getCors())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPermitAll(), other.getPermitAll())) {
            return false;
        }
        Csrf this$csrf = this.getCsrf();
        Csrf other$csrf = other.getCsrf();
        return !(this$csrf == null ? other$csrf != null : !((Object)((Object)this$csrf)).equals((Object)other$csrf));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpringAddonsSecurityProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isRedirectToLoginIfUnauthorizedOnRestrictedContent() ? 79 : 97);
        result = result * 59 + (this.isStatlessSessions() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getIssuers());
        result = result * 59 + Arrays.deepHashCode(this.getCors());
        result = result * 59 + Arrays.deepHashCode(this.getPermitAll());
        Csrf $csrf = this.getCsrf();
        result = result * 59 + ($csrf == null ? 43 : ((Object)((Object)$csrf)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SpringAddonsSecurityProperties(enabled=" + this.isEnabled() + ", issuers=" + Arrays.deepToString(this.getIssuers()) + ", cors=" + Arrays.deepToString(this.getCors()) + ", permitAll=" + Arrays.deepToString(this.getPermitAll()) + ", redirectToLoginIfUnauthorizedOnRestrictedContent=" + this.isRedirectToLoginIfUnauthorizedOnRestrictedContent() + ", statlessSessions=" + this.isStatlessSessions() + ", csrf=" + this.getCsrf() + ")";
    }

    public static class IssuerProperties {
        private URI location;
        private URI jwkSetUri;
        @NestedConfigurationProperty
        private SimpleAuthoritiesMappingProperties[] authorities = new SimpleAuthoritiesMappingProperties[]{new SimpleAuthoritiesMappingProperties()};
        private String usernameClaim = "sub";

        @Generated
        public IssuerProperties() {
        }

        @Generated
        public URI getLocation() {
            return this.location;
        }

        @Generated
        public URI getJwkSetUri() {
            return this.jwkSetUri;
        }

        @Generated
        public SimpleAuthoritiesMappingProperties[] getAuthorities() {
            return this.authorities;
        }

        @Generated
        public String getUsernameClaim() {
            return this.usernameClaim;
        }

        @Generated
        public void setLocation(URI location) {
            this.location = location;
        }

        @Generated
        public void setJwkSetUri(URI jwkSetUri) {
            this.jwkSetUri = jwkSetUri;
        }

        @Generated
        public void setAuthorities(SimpleAuthoritiesMappingProperties[] authorities) {
            this.authorities = authorities;
        }

        @Generated
        public void setUsernameClaim(String usernameClaim) {
            this.usernameClaim = usernameClaim;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IssuerProperties)) {
                return false;
            }
            IssuerProperties other = (IssuerProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            URI this$location = this.getLocation();
            URI other$location = other.getLocation();
            if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
                return false;
            }
            URI this$jwkSetUri = this.getJwkSetUri();
            URI other$jwkSetUri = other.getJwkSetUri();
            if (this$jwkSetUri == null ? other$jwkSetUri != null : !((Object)this$jwkSetUri).equals(other$jwkSetUri)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAuthorities(), other.getAuthorities())) {
                return false;
            }
            String this$usernameClaim = this.getUsernameClaim();
            String other$usernameClaim = other.getUsernameClaim();
            return !(this$usernameClaim == null ? other$usernameClaim != null : !this$usernameClaim.equals(other$usernameClaim));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof IssuerProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URI $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
            URI $jwkSetUri = this.getJwkSetUri();
            result = result * 59 + ($jwkSetUri == null ? 43 : ((Object)$jwkSetUri).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getAuthorities());
            String $usernameClaim = this.getUsernameClaim();
            result = result * 59 + ($usernameClaim == null ? 43 : $usernameClaim.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SpringAddonsSecurityProperties.IssuerProperties(location=" + this.getLocation() + ", jwkSetUri=" + this.getJwkSetUri() + ", authorities=" + Arrays.deepToString(this.getAuthorities()) + ", usernameClaim=" + this.getUsernameClaim() + ")";
        }
    }

    public static class CorsProperties {
        private String path = "/**";
        private String[] allowedOrigins = new String[]{"*"};
        private String[] allowedMethods = new String[]{"*"};
        private String[] allowedHeaders = new String[]{"*"};
        private String[] exposedHeaders = new String[]{"*"};

        @Generated
        public CorsProperties() {
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public String[] getAllowedOrigins() {
            return this.allowedOrigins;
        }

        @Generated
        public String[] getAllowedMethods() {
            return this.allowedMethods;
        }

        @Generated
        public String[] getAllowedHeaders() {
            return this.allowedHeaders;
        }

        @Generated
        public String[] getExposedHeaders() {
            return this.exposedHeaders;
        }

        @Generated
        public void setPath(String path) {
            this.path = path;
        }

        @Generated
        public void setAllowedOrigins(String[] allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
        }

        @Generated
        public void setAllowedMethods(String[] allowedMethods) {
            this.allowedMethods = allowedMethods;
        }

        @Generated
        public void setAllowedHeaders(String[] allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
        }

        @Generated
        public void setExposedHeaders(String[] exposedHeaders) {
            this.exposedHeaders = exposedHeaders;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CorsProperties)) {
                return false;
            }
            CorsProperties other = (CorsProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAllowedOrigins(), other.getAllowedOrigins())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAllowedMethods(), other.getAllowedMethods())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAllowedHeaders(), other.getAllowedHeaders())) {
                return false;
            }
            return Arrays.deepEquals(this.getExposedHeaders(), other.getExposedHeaders());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CorsProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getAllowedOrigins());
            result = result * 59 + Arrays.deepHashCode(this.getAllowedMethods());
            result = result * 59 + Arrays.deepHashCode(this.getAllowedHeaders());
            result = result * 59 + Arrays.deepHashCode(this.getExposedHeaders());
            return result;
        }

        @Generated
        public String toString() {
            return "SpringAddonsSecurityProperties.CorsProperties(path=" + this.getPath() + ", allowedOrigins=" + Arrays.deepToString(this.getAllowedOrigins()) + ", allowedMethods=" + Arrays.deepToString(this.getAllowedMethods()) + ", allowedHeaders=" + Arrays.deepToString(this.getAllowedHeaders()) + ", exposedHeaders=" + Arrays.deepToString(this.getExposedHeaders()) + ")";
        }
    }

    public static enum Csrf {
        DEFAULT,
        DISABLE,
        SESSION,
        COOKIE_HTTP_ONLY,
        COOKIE_ACCESSIBLE_FROM_JS;

    }

    public static enum Case {
        UNCHANGED,
        UPPER,
        LOWER;

    }

    public static class SimpleAuthoritiesMappingProperties {
        private String path = "$.realm_access.roles";
        private String prefix = "";
        private Case caze = Case.UNCHANGED;

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public String getPrefix() {
            return this.prefix;
        }

        @Generated
        public Case getCaze() {
            return this.caze;
        }

        @Generated
        public void setPath(String path) {
            this.path = path;
        }

        @Generated
        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Generated
        public void setCaze(Case caze) {
            this.caze = caze;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimpleAuthoritiesMappingProperties)) {
                return false;
            }
            SimpleAuthoritiesMappingProperties other = (SimpleAuthoritiesMappingProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$prefix = this.getPrefix();
            String other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Case this$caze = this.getCaze();
            Case other$caze = other.getCaze();
            return !(this$caze == null ? other$caze != null : !((Object)((Object)this$caze)).equals((Object)other$caze));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SimpleAuthoritiesMappingProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Case $caze = this.getCaze();
            result = result * 59 + ($caze == null ? 43 : ((Object)((Object)$caze)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SpringAddonsSecurityProperties.SimpleAuthoritiesMappingProperties(path=" + this.getPath() + ", prefix=" + this.getPrefix() + ", caze=" + this.getCaze() + ")";
        }

        @Generated
        public SimpleAuthoritiesMappingProperties() {
        }

        @Generated
        public SimpleAuthoritiesMappingProperties(String path, String prefix, Case caze) {
            this.path = path;
            this.prefix = prefix;
            this.caze = caze;
        }
    }
}

