/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config;

import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.web.util.UriComponentsBuilder;

@AutoConfiguration
@ConfigurationProperties(prefix="com.c4-soft.springaddons.security.client")
public class SpringAddonsOAuth2ClientProperties {
    private URI clientUri;
    private String postLogoutRedirectPath;
    private OAuth2LogoutProperties[] oauth2Logout = new OAuth2LogoutProperties[0];

    public URI getPostLogoutRedirectUri() {
        return UriComponentsBuilder.fromUri((URI)this.clientUri).path(this.postLogoutRedirectPath).build(Map.of());
    }

    public Optional<OAuth2LogoutProperties> getLogoutProperties(String clientRegistrationId) {
        return Stream.of(this.oauth2Logout).filter(logoutProps -> Objects.equals(clientRegistrationId, logoutProps.getClientRegistrationId())).findAny();
    }

    @Generated
    public SpringAddonsOAuth2ClientProperties() {
    }

    @Generated
    public URI getClientUri() {
        return this.clientUri;
    }

    @Generated
    public String getPostLogoutRedirectPath() {
        return this.postLogoutRedirectPath;
    }

    @Generated
    public OAuth2LogoutProperties[] getOauth2Logout() {
        return this.oauth2Logout;
    }

    @Generated
    public void setClientUri(URI clientUri) {
        this.clientUri = clientUri;
    }

    @Generated
    public void setPostLogoutRedirectPath(String postLogoutRedirectPath) {
        this.postLogoutRedirectPath = postLogoutRedirectPath;
    }

    @Generated
    public void setOauth2Logout(OAuth2LogoutProperties[] oauth2Logout) {
        this.oauth2Logout = oauth2Logout;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringAddonsOAuth2ClientProperties)) {
            return false;
        }
        SpringAddonsOAuth2ClientProperties other = (SpringAddonsOAuth2ClientProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$clientUri = this.getClientUri();
        URI other$clientUri = other.getClientUri();
        if (this$clientUri == null ? other$clientUri != null : !((Object)this$clientUri).equals(other$clientUri)) {
            return false;
        }
        String this$postLogoutRedirectPath = this.getPostLogoutRedirectPath();
        String other$postLogoutRedirectPath = other.getPostLogoutRedirectPath();
        if (this$postLogoutRedirectPath == null ? other$postLogoutRedirectPath != null : !this$postLogoutRedirectPath.equals(other$postLogoutRedirectPath)) {
            return false;
        }
        return Arrays.deepEquals(this.getOauth2Logout(), other.getOauth2Logout());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpringAddonsOAuth2ClientProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $clientUri = this.getClientUri();
        result = result * 59 + ($clientUri == null ? 43 : ((Object)$clientUri).hashCode());
        String $postLogoutRedirectPath = this.getPostLogoutRedirectPath();
        result = result * 59 + ($postLogoutRedirectPath == null ? 43 : $postLogoutRedirectPath.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getOauth2Logout());
        return result;
    }

    @Generated
    public String toString() {
        return "SpringAddonsOAuth2ClientProperties(clientUri=" + this.getClientUri() + ", postLogoutRedirectPath=" + this.getPostLogoutRedirectPath() + ", oauth2Logout=" + Arrays.deepToString(this.getOauth2Logout()) + ")";
    }

    public static class OAuth2LogoutProperties {
        private String clientRegistrationId;
        private URI uri;
        private Optional<String> clientIdRequestParam = Optional.empty();
        private Optional<String> postLogoutUriRequestParam = Optional.empty();
        private Optional<String> idTokenHintRequestParam = Optional.empty();

        @Generated
        public OAuth2LogoutProperties() {
        }

        @Generated
        public String getClientRegistrationId() {
            return this.clientRegistrationId;
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public Optional<String> getClientIdRequestParam() {
            return this.clientIdRequestParam;
        }

        @Generated
        public Optional<String> getPostLogoutUriRequestParam() {
            return this.postLogoutUriRequestParam;
        }

        @Generated
        public Optional<String> getIdTokenHintRequestParam() {
            return this.idTokenHintRequestParam;
        }

        @Generated
        public void setClientRegistrationId(String clientRegistrationId) {
            this.clientRegistrationId = clientRegistrationId;
        }

        @Generated
        public void setUri(URI uri) {
            this.uri = uri;
        }

        @Generated
        public void setClientIdRequestParam(Optional<String> clientIdRequestParam) {
            this.clientIdRequestParam = clientIdRequestParam;
        }

        @Generated
        public void setPostLogoutUriRequestParam(Optional<String> postLogoutUriRequestParam) {
            this.postLogoutUriRequestParam = postLogoutUriRequestParam;
        }

        @Generated
        public void setIdTokenHintRequestParam(Optional<String> idTokenHintRequestParam) {
            this.idTokenHintRequestParam = idTokenHintRequestParam;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OAuth2LogoutProperties)) {
                return false;
            }
            OAuth2LogoutProperties other = (OAuth2LogoutProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$clientRegistrationId = this.getClientRegistrationId();
            String other$clientRegistrationId = other.getClientRegistrationId();
            if (this$clientRegistrationId == null ? other$clientRegistrationId != null : !this$clientRegistrationId.equals(other$clientRegistrationId)) {
                return false;
            }
            URI this$uri = this.getUri();
            URI other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
                return false;
            }
            Optional<String> this$clientIdRequestParam = this.getClientIdRequestParam();
            Optional<String> other$clientIdRequestParam = other.getClientIdRequestParam();
            if (this$clientIdRequestParam == null ? other$clientIdRequestParam != null : !((Object)this$clientIdRequestParam).equals(other$clientIdRequestParam)) {
                return false;
            }
            Optional<String> this$postLogoutUriRequestParam = this.getPostLogoutUriRequestParam();
            Optional<String> other$postLogoutUriRequestParam = other.getPostLogoutUriRequestParam();
            if (this$postLogoutUriRequestParam == null ? other$postLogoutUriRequestParam != null : !((Object)this$postLogoutUriRequestParam).equals(other$postLogoutUriRequestParam)) {
                return false;
            }
            Optional<String> this$idTokenHintRequestParam = this.getIdTokenHintRequestParam();
            Optional<String> other$idTokenHintRequestParam = other.getIdTokenHintRequestParam();
            return !(this$idTokenHintRequestParam == null ? other$idTokenHintRequestParam != null : !((Object)this$idTokenHintRequestParam).equals(other$idTokenHintRequestParam));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OAuth2LogoutProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $clientRegistrationId = this.getClientRegistrationId();
            result = result * 59 + ($clientRegistrationId == null ? 43 : $clientRegistrationId.hashCode());
            URI $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
            Optional<String> $clientIdRequestParam = this.getClientIdRequestParam();
            result = result * 59 + ($clientIdRequestParam == null ? 43 : ((Object)$clientIdRequestParam).hashCode());
            Optional<String> $postLogoutUriRequestParam = this.getPostLogoutUriRequestParam();
            result = result * 59 + ($postLogoutUriRequestParam == null ? 43 : ((Object)$postLogoutUriRequestParam).hashCode());
            Optional<String> $idTokenHintRequestParam = this.getIdTokenHintRequestParam();
            result = result * 59 + ($idTokenHintRequestParam == null ? 43 : ((Object)$idTokenHintRequestParam).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SpringAddonsOAuth2ClientProperties.OAuth2LogoutProperties(clientRegistrationId=" + this.getClientRegistrationId() + ", uri=" + this.getUri() + ", clientIdRequestParam=" + this.getClientIdRequestParam() + ", postLogoutUriRequestParam=" + this.getPostLogoutUriRequestParam() + ", idTokenHintRequestParam=" + this.getIdTokenHintRequestParam() + ")";
        }
    }
}

