/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config;

import com.c4_soft.springaddons.security.oauth2.config.LogoutRequestUriBuilder;
import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsOAuth2ClientProperties;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.web.util.UriComponentsBuilder;

public class SpringAddonsOAuth2LogoutRequestUriBuilder
implements LogoutRequestUriBuilder {
    private static final String OIDC_RP_INITIATED_LOGOUT_CONFIGURATION_ENTRY = "end_session_endpoint";
    private static final String OIDC_RP_INITIATED_LOGOUT_CLIENT_ID_REQUEST_PARAM = "client_id";
    private static final String OIDC_RP_INITIATED_LOGOUT_ID_TOKEN_HINT_REQUEST_PARAM = "id_token_hint";
    private static final String OIDC_RP_INITIATED_LOGOUT_POST_LOGOUT_URI_REQUEST_PARAM = "post_logout_redirect_uri";
    private final SpringAddonsOAuth2ClientProperties clientProps;

    @Override
    public String getLogoutRequestUri(OAuth2AuthorizedClient authorizedClient, String idToken, URI postLogoutUri) {
        ClientRegistration clientRegistration = authorizedClient.getClientRegistration();
        Optional<SpringAddonsOAuth2ClientProperties.OAuth2LogoutProperties> logoutProps = this.clientProps.getLogoutProperties(clientRegistration.getRegistrationId());
        URI logoutEndpointUri = this.getLogoutEndpointUri(logoutProps, clientRegistration).orElseThrow(() -> new MisconfiguredProviderException(clientRegistration.getRegistrationId()));
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)logoutEndpointUri);
        this.getIdTokenHintRequestParam(logoutProps).ifPresent(idTokenHintParamName -> builder.queryParam(idTokenHintParamName, new Object[]{idToken}));
        this.getClientIdRequestParam(logoutProps).ifPresent(clientIdParamName -> builder.queryParam(clientIdParamName, new Object[]{clientRegistration.getClientId()}));
        this.getPostLogoutUriRequestParam(logoutProps).ifPresent(postLogoutUriParamName -> builder.queryParam(postLogoutUriParamName, new Object[]{postLogoutUri}));
        return builder.encode(StandardCharsets.UTF_8).build().toUriString();
    }

    @Override
    public String getLogoutRequestUri(OAuth2AuthorizedClient authorizedClient, String idToken) {
        return this.getLogoutRequestUri(authorizedClient, idToken, this.clientProps.getPostLogoutRedirectUri());
    }

    public Optional<URI> getLogoutEndpointUri(Optional<SpringAddonsOAuth2ClientProperties.OAuth2LogoutProperties> logoutProps, ClientRegistration clientRegistration) {
        if (logoutProps.isPresent()) {
            return Optional.ofNullable(logoutProps.get().getUri());
        }
        Map oidcConfig = clientRegistration.getProviderDetails().getConfigurationMetadata();
        return Optional.ofNullable(oidcConfig.get(OIDC_RP_INITIATED_LOGOUT_CONFIGURATION_ENTRY)).map(Object::toString).map(URI::create);
    }

    public Optional<String> getIdTokenHintRequestParam(Optional<SpringAddonsOAuth2ClientProperties.OAuth2LogoutProperties> logoutProps) {
        if (logoutProps.isEmpty()) {
            return Optional.of(OIDC_RP_INITIATED_LOGOUT_ID_TOKEN_HINT_REQUEST_PARAM);
        }
        return logoutProps.get().getIdTokenHintRequestParam();
    }

    public Optional<String> getClientIdRequestParam(Optional<SpringAddonsOAuth2ClientProperties.OAuth2LogoutProperties> logoutProps) {
        if (logoutProps.isEmpty()) {
            return Optional.of(OIDC_RP_INITIATED_LOGOUT_CLIENT_ID_REQUEST_PARAM);
        }
        return logoutProps.get().getClientIdRequestParam();
    }

    public Optional<String> getPostLogoutUriRequestParam(Optional<SpringAddonsOAuth2ClientProperties.OAuth2LogoutProperties> logoutProps) {
        if (logoutProps.isEmpty()) {
            return Optional.of(OIDC_RP_INITIATED_LOGOUT_POST_LOGOUT_URI_REQUEST_PARAM);
        }
        return logoutProps.get().getPostLogoutUriRequestParam();
    }

    @Generated
    public SpringAddonsOAuth2ClientProperties getClientProps() {
        return this.clientProps;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringAddonsOAuth2LogoutRequestUriBuilder)) {
            return false;
        }
        SpringAddonsOAuth2LogoutRequestUriBuilder other = (SpringAddonsOAuth2LogoutRequestUriBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SpringAddonsOAuth2ClientProperties this$clientProps = this.getClientProps();
        SpringAddonsOAuth2ClientProperties other$clientProps = other.getClientProps();
        return !(this$clientProps == null ? other$clientProps != null : !((Object)this$clientProps).equals(other$clientProps));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpringAddonsOAuth2LogoutRequestUriBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SpringAddonsOAuth2ClientProperties $clientProps = this.getClientProps();
        result = result * 59 + ($clientProps == null ? 43 : ((Object)$clientProps).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SpringAddonsOAuth2LogoutRequestUriBuilder(clientProps=" + this.getClientProps() + ")";
    }

    @Generated
    public SpringAddonsOAuth2LogoutRequestUriBuilder(SpringAddonsOAuth2ClientProperties clientProps) {
        this.clientProps = clientProps;
    }

    static final class MisconfiguredProviderException
    extends RuntimeException {
        public MisconfiguredProviderException(String clientRegistrationId) {
            super("OAuth2 client registration for %s RP-Initiated Logout is missconfigured: it is neither OIDC complient nor difiend in spring-addons properties".formatted(clientRegistrationId));
        }
    }
}

