/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.util.StringUtils;

public class OAuthentication<T extends Map<String, Object> & Serializable>
extends AbstractAuthenticationToken
implements OAuth2AuthenticatedPrincipal {
    private static final long serialVersionUID = -2827891205034221389L;
    private final String tokenString;
    private final T claims;

    public OAuthentication(T claims, Collection<? extends GrantedAuthority> authorities, String tokenString) {
        super(authorities);
        super.setAuthenticated(true);
        super.setDetails(claims);
        this.claims = claims;
        this.tokenString = Optional.ofNullable(tokenString).map(ts -> ts.toLowerCase().startsWith("bearer ") ? ts.substring(7) : ts).orElse(null);
    }

    public void setDetails(Object details) {
    }

    public void setAuthenticated(boolean isAuthenticated) {
        throw new RuntimeException("OAuthentication authentication status is immutable");
    }

    public String getCredentials() {
        return this.tokenString;
    }

    public String getName() {
        return ((Principal)this.getPrincipal()).getName();
    }

    public T getPrincipal() {
        return this.claims;
    }

    public T getAttributes() {
        return this.claims;
    }

    public T getClaims() {
        return this.claims;
    }

    public String getBearerHeader() {
        if (!StringUtils.hasText((String)this.tokenString)) {
            return null;
        }
        return String.format("Bearer %s", this.tokenString);
    }

    @Generated
    public String getTokenString() {
        return this.tokenString;
    }

    @Generated
    public String toString() {
        return "OAuthentication(tokenString=" + this.getTokenString() + ", claims=" + String.valueOf(this.getClaims()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuthentication)) {
            return false;
        }
        OAuthentication other = (OAuthentication)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$tokenString = this.getTokenString();
        String other$tokenString = other.getTokenString();
        if (this$tokenString == null ? other$tokenString != null : !this$tokenString.equals(other$tokenString)) {
            return false;
        }
        T this$claims = this.getClaims();
        T other$claims = other.getClaims();
        return !(this$claims == null ? other$claims != null : !this$claims.equals(other$claims));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OAuthentication;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $tokenString = this.getTokenString();
        result = result * 59 + ($tokenString == null ? 43 : $tokenString.hashCode());
        T $claims = this.getClaims();
        result = result * 59 + ($claims == null ? 43 : $claims.hashCode());
        return result;
    }
}

