/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.webflux;

import com.c4_soft.springaddons.security.oauth2.test.Defaults;
import com.c4_soft.springaddons.security.oauth2.test.webflux.AuthenticationConfigurer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mockito.Mockito;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class MockAuthenticationWebTestClientConfigurer<T extends Authentication>
implements AuthenticationConfigurer<T> {
    private final T authMock;

    private MockAuthenticationWebTestClientConfigurer(T authMock) {
        this.authMock = authMock;
    }

    public T build() {
        return this.authMock;
    }

    public MockAuthenticationWebTestClientConfigurer<T> authorities(String ... authorities) {
        return this.authorities(Stream.of(authorities));
    }

    public MockAuthenticationWebTestClientConfigurer<T> authorities(Stream<String> authorities) {
        Mockito.when((Object)this.authMock.getAuthorities()).thenReturn((Object)authorities.map(SimpleGrantedAuthority::new).collect(Collectors.toSet()));
        return this;
    }

    public MockAuthenticationWebTestClientConfigurer<T> name(String name) {
        Mockito.when((Object)this.authMock.getName()).thenReturn((Object)name);
        return this;
    }

    public MockAuthenticationWebTestClientConfigurer<T> credentials(Object credentials) {
        Mockito.when((Object)this.authMock.getCredentials()).thenReturn(credentials);
        return this;
    }

    public MockAuthenticationWebTestClientConfigurer<T> details(Object details) {
        Mockito.when((Object)this.authMock.getDetails()).thenReturn(details);
        return this;
    }

    public MockAuthenticationWebTestClientConfigurer<T> principal(Object principal) {
        Mockito.when((Object)this.authMock.getPrincipal()).thenReturn(principal);
        return this;
    }

    public MockAuthenticationWebTestClientConfigurer<T> setAuthenticated(boolean authenticated) {
        Mockito.when((Object)this.authMock.isAuthenticated()).thenReturn((Object)authenticated);
        return this;
    }

    public static MockAuthenticationWebTestClientConfigurer<Authentication> mockAuthentication() {
        return MockAuthenticationWebTestClientConfigurer.mockAuthentication(Authentication.class);
    }

    public static <T extends Authentication> MockAuthenticationWebTestClientConfigurer<T> mockAuthentication(Class<T> authType) {
        return MockAuthenticationWebTestClientConfigurer.mockAuthentication(authType, auth -> {});
    }

    public static <T extends Authentication> MockAuthenticationWebTestClientConfigurer<T> mockAuthentication(Class<T> authType, Consumer<T> authMockConfigurer) {
        T authMock = MockAuthenticationWebTestClientConfigurer.authMock(authType);
        authMockConfigurer.accept(authMock);
        return new MockAuthenticationWebTestClientConfigurer<T>(authMock);
    }

    static <T extends Authentication> T authMock(Class<T> authType) {
        Authentication auth = (Authentication)Mockito.mock(authType);
        Mockito.when((Object)auth.getAuthorities()).thenReturn((Object)Defaults.GRANTED_AUTHORITIES);
        Mockito.when((Object)auth.getName()).thenReturn((Object)"user");
        Mockito.when((Object)auth.isAuthenticated()).thenReturn((Object)true);
        return (T)auth;
    }
}

