/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.webmvc;

import com.c4_soft.springaddons.security.oauth2.test.webmvc.MockMvcPerformException;
import com.c4_soft.springaddons.security.oauth2.test.webmvc.MockMvcProperties;
import com.c4_soft.springaddons.security.oidc.starter.properties.Csrf;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import com.c4_soft.springaddons.test.support.web.ByteArrayHttpOutputMessage;
import com.c4_soft.springaddons.test.support.web.SerializationHelper;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.util.Assert;
import org.springframework.web.servlet.DispatcherServlet;

@Scope(value="prototype")
public class MockMvcSupport {
    private final MockMvc mockMvc;
    private final SerializationHelper conv;
    private MediaType mediaType;
    private Charset charset;
    private boolean isSecure;
    private boolean isCsrf;
    private final List<RequestPostProcessor> postProcessors;

    public MockMvcSupport(MockMvc mockMvc, SerializationHelper serializationHelper, MockMvcProperties mockMvcProperties, ServerProperties serverProperties, SpringAddonsOidcProperties addonsProperties) {
        this.mockMvc = mockMvc;
        this.conv = serializationHelper;
        this.mediaType = MediaType.valueOf((String)mockMvcProperties.getDefaultMediaType());
        this.charset = Charset.forName(mockMvcProperties.getDefaultCharset());
        this.postProcessors = new ArrayList<RequestPostProcessor>();
        this.isSecure = serverProperties.getSsl() != null && serverProperties.getSsl().isEnabled();
        this.isCsrf = !addonsProperties.getResourceserver().getCsrf().equals((Object)Csrf.DISABLE);
    }

    public MockMvcSupport setSecure(boolean isSecure) {
        this.isSecure = isSecure;
        return this;
    }

    public MockMvcSupport setCsrf(boolean isCsrf) {
        this.isCsrf = isCsrf;
        return this;
    }

    public MockMvcSupport setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public MockMvcSupport setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public MockHttpServletRequestBuilder requestBuilder(Optional<MediaType> accept, Optional<Charset> charset, HttpMethod method, String urlTemplate, Object ... uriVars) {
        MockHttpServletRequestBuilder builder = MockMvcRequestBuilders.request((HttpMethod)method, (String)urlTemplate, (Object[])uriVars);
        accept.ifPresent(xva$0 -> builder.accept(new MediaType[]{xva$0}));
        return this.postProcess(builder);
    }

    private MockHttpServletRequestBuilder postProcess(MockHttpServletRequestBuilder requestBuilder) {
        requestBuilder.characterEncoding(this.charset.toString());
        requestBuilder.secure(this.isSecure);
        if (this.isCsrf) {
            requestBuilder.with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf());
        }
        return requestBuilder;
    }

    public ResultActions perform(MockHttpServletRequestBuilder requestBuilder) {
        this.postProcessors.forEach(arg_0 -> ((MockHttpServletRequestBuilder)requestBuilder).with(arg_0));
        try {
            return this.mockMvc.perform((RequestBuilder)this.postProcess(requestBuilder));
        }
        catch (Exception e) {
            throw new MockMvcPerformException(e);
        }
    }

    public MockHttpServletRequestBuilder getRequestBuilder(MediaType accept, String urlTemplate, Object ... uriVars) {
        return this.requestBuilder(Optional.of(accept), Optional.empty(), HttpMethod.GET, urlTemplate, uriVars);
    }

    public MockHttpServletRequestBuilder getRequestBuilder(String urlTemplate, Object ... uriVars) {
        return this.getRequestBuilder(this.mediaType, urlTemplate, uriVars);
    }

    public ResultActions get(MediaType accept, String urlTemplate, Object ... uriVars) {
        return this.perform(this.getRequestBuilder(accept, urlTemplate, uriVars));
    }

    public ResultActions get(String urlTemplate, Object ... uriVars) {
        return this.perform(this.getRequestBuilder(urlTemplate, uriVars));
    }

    public <T> MockHttpServletRequestBuilder postRequestBuilder(T payload, MediaType contentType, Charset charset, MediaType accept, String urlTemplate, Object ... uriVars) {
        return this.feed(this.requestBuilder(Optional.of(accept), Optional.of(charset), HttpMethod.POST, urlTemplate, uriVars), payload, contentType, charset);
    }

    public <T> MockHttpServletRequestBuilder postRequestBuilder(T payload, MediaType contentType, MediaType accept, String urlTemplate, Object ... uriVars) {
        return this.postRequestBuilder(payload, contentType, this.charset, accept, urlTemplate, uriVars);
    }

    public <T> MockHttpServletRequestBuilder postRequestBuilder(T payload, String urlTemplate, Object ... uriVars) {
        return this.postRequestBuilder(payload, this.mediaType, this.charset, this.mediaType, urlTemplate, uriVars);
    }

    public <T> ResultActions post(T payload, MediaType contentType, Charset charset, MediaType accept, String urlTemplate, Object ... uriVars) {
        return this.perform(this.postRequestBuilder(payload, contentType, charset, accept, urlTemplate, uriVars));
    }

    public <T> ResultActions post(T payload, MediaType contentType, MediaType accept, String urlTemplate, Object ... uriVars) {
        return this.perform(this.postRequestBuilder(payload, contentType, accept, urlTemplate, uriVars));
    }

    public <T> ResultActions post(T payload, String urlTemplate, Object ... uriVars) {
        return this.perform(this.postRequestBuilder(payload, urlTemplate, uriVars));
    }

    public <T> MockHttpServletRequestBuilder putRequestBuilder(T payload, MediaType contentType, Charset charset, String urlTemplate, Object ... uriVars) {
        return this.feed(this.requestBuilder(Optional.empty(), Optional.of(charset), HttpMethod.PUT, urlTemplate, uriVars), payload, contentType, charset);
    }

    public <T> MockHttpServletRequestBuilder putRequestBuilder(T payload, MediaType contentType, String urlTemplate, Object ... uriVars) {
        return this.putRequestBuilder(payload, contentType, this.charset, urlTemplate, uriVars);
    }

    public <T> MockHttpServletRequestBuilder putRequestBuilder(T payload, String urlTemplate, Object ... uriVars) {
        return this.putRequestBuilder(payload, this.mediaType, this.charset, urlTemplate, uriVars);
    }

    public <T> ResultActions put(T payload, MediaType contentType, String charset, String urlTemplate, Object ... uriVars) {
        return this.perform(this.putRequestBuilder(payload, contentType, charset, urlTemplate, uriVars));
    }

    public <T> ResultActions put(T payload, MediaType contentType, String urlTemplate, Object ... uriVars) {
        return this.perform(this.putRequestBuilder(payload, contentType, urlTemplate, uriVars));
    }

    public <T> ResultActions put(T payload, String urlTemplate, Object ... uriVars) {
        return this.perform(this.putRequestBuilder(payload, urlTemplate, uriVars));
    }

    public <T> MockHttpServletRequestBuilder patchRequestBuilder(T payload, MediaType contentType, Charset charset, String urlTemplate, Object ... uriVars) {
        return this.feed(this.requestBuilder(Optional.empty(), Optional.of(charset), HttpMethod.PATCH, urlTemplate, uriVars), payload, contentType, charset);
    }

    public <T> MockHttpServletRequestBuilder patchRequestBuilder(T payload, MediaType contentType, String urlTemplate, Object ... uriVars) {
        return this.patchRequestBuilder(payload, contentType, this.charset, urlTemplate, uriVars);
    }

    public <T> MockHttpServletRequestBuilder patchRequestBuilder(T payload, String urlTemplate, Object ... uriVars) {
        return this.patchRequestBuilder(payload, this.mediaType, this.charset, urlTemplate, uriVars);
    }

    public <T> ResultActions patch(T payload, MediaType contentType, Charset charset, String urlTemplate, Object ... uriVars) {
        return this.perform(this.patchRequestBuilder(payload, contentType, charset, urlTemplate, uriVars));
    }

    public <T> ResultActions patch(T payload, MediaType contentType, String urlTemplate, Object ... uriVars) {
        return this.perform(this.patchRequestBuilder(payload, contentType, urlTemplate, uriVars));
    }

    public <T> ResultActions patch(T payload, String urlTemplate, Object ... uriVars) {
        return this.perform(this.patchRequestBuilder(payload, urlTemplate, uriVars));
    }

    public MockHttpServletRequestBuilder deleteRequestBuilder(String urlTemplate, Object ... uriVars) {
        return this.requestBuilder(Optional.empty(), Optional.empty(), HttpMethod.DELETE, urlTemplate, uriVars);
    }

    public ResultActions delete(String urlTemplate, Object ... uriVars) {
        return this.perform(this.deleteRequestBuilder(urlTemplate, uriVars));
    }

    public MockHttpServletRequestBuilder headRequestBuilder(String urlTemplate, Object ... uriVars) {
        return this.requestBuilder(Optional.empty(), Optional.empty(), HttpMethod.HEAD, urlTemplate, uriVars);
    }

    public ResultActions head(String urlTemplate, Object ... uriVars) {
        return this.perform(this.headRequestBuilder(urlTemplate, uriVars));
    }

    public MockHttpServletRequestBuilder optionRequestBuilder(MediaType accept, String urlTemplate, Object ... uriVars) {
        return this.requestBuilder(Optional.of(accept), Optional.empty(), HttpMethod.OPTIONS, urlTemplate, uriVars);
    }

    public MockHttpServletRequestBuilder optionRequestBuilder(String urlTemplate, Object ... uriVars) {
        return this.optionRequestBuilder(this.mediaType, urlTemplate, uriVars);
    }

    public ResultActions option(MediaType accept, String urlTemplate, Object ... uriVars) {
        return this.perform(this.optionRequestBuilder(accept, urlTemplate, uriVars));
    }

    public ResultActions option(String urlTemplate, Object ... uriVars) {
        return this.perform(this.optionRequestBuilder(urlTemplate, uriVars));
    }

    public <T> MockHttpServletRequestBuilder feed(MockHttpServletRequestBuilder request, T payload, MediaType mediaType, Charset charset) {
        if (payload == null) {
            return request;
        }
        ByteArrayHttpOutputMessage msg = this.conv.outputMessage(payload, new MediaType(mediaType, charset));
        return request.headers(msg.headers).content(msg.out.toByteArray());
    }

    public DispatcherServlet getDispatcherServlet() {
        return this.mockMvc.getDispatcherServlet();
    }

    public MockMvcSupport with(RequestPostProcessor postProcessor) {
        Assert.notNull((Object)postProcessor, (String)"postProcessor is required");
        this.postProcessors.add(postProcessor);
        return this;
    }
}

