/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive.resourceserver;

import com.c4_soft.springaddons.security.oidc.starter.OpenidProviderPropertiesResolver;
import com.c4_soft.springaddons.security.oidc.starter.properties.NotAConfiguredOpenidProviderException;
import com.c4_soft.springaddons.security.oidc.starter.properties.OpenidProviderProperties;
import com.c4_soft.springaddons.security.oidc.starter.reactive.resourceserver.SpringAddonsReactiveJwtDecoderFactory;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import java.net.URI;
import java.text.ParseException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.ReactiveAuthenticationManagerResolver;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtReactiveAuthenticationManager;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ReactiveJWTClaimsSetAuthenticationManager
implements ReactiveAuthenticationManager {
    private final ReactiveJWTClaimsSetAuthenticationManagerResolver jwtAuthenticationManagerResolver;

    public ReactiveJWTClaimsSetAuthenticationManager(OpenidProviderPropertiesResolver opPropertiesResolver, SpringAddonsReactiveJwtDecoderFactory jwtDecoderFactory, Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>> jwtAuthenticationConverter) {
        this.jwtAuthenticationManagerResolver = new ReactiveJWTClaimsSetAuthenticationManagerResolver(opPropertiesResolver, jwtDecoderFactory, jwtAuthenticationConverter);
    }

    public Mono<Authentication> authenticate(Authentication authentication) throws AuthenticationException {
        JWTClaimsSet jwtClaimSet;
        Assert.isTrue((boolean)(authentication instanceof BearerTokenAuthenticationToken), (String)"Authentication must be of type BearerTokenAuthenticationToken");
        try {
            jwtClaimSet = JWTParser.parse((String)((BearerTokenAuthenticationToken)authentication).getToken()).getJWTClaimsSet();
        }
        catch (ParseException e) {
            throw new InvalidBearerTokenException("Could not retrieve JWT claim-set");
        }
        return this.jwtAuthenticationManagerResolver.resolve(jwtClaimSet).flatMap(authenticationManager -> {
            if (authenticationManager == null) {
                throw new InvalidBearerTokenException("Could not resolve the Authentication manager for the provided JWT");
            }
            return authenticationManager.authenticate(authentication);
        });
    }

    public static class ReactiveJWTClaimsSetAuthenticationManagerResolver
    implements ReactiveAuthenticationManagerResolver<JWTClaimsSet> {
        private final OpenidProviderPropertiesResolver opPropertiesResolver;
        private final SpringAddonsReactiveJwtDecoderFactory jwtDecoderFactory;
        private final Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>> jwtAuthenticationConverter;
        private final Map<String, ReactiveAuthenticationManager> jwtManagers = new ConcurrentHashMap<String, ReactiveAuthenticationManager>();

        public Mono<ReactiveAuthenticationManager> resolve(JWTClaimsSet jwt) {
            String issuer = jwt.getIssuer();
            if (!this.jwtManagers.containsKey(issuer)) {
                OpenidProviderProperties opProperties = this.opPropertiesResolver.resolve(jwt.getClaims()).orElseThrow(() -> new NotAConfiguredOpenidProviderException(jwt.getClaims()));
                ReactiveJwtDecoder decoder = this.jwtDecoderFactory.create(Optional.ofNullable(opProperties.getJwkSetUri()), Optional.ofNullable(URI.create(jwt.getIssuer().toString())), Optional.ofNullable(opProperties.getAud()));
                JwtReactiveAuthenticationManager provider = new JwtReactiveAuthenticationManager(decoder);
                provider.setJwtAuthenticationConverter(this.jwtAuthenticationConverter);
                this.jwtManagers.put(issuer, arg_0 -> ((JwtReactiveAuthenticationManager)provider).authenticate(arg_0));
            }
            return Mono.just((Object)this.jwtManagers.get(issuer));
        }

        @Generated
        public ReactiveJWTClaimsSetAuthenticationManagerResolver(OpenidProviderPropertiesResolver opPropertiesResolver, SpringAddonsReactiveJwtDecoderFactory jwtDecoderFactory, Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>> jwtAuthenticationConverter) {
            this.opPropertiesResolver = opPropertiesResolver;
            this.jwtDecoderFactory = jwtDecoderFactory;
            this.jwtAuthenticationConverter = jwtAuthenticationConverter;
        }
    }
}

