/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.synchronised.resourceserver;

import com.c4_soft.springaddons.security.oidc.starter.OpenidProviderPropertiesResolver;
import com.c4_soft.springaddons.security.oidc.starter.properties.NotAConfiguredOpenidProviderException;
import com.c4_soft.springaddons.security.oidc.starter.properties.OpenidProviderProperties;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.resourceserver.SpringAddonsJwtDecoderFactory;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import java.net.URI;
import java.text.ParseException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationProvider;
import org.springframework.util.Assert;

public class JWTClaimsSetAuthenticationManager
implements AuthenticationManager {
    private final JWTClaimsSetAuthenticationManagerResolver jwtAuthenticationManagerResolver;

    public JWTClaimsSetAuthenticationManager(OpenidProviderPropertiesResolver opPropertiesResolver, SpringAddonsJwtDecoderFactory jwtDecoderFactory, Converter<Jwt, AbstractAuthenticationToken> jwtAuthenticationConverter) {
        this.jwtAuthenticationManagerResolver = new JWTClaimsSetAuthenticationManagerResolver(opPropertiesResolver, jwtDecoderFactory, jwtAuthenticationConverter);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        JWTClaimsSet jwtClaimSet;
        Assert.isTrue((boolean)(authentication instanceof BearerTokenAuthenticationToken), (String)"Authentication must be of type BearerTokenAuthenticationToken");
        try {
            jwtClaimSet = JWTParser.parse((String)((BearerTokenAuthenticationToken)authentication).getToken()).getJWTClaimsSet();
        }
        catch (ParseException e) {
            throw new InvalidBearerTokenException("Could not retrieve JWT claim-set");
        }
        AuthenticationManager authenticationManager = this.jwtAuthenticationManagerResolver.resolve(jwtClaimSet);
        if (authenticationManager == null) {
            throw new InvalidBearerTokenException("Could not resolve the authentication manager for the provided JWT");
        }
        return authenticationManager.authenticate(authentication);
    }

    public static class JWTClaimsSetAuthenticationManagerResolver
    implements AuthenticationManagerResolver<JWTClaimsSet> {
        private final OpenidProviderPropertiesResolver opPropertiesResolver;
        private final SpringAddonsJwtDecoderFactory jwtDecoderFactory;
        private final Converter<Jwt, AbstractAuthenticationToken> jwtAuthenticationConverter;
        private final Map<String, AuthenticationManager> jwtManagers = new ConcurrentHashMap<String, AuthenticationManager>();

        public AuthenticationManager resolve(JWTClaimsSet jwt) {
            String issuer = jwt.getIssuer();
            if (!this.jwtManagers.containsKey(issuer)) {
                OpenidProviderProperties opProperties = this.opPropertiesResolver.resolve(jwt.getClaims()).orElseThrow(() -> new NotAConfiguredOpenidProviderException(jwt.getClaims()));
                JwtDecoder decoder = this.jwtDecoderFactory.create(Optional.ofNullable(opProperties.getJwkSetUri()), Optional.ofNullable(URI.create(jwt.getIssuer())), Optional.ofNullable(opProperties.getAud()));
                JwtAuthenticationProvider provider = new JwtAuthenticationProvider(decoder);
                provider.setJwtAuthenticationConverter(this.jwtAuthenticationConverter);
                this.jwtManagers.put(issuer, arg_0 -> ((JwtAuthenticationProvider)provider).authenticate(arg_0));
            }
            return this.jwtManagers.get(issuer);
        }

        @Generated
        public JWTClaimsSetAuthenticationManagerResolver(OpenidProviderPropertiesResolver opPropertiesResolver, SpringAddonsJwtDecoderFactory jwtDecoderFactory, Converter<Jwt, AbstractAuthenticationToken> jwtAuthenticationConverter) {
            this.opPropertiesResolver = opPropertiesResolver;
            this.jwtDecoderFactory = jwtDecoderFactory;
            this.jwtAuthenticationConverter = jwtAuthenticationConverter;
        }
    }
}

