/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.synchronised.client;

import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.StreamSupport;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.client.AuthorizationCodeOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.ClientCredentialsOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.DelegatingOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.RefreshTokenOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.endpoint.DefaultClientCredentialsTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.DefaultRefreshTokenTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequestEntityConverter;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequestEntityConverter;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.util.MultiValueMap;

public final class PerRegistrationOAuth2AuthorizedClientProvider
implements OAuth2AuthorizedClientProvider {
    private final Map<String, OAuth2AuthorizedClientProvider> providersByRegistrationId = new ConcurrentHashMap<String, OAuth2AuthorizedClientProvider>();
    private final Map<String, List<OAuth2AuthorizedClientProvider>> customProvidersByRegistrationId;
    private final SpringAddonsOidcProperties addonsProperties;

    public PerRegistrationOAuth2AuthorizedClientProvider(InMemoryClientRegistrationRepository clientRegistrationRepo, SpringAddonsOidcProperties addonsProperties, Map<String, List<OAuth2AuthorizedClientProvider>> customProvidersByRegistrationId) {
        this.customProvidersByRegistrationId = customProvidersByRegistrationId;
        this.addonsProperties = addonsProperties;
        StreamSupport.stream(clientRegistrationRepo.spliterator(), false).forEach(reg -> {
            DelegatingOAuth2AuthorizedClientProvider delegate = new DelegatingOAuth2AuthorizedClientProvider(this.getProvidersFor((ClientRegistration)reg, addonsProperties));
            this.providersByRegistrationId.put(reg.getRegistrationId(), (OAuth2AuthorizedClientProvider)delegate);
        });
    }

    public OAuth2AuthorizedClient authorize(OAuth2AuthorizationContext context) {
        if (context == null) {
            return null;
        }
        ClientRegistration registration = context.getClientRegistration();
        if (!this.providersByRegistrationId.containsKey(registration.getRegistrationId())) {
            DelegatingOAuth2AuthorizedClientProvider delegate = new DelegatingOAuth2AuthorizedClientProvider(this.getProvidersFor(registration, this.addonsProperties));
            this.providersByRegistrationId.put(registration.getRegistrationId(), (OAuth2AuthorizedClientProvider)delegate);
        }
        return this.providersByRegistrationId.get(registration.getRegistrationId()).authorize(context);
    }

    private List<OAuth2AuthorizedClientProvider> getProvidersFor(ClientRegistration registration, SpringAddonsOidcProperties addonsProperties) {
        ArrayList<OAuth2AuthorizedClientProvider> providers = new ArrayList<OAuth2AuthorizedClientProvider>(this.customProvidersByRegistrationId.getOrDefault(registration.getRegistrationId(), List.of()));
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)registration.getAuthorizationGrantType())) {
            providers.add((OAuth2AuthorizedClientProvider)new AuthorizationCodeOAuth2AuthorizedClientProvider());
            if (registration.getScopes().contains("offline_access")) {
                providers.add((OAuth2AuthorizedClientProvider)this.createRefreshTokenProvider(registration, addonsProperties));
            }
        } else if (AuthorizationGrantType.CLIENT_CREDENTIALS.equals((Object)registration.getAuthorizationGrantType())) {
            providers.add((OAuth2AuthorizedClientProvider)this.createClientCredentialsProvider(registration, addonsProperties));
        }
        return providers;
    }

    private ClientCredentialsOAuth2AuthorizedClientProvider createClientCredentialsProvider(ClientRegistration registration, SpringAddonsOidcProperties addonsProperties) {
        ClientCredentialsOAuth2AuthorizedClientProvider provider = new ClientCredentialsOAuth2AuthorizedClientProvider();
        MultiValueMap<String, String> extraParameters = addonsProperties.getClient().getExtraTokenParameters(registration.getRegistrationId());
        if (extraParameters.size() == 0) {
            return provider;
        }
        OAuth2ClientCredentialsGrantRequestEntityConverter requestEntityConverter = new OAuth2ClientCredentialsGrantRequestEntityConverter();
        requestEntityConverter.addParametersConverter(source -> extraParameters);
        DefaultClientCredentialsTokenResponseClient responseClient = new DefaultClientCredentialsTokenResponseClient();
        responseClient.setRequestEntityConverter((Converter)requestEntityConverter);
        provider.setAccessTokenResponseClient((OAuth2AccessTokenResponseClient)responseClient);
        return provider;
    }

    private RefreshTokenOAuth2AuthorizedClientProvider createRefreshTokenProvider(ClientRegistration registration, SpringAddonsOidcProperties addonsProperties) {
        RefreshTokenOAuth2AuthorizedClientProvider provider = new RefreshTokenOAuth2AuthorizedClientProvider();
        MultiValueMap<String, String> extraParameters = addonsProperties.getClient().getExtraTokenParameters(registration.getRegistrationId());
        if (extraParameters.size() == 0) {
            return provider;
        }
        OAuth2RefreshTokenGrantRequestEntityConverter requestEntityConverter = new OAuth2RefreshTokenGrantRequestEntityConverter();
        requestEntityConverter.addParametersConverter(source -> extraParameters);
        DefaultRefreshTokenTokenResponseClient responseClient = new DefaultRefreshTokenTokenResponseClient();
        responseClient.setRequestEntityConverter((Converter)requestEntityConverter);
        provider.setAccessTokenResponseClient((OAuth2AccessTokenResponseClient)responseClient);
        return provider;
    }
}

