/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive.resourceserver;

import com.c4_soft.springaddons.security.oidc.OpenidClaimSet;
import com.c4_soft.springaddons.security.oidc.starter.OpenidProviderPropertiesResolver;
import com.c4_soft.springaddons.security.oidc.starter.properties.CorsProperties;
import com.c4_soft.springaddons.security.oidc.starter.properties.NotAConfiguredOpenidProviderException;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.CookieCsrfCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultAuthenticationManagerResolverCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultCorsWebFilterCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultJwtAbstractAuthenticationTokenConverterCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultOpaqueTokenAuthenticationConverterCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.IsIntrospectingResourceServerCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.IsJwtDecoderResourceServerCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.configuration.IsNotServlet;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.configuration.IsOidcResourceServerCondition;
import com.c4_soft.springaddons.security.oidc.starter.reactive.ReactiveConfigurationSupport;
import com.c4_soft.springaddons.security.oidc.starter.reactive.ReactiveSpringAddonsOidcBeans;
import com.c4_soft.springaddons.security.oidc.starter.reactive.resourceserver.DefaultSpringAddonsReactiveJwtDecoderFactory;
import com.c4_soft.springaddons.security.oidc.starter.reactive.resourceserver.ReactiveJwtAbstractAuthenticationTokenConverter;
import com.c4_soft.springaddons.security.oidc.starter.reactive.resourceserver.ResourceServerAuthorizeExchangeSpecPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.reactive.resourceserver.ResourceServerReactiveHttpSecurityPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.reactive.resourceserver.SpringAddonsReactiveJwtAuthenticationManagerResolver;
import com.c4_soft.springaddons.security.oidc.starter.reactive.resourceserver.SpringAddonsReactiveJwtDecoderFactory;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.ReactiveAuthenticationManagerResolver;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionAuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenIntrospector;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.web.cors.reactive.CorsWebFilter;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Mono;

@Conditional(value={IsOidcResourceServerCondition.class, IsNotServlet.class})
@EnableWebFluxSecurity
@AutoConfiguration
@ImportAutoConfiguration(value={ReactiveSpringAddonsOidcBeans.class})
public class ReactiveSpringAddonsOidcResourceServerBeans {
    @Conditional(value={IsJwtDecoderResourceServerCondition.class})
    @Order(value=0x7FFFFFFF)
    @Bean
    SecurityWebFilterChain springAddonsJwtResourceServerSecurityFilterChain(ServerHttpSecurity http, ServerProperties serverProperties, SpringAddonsOidcProperties addonsProperties, ResourceServerAuthorizeExchangeSpecPostProcessor authorizePostProcessor, ResourceServerReactiveHttpSecurityPostProcessor httpPostProcessor, ReactiveAuthenticationManagerResolver<ServerWebExchange> authenticationManagerResolver, ServerAuthenticationEntryPoint authenticationEntryPoint, Optional<ServerAccessDeniedHandler> accessDeniedHandler) {
        http.oauth2ResourceServer(server -> server.authenticationManagerResolver(authenticationManagerResolver));
        ReactiveConfigurationSupport.configureResourceServer(http, serverProperties, addonsProperties, authenticationEntryPoint, accessDeniedHandler, authorizePostProcessor, httpPostProcessor);
        return http.build();
    }

    @Conditional(value={IsIntrospectingResourceServerCondition.class})
    @Order(value=0x7FFFFFFF)
    @Bean
    SecurityWebFilterChain springAddonsIntrospectingResourceServerSecurityFilterChain(ServerHttpSecurity http, ServerProperties serverProperties, SpringAddonsOidcProperties addonsProperties, ResourceServerAuthorizeExchangeSpecPostProcessor authorizePostProcessor, ResourceServerReactiveHttpSecurityPostProcessor httpPostProcessor, ReactiveOpaqueTokenAuthenticationConverter introspectionAuthenticationConverter, ReactiveOpaqueTokenIntrospector opaqueTokenIntrospector, ServerAuthenticationEntryPoint authenticationEntryPoint, Optional<ServerAccessDeniedHandler> accessDeniedHandler) {
        http.oauth2ResourceServer(server -> server.opaqueToken(ot -> {
            ot.introspector(opaqueTokenIntrospector);
            ot.authenticationConverter(introspectionAuthenticationConverter);
        }));
        ReactiveConfigurationSupport.configureResourceServer(http, serverProperties, addonsProperties, authenticationEntryPoint, accessDeniedHandler, authorizePostProcessor, httpPostProcessor);
        return http.build();
    }

    @ConditionalOnMissingBean
    @Bean
    ResourceServerAuthorizeExchangeSpecPostProcessor authorizePostProcessor() {
        return spec -> spec.anyExchange().authenticated();
    }

    @ConditionalOnMissingBean
    @Bean
    ResourceServerReactiveHttpSecurityPostProcessor httpPostProcessor() {
        return serverHttpSecurity -> serverHttpSecurity;
    }

    @ConditionalOnMissingBean
    @Bean
    SpringAddonsReactiveJwtDecoderFactory springAddonsJwtDecoderFactory() {
        return new DefaultSpringAddonsReactiveJwtDecoderFactory();
    }

    @Conditional(value={DefaultAuthenticationManagerResolverCondition.class})
    @Bean
    ReactiveAuthenticationManagerResolver<ServerWebExchange> authenticationManagerResolver(OpenidProviderPropertiesResolver opPropertiesResolver, SpringAddonsReactiveJwtDecoderFactory jwtDecoderFactory, Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>> jwtAuthenticationConverter) {
        return new SpringAddonsReactiveJwtAuthenticationManagerResolver(opPropertiesResolver, jwtDecoderFactory, jwtAuthenticationConverter);
    }

    @ConditionalOnMissingBean
    @Bean
    ServerAuthenticationEntryPoint authenticationEntryPoint() {
        return (exchange, ex) -> exchange.getPrincipal().flatMap(principal -> {
            ServerHttpResponse response = exchange.getResponse();
            response.setStatusCode((HttpStatusCode)HttpStatus.UNAUTHORIZED);
            response.getHeaders().set("WWW-Authenticate", "Bearer realm=\"Restricted Content\"");
            DataBufferFactory dataBufferFactory = response.bufferFactory();
            DataBuffer buffer = dataBufferFactory.wrap(ex.getMessage().getBytes(Charset.defaultCharset()));
            return response.writeWith((Publisher)Mono.just((Object)buffer)).doOnError(error -> DataBufferUtils.release((DataBuffer)buffer));
        });
    }

    @Conditional(value={CookieCsrfCondition.class})
    @ConditionalOnMissingBean(name={"csrfCookieWebFilter"})
    @Bean
    WebFilter csrfCookieWebFilter() {
        return (exchange, chain) -> {
            Mono csrfToken = (Mono)exchange.getAttributeOrDefault(CsrfToken.class.getName(), (Object)Mono.empty());
            return csrfToken.doOnSuccess(token -> {}).then(chain.filter(exchange));
        };
    }

    @Conditional(value={DefaultJwtAbstractAuthenticationTokenConverterCondition.class})
    @Bean
    ReactiveJwtAbstractAuthenticationTokenConverter jwtAuthenticationConverter(Converter<Map<String, Object>, Collection<? extends GrantedAuthority>> authoritiesConverter, OpenidProviderPropertiesResolver opPropertiesResolver) {
        return jwt -> Mono.just((Object)new JwtAuthenticationToken(jwt, (Collection)authoritiesConverter.convert((Object)jwt.getClaims()), new OpenidClaimSet(jwt.getClaims(), opPropertiesResolver.resolve(jwt.getClaims()).orElseThrow(() -> new NotAConfiguredOpenidProviderException(jwt.getClaims())).getUsernameClaim()).getName()));
    }

    @Conditional(value={DefaultOpaqueTokenAuthenticationConverterCondition.class})
    @Bean
    ReactiveOpaqueTokenAuthenticationConverter introspectionAuthenticationConverter(Converter<Map<String, Object>, Collection<? extends GrantedAuthority>> authoritiesConverter, SpringAddonsOidcProperties addonsProperties, OAuth2ResourceServerProperties resourceServerProperties) {
        return (introspectedToken, authenticatedPrincipal) -> Mono.just((Object)new BearerTokenAuthentication((OAuth2AuthenticatedPrincipal)new OAuth2IntrospectionAuthenticatedPrincipal(new OpenidClaimSet(authenticatedPrincipal.getAttributes(), addonsProperties.getOps().stream().filter(issProps -> resourceServerProperties.getOpaquetoken().getIntrospectionUri().contains(issProps.getIss().toString())).findAny().orElse(addonsProperties.getOps().get(0)).getUsernameClaim()).getName(), authenticatedPrincipal.getAttributes(), authenticatedPrincipal.getAuthorities()), new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, introspectedToken, Instant.ofEpochSecond(((Integer)authenticatedPrincipal.getAttribute("iat")).longValue()), Instant.ofEpochSecond(((Integer)authenticatedPrincipal.getAttribute("exp")).longValue())), (Collection)authoritiesConverter.convert((Object)authenticatedPrincipal.getAttributes())));
    }

    @Conditional(value={DefaultCorsWebFilterCondition.class})
    @Bean
    CorsWebFilter corsFilter(SpringAddonsOidcProperties addonsProperties) {
        ArrayList<CorsProperties> corsProps = new ArrayList<CorsProperties>(addonsProperties.getCors());
        List<CorsProperties> deprecatedClientCorsProps = addonsProperties.getResourceserver().getCors();
        corsProps.addAll(deprecatedClientCorsProps);
        return ReactiveConfigurationSupport.getCorsFilterBean(corsProps);
    }
}

