/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.synchronised.client;

import jakarta.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.security.core.Authentication;

public class MultiTenantOAuth2PrincipalSupport {
    private static final String OAUTH2_USERS_KEY = "com.c4-soft.spring-addons.oauth2.client.principal-by-client-registration-id";

    public static Map<String, Authentication> getAuthenticationsByClientRegistrationId(HttpSession session) {
        return Optional.ofNullable((Map)session.getAttribute(OAUTH2_USERS_KEY)).orElse(new HashMap());
    }

    public static Optional<Authentication> getAuthentication(HttpSession session, String clientRegistrationId) {
        return Optional.ofNullable(MultiTenantOAuth2PrincipalSupport.getAuthenticationsByClientRegistrationId(session).get(clientRegistrationId));
    }

    public static synchronized void add(HttpSession session, String clientRegistrationId, Authentication auth) {
        Map<String, Authentication> identities = MultiTenantOAuth2PrincipalSupport.getAuthenticationsByClientRegistrationId(session);
        identities.put(clientRegistrationId, auth);
        session.setAttribute(OAUTH2_USERS_KEY, identities);
    }

    public static synchronized void remove(HttpSession session, String clientRegistrationId) {
        Map<String, Authentication> identities = MultiTenantOAuth2PrincipalSupport.getAuthenticationsByClientRegistrationId(session);
        identities.remove(clientRegistrationId);
        session.setAttribute(OAUTH2_USERS_KEY, identities);
    }
}

