/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.properties;

import com.c4_soft.springaddons.security.oidc.starter.properties.CorsProperties;
import com.c4_soft.springaddons.security.oidc.starter.properties.Csrf;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class SpringAddonsOidcClientProperties {
    public static final String RESPONSE_STATUS_HEADER = "X-RESPONSE-STATUS";
    public static final String POST_AUTHENTICATION_SUCCESS_URI_HEADER = "X-POST-LOGIN-SUCCESS-URI";
    public static final String POST_AUTHENTICATION_SUCCESS_URI_PARAM = "post_login_success_uri";
    public static final String POST_AUTHENTICATION_SUCCESS_URI_SESSION_ATTRIBUTE = "post_login_success_uri";
    public static final String POST_AUTHENTICATION_FAILURE_URI_HEADER = "X-POST-LOGIN-FAILURE-URI";
    public static final String POST_AUTHENTICATION_FAILURE_URI_PARAM = "post_login_failure_uri";
    public static final String POST_AUTHENTICATION_FAILURE_URI_SESSION_ATTRIBUTE = "post_login_failure_uri";
    public static final String POST_AUTHENTICATION_FAILURE_CAUSE_ATTRIBUTE = "error";
    public static final String POST_LOGOUT_SUCCESS_URI_HEADER = "X-POST-LOGOUT-SUCCESS-URI";
    public static final String POST_LOGOUT_SUCCESS_URI_PARAM = "post_logout_success_uri";
    private List<String> securityMatchers = List.of();
    private URI clientUri = URI.create("/");
    private Optional<URI> loginUri = Optional.empty();
    private Optional<URI> postLoginRedirectHost = Optional.empty();
    private Optional<String> postLoginRedirectPath = Optional.empty();
    private Optional<URI> loginErrorRedirectPath = Optional.empty();
    private OAuth2RedirectionProperties oauth2Redirections = new OAuth2RedirectionProperties();
    private Optional<URI> postLogoutRedirectHost = Optional.empty();
    private Optional<String> postLogoutRedirectPath = Optional.empty();
    private Map<String, OAuth2LogoutProperties> oauth2Logout = new HashMap<String, OAuth2LogoutProperties>();
    private boolean multiTenancyEnabled = false;
    private List<String> permitAll = List.of("/login/**", "/oauth2/**");
    private Csrf csrf = Csrf.DEFAULT;
    private boolean pkceForced = false;
    @Deprecated(forRemoval=true)
    private List<CorsProperties> cors = List.of();
    @Deprecated
    private Map<String, List<RequestParam>> authorizationRequestParams = new HashMap<String, List<RequestParam>>();
    private Map<String, Map<String, List<String>>> authorizationParams = new HashMap<String, Map<String, List<String>>>();
    @Deprecated
    private Map<String, List<RequestParam>> tokenRequestParams = new HashMap<String, List<RequestParam>>();
    private Map<String, Map<String, List<String>>> tokenParams = new HashMap<String, Map<String, List<String>>>();
    private BackChannelLogoutProperties backChannelLogout = new BackChannelLogoutProperties();

    public URI getPostLoginRedirectHost() {
        return this.postLoginRedirectHost.orElse(this.clientUri);
    }

    public Optional<URI> getPostLoginRedirectUri() {
        if (this.postLoginRedirectHost.isEmpty() && this.postLoginRedirectPath.isEmpty()) {
            return Optional.empty();
        }
        UriComponentsBuilder uri = UriComponentsBuilder.fromUri((URI)this.getPostLoginRedirectHost());
        this.postLoginRedirectPath.ifPresent(arg_0 -> ((UriComponentsBuilder)uri).path(arg_0));
        return Optional.of(uri.build(Map.of()));
    }

    public URI getPostLogoutRedirectHost() {
        return this.postLogoutRedirectHost.orElse(this.clientUri);
    }

    public URI getPostLogoutRedirectUri() {
        UriComponentsBuilder uri = UriComponentsBuilder.fromUri((URI)this.getPostLogoutRedirectHost());
        this.postLogoutRedirectPath.ifPresent(arg_0 -> ((UriComponentsBuilder)uri).path(arg_0));
        return uri.build(Map.of());
    }

    public MultiValueMap<String, String> getExtraAuthorizationParameters(String registrationId) {
        return SpringAddonsOidcClientProperties.getExtraParameters(registrationId, this.authorizationRequestParams, this.authorizationParams);
    }

    public MultiValueMap<String, String> getExtraTokenParameters(String registrationId) {
        return SpringAddonsOidcClientProperties.getExtraParameters(registrationId, this.tokenRequestParams, this.tokenParams);
    }

    private static MultiValueMap<String, String> getExtraParameters(String registrationId, Map<String, List<RequestParam>> requestParams, Map<String, Map<String, List<String>>> requestParamsMap) {
        LinkedMultiValueMap extraParameters = Optional.ofNullable(requestParamsMap.get(registrationId)).map(LinkedMultiValueMap::new).orElse(new LinkedMultiValueMap());
        for (RequestParam param : requestParams.getOrDefault(registrationId, List.of())) {
            if (!StringUtils.hasText((String)param.getName())) continue;
            extraParameters.add((Object)param.getName(), (Object)param.getValue());
        }
        return extraParameters;
    }

    public Optional<OAuth2LogoutProperties> getLogoutProperties(String clientRegistrationId) {
        return Optional.ofNullable(this.oauth2Logout.get(clientRegistrationId));
    }

    @Generated
    public SpringAddonsOidcClientProperties() {
    }

    @Generated
    public List<String> getSecurityMatchers() {
        return this.securityMatchers;
    }

    @Generated
    public URI getClientUri() {
        return this.clientUri;
    }

    @Generated
    public Optional<URI> getLoginUri() {
        return this.loginUri;
    }

    @Generated
    public Optional<String> getPostLoginRedirectPath() {
        return this.postLoginRedirectPath;
    }

    @Generated
    public Optional<URI> getLoginErrorRedirectPath() {
        return this.loginErrorRedirectPath;
    }

    @Generated
    public OAuth2RedirectionProperties getOauth2Redirections() {
        return this.oauth2Redirections;
    }

    @Generated
    public Optional<String> getPostLogoutRedirectPath() {
        return this.postLogoutRedirectPath;
    }

    @Generated
    public Map<String, OAuth2LogoutProperties> getOauth2Logout() {
        return this.oauth2Logout;
    }

    @Generated
    public boolean isMultiTenancyEnabled() {
        return this.multiTenancyEnabled;
    }

    @Generated
    public List<String> getPermitAll() {
        return this.permitAll;
    }

    @Generated
    public Csrf getCsrf() {
        return this.csrf;
    }

    @Generated
    public boolean isPkceForced() {
        return this.pkceForced;
    }

    @Deprecated
    @Generated
    public List<CorsProperties> getCors() {
        return this.cors;
    }

    @Deprecated
    @Generated
    public Map<String, List<RequestParam>> getAuthorizationRequestParams() {
        return this.authorizationRequestParams;
    }

    @Generated
    public Map<String, Map<String, List<String>>> getAuthorizationParams() {
        return this.authorizationParams;
    }

    @Deprecated
    @Generated
    public Map<String, List<RequestParam>> getTokenRequestParams() {
        return this.tokenRequestParams;
    }

    @Generated
    public Map<String, Map<String, List<String>>> getTokenParams() {
        return this.tokenParams;
    }

    @Generated
    public BackChannelLogoutProperties getBackChannelLogout() {
        return this.backChannelLogout;
    }

    @Generated
    public void setSecurityMatchers(List<String> securityMatchers) {
        this.securityMatchers = securityMatchers;
    }

    @Generated
    public void setClientUri(URI clientUri) {
        this.clientUri = clientUri;
    }

    @Generated
    public void setLoginUri(Optional<URI> loginUri) {
        this.loginUri = loginUri;
    }

    @Generated
    public void setPostLoginRedirectHost(Optional<URI> postLoginRedirectHost) {
        this.postLoginRedirectHost = postLoginRedirectHost;
    }

    @Generated
    public void setPostLoginRedirectPath(Optional<String> postLoginRedirectPath) {
        this.postLoginRedirectPath = postLoginRedirectPath;
    }

    @Generated
    public void setLoginErrorRedirectPath(Optional<URI> loginErrorRedirectPath) {
        this.loginErrorRedirectPath = loginErrorRedirectPath;
    }

    @Generated
    public void setOauth2Redirections(OAuth2RedirectionProperties oauth2Redirections) {
        this.oauth2Redirections = oauth2Redirections;
    }

    @Generated
    public void setPostLogoutRedirectHost(Optional<URI> postLogoutRedirectHost) {
        this.postLogoutRedirectHost = postLogoutRedirectHost;
    }

    @Generated
    public void setPostLogoutRedirectPath(Optional<String> postLogoutRedirectPath) {
        this.postLogoutRedirectPath = postLogoutRedirectPath;
    }

    @Generated
    public void setOauth2Logout(Map<String, OAuth2LogoutProperties> oauth2Logout) {
        this.oauth2Logout = oauth2Logout;
    }

    @Generated
    public void setMultiTenancyEnabled(boolean multiTenancyEnabled) {
        this.multiTenancyEnabled = multiTenancyEnabled;
    }

    @Generated
    public void setPermitAll(List<String> permitAll) {
        this.permitAll = permitAll;
    }

    @Generated
    public void setCsrf(Csrf csrf) {
        this.csrf = csrf;
    }

    @Generated
    public void setPkceForced(boolean pkceForced) {
        this.pkceForced = pkceForced;
    }

    @Deprecated
    @Generated
    public void setCors(List<CorsProperties> cors) {
        this.cors = cors;
    }

    @Deprecated
    @Generated
    public void setAuthorizationRequestParams(Map<String, List<RequestParam>> authorizationRequestParams) {
        this.authorizationRequestParams = authorizationRequestParams;
    }

    @Generated
    public void setAuthorizationParams(Map<String, Map<String, List<String>>> authorizationParams) {
        this.authorizationParams = authorizationParams;
    }

    @Deprecated
    @Generated
    public void setTokenRequestParams(Map<String, List<RequestParam>> tokenRequestParams) {
        this.tokenRequestParams = tokenRequestParams;
    }

    @Generated
    public void setTokenParams(Map<String, Map<String, List<String>>> tokenParams) {
        this.tokenParams = tokenParams;
    }

    @Generated
    public void setBackChannelLogout(BackChannelLogoutProperties backChannelLogout) {
        this.backChannelLogout = backChannelLogout;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringAddonsOidcClientProperties)) {
            return false;
        }
        SpringAddonsOidcClientProperties other = (SpringAddonsOidcClientProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMultiTenancyEnabled() != other.isMultiTenancyEnabled()) {
            return false;
        }
        if (this.isPkceForced() != other.isPkceForced()) {
            return false;
        }
        List<String> this$securityMatchers = this.getSecurityMatchers();
        List<String> other$securityMatchers = other.getSecurityMatchers();
        if (this$securityMatchers == null ? other$securityMatchers != null : !((Object)this$securityMatchers).equals(other$securityMatchers)) {
            return false;
        }
        URI this$clientUri = this.getClientUri();
        URI other$clientUri = other.getClientUri();
        if (this$clientUri == null ? other$clientUri != null : !((Object)this$clientUri).equals(other$clientUri)) {
            return false;
        }
        Optional<URI> this$loginUri = this.getLoginUri();
        Optional<URI> other$loginUri = other.getLoginUri();
        if (this$loginUri == null ? other$loginUri != null : !((Object)this$loginUri).equals(other$loginUri)) {
            return false;
        }
        URI this$postLoginRedirectHost = this.getPostLoginRedirectHost();
        URI other$postLoginRedirectHost = other.getPostLoginRedirectHost();
        if (this$postLoginRedirectHost == null ? other$postLoginRedirectHost != null : !((Object)this$postLoginRedirectHost).equals(other$postLoginRedirectHost)) {
            return false;
        }
        Optional<String> this$postLoginRedirectPath = this.getPostLoginRedirectPath();
        Optional<String> other$postLoginRedirectPath = other.getPostLoginRedirectPath();
        if (this$postLoginRedirectPath == null ? other$postLoginRedirectPath != null : !((Object)this$postLoginRedirectPath).equals(other$postLoginRedirectPath)) {
            return false;
        }
        Optional<URI> this$loginErrorRedirectPath = this.getLoginErrorRedirectPath();
        Optional<URI> other$loginErrorRedirectPath = other.getLoginErrorRedirectPath();
        if (this$loginErrorRedirectPath == null ? other$loginErrorRedirectPath != null : !((Object)this$loginErrorRedirectPath).equals(other$loginErrorRedirectPath)) {
            return false;
        }
        OAuth2RedirectionProperties this$oauth2Redirections = this.getOauth2Redirections();
        OAuth2RedirectionProperties other$oauth2Redirections = other.getOauth2Redirections();
        if (this$oauth2Redirections == null ? other$oauth2Redirections != null : !((Object)this$oauth2Redirections).equals(other$oauth2Redirections)) {
            return false;
        }
        URI this$postLogoutRedirectHost = this.getPostLogoutRedirectHost();
        URI other$postLogoutRedirectHost = other.getPostLogoutRedirectHost();
        if (this$postLogoutRedirectHost == null ? other$postLogoutRedirectHost != null : !((Object)this$postLogoutRedirectHost).equals(other$postLogoutRedirectHost)) {
            return false;
        }
        Optional<String> this$postLogoutRedirectPath = this.getPostLogoutRedirectPath();
        Optional<String> other$postLogoutRedirectPath = other.getPostLogoutRedirectPath();
        if (this$postLogoutRedirectPath == null ? other$postLogoutRedirectPath != null : !((Object)this$postLogoutRedirectPath).equals(other$postLogoutRedirectPath)) {
            return false;
        }
        Map<String, OAuth2LogoutProperties> this$oauth2Logout = this.getOauth2Logout();
        Map<String, OAuth2LogoutProperties> other$oauth2Logout = other.getOauth2Logout();
        if (this$oauth2Logout == null ? other$oauth2Logout != null : !((Object)this$oauth2Logout).equals(other$oauth2Logout)) {
            return false;
        }
        List<String> this$permitAll = this.getPermitAll();
        List<String> other$permitAll = other.getPermitAll();
        if (this$permitAll == null ? other$permitAll != null : !((Object)this$permitAll).equals(other$permitAll)) {
            return false;
        }
        Csrf this$csrf = this.getCsrf();
        Csrf other$csrf = other.getCsrf();
        if (this$csrf == null ? other$csrf != null : !((Object)((Object)this$csrf)).equals((Object)other$csrf)) {
            return false;
        }
        List<CorsProperties> this$cors = this.getCors();
        List<CorsProperties> other$cors = other.getCors();
        if (this$cors == null ? other$cors != null : !((Object)this$cors).equals(other$cors)) {
            return false;
        }
        Map<String, List<RequestParam>> this$authorizationRequestParams = this.getAuthorizationRequestParams();
        Map<String, List<RequestParam>> other$authorizationRequestParams = other.getAuthorizationRequestParams();
        if (this$authorizationRequestParams == null ? other$authorizationRequestParams != null : !((Object)this$authorizationRequestParams).equals(other$authorizationRequestParams)) {
            return false;
        }
        Map<String, Map<String, List<String>>> this$authorizationParams = this.getAuthorizationParams();
        Map<String, Map<String, List<String>>> other$authorizationParams = other.getAuthorizationParams();
        if (this$authorizationParams == null ? other$authorizationParams != null : !((Object)this$authorizationParams).equals(other$authorizationParams)) {
            return false;
        }
        Map<String, List<RequestParam>> this$tokenRequestParams = this.getTokenRequestParams();
        Map<String, List<RequestParam>> other$tokenRequestParams = other.getTokenRequestParams();
        if (this$tokenRequestParams == null ? other$tokenRequestParams != null : !((Object)this$tokenRequestParams).equals(other$tokenRequestParams)) {
            return false;
        }
        Map<String, Map<String, List<String>>> this$tokenParams = this.getTokenParams();
        Map<String, Map<String, List<String>>> other$tokenParams = other.getTokenParams();
        if (this$tokenParams == null ? other$tokenParams != null : !((Object)this$tokenParams).equals(other$tokenParams)) {
            return false;
        }
        BackChannelLogoutProperties this$backChannelLogout = this.getBackChannelLogout();
        BackChannelLogoutProperties other$backChannelLogout = other.getBackChannelLogout();
        return !(this$backChannelLogout == null ? other$backChannelLogout != null : !((Object)this$backChannelLogout).equals(other$backChannelLogout));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpringAddonsOidcClientProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMultiTenancyEnabled() ? 79 : 97);
        result = result * 59 + (this.isPkceForced() ? 79 : 97);
        List<String> $securityMatchers = this.getSecurityMatchers();
        result = result * 59 + ($securityMatchers == null ? 43 : ((Object)$securityMatchers).hashCode());
        URI $clientUri = this.getClientUri();
        result = result * 59 + ($clientUri == null ? 43 : ((Object)$clientUri).hashCode());
        Optional<URI> $loginUri = this.getLoginUri();
        result = result * 59 + ($loginUri == null ? 43 : ((Object)$loginUri).hashCode());
        URI $postLoginRedirectHost = this.getPostLoginRedirectHost();
        result = result * 59 + ($postLoginRedirectHost == null ? 43 : ((Object)$postLoginRedirectHost).hashCode());
        Optional<String> $postLoginRedirectPath = this.getPostLoginRedirectPath();
        result = result * 59 + ($postLoginRedirectPath == null ? 43 : ((Object)$postLoginRedirectPath).hashCode());
        Optional<URI> $loginErrorRedirectPath = this.getLoginErrorRedirectPath();
        result = result * 59 + ($loginErrorRedirectPath == null ? 43 : ((Object)$loginErrorRedirectPath).hashCode());
        OAuth2RedirectionProperties $oauth2Redirections = this.getOauth2Redirections();
        result = result * 59 + ($oauth2Redirections == null ? 43 : ((Object)$oauth2Redirections).hashCode());
        URI $postLogoutRedirectHost = this.getPostLogoutRedirectHost();
        result = result * 59 + ($postLogoutRedirectHost == null ? 43 : ((Object)$postLogoutRedirectHost).hashCode());
        Optional<String> $postLogoutRedirectPath = this.getPostLogoutRedirectPath();
        result = result * 59 + ($postLogoutRedirectPath == null ? 43 : ((Object)$postLogoutRedirectPath).hashCode());
        Map<String, OAuth2LogoutProperties> $oauth2Logout = this.getOauth2Logout();
        result = result * 59 + ($oauth2Logout == null ? 43 : ((Object)$oauth2Logout).hashCode());
        List<String> $permitAll = this.getPermitAll();
        result = result * 59 + ($permitAll == null ? 43 : ((Object)$permitAll).hashCode());
        Csrf $csrf = this.getCsrf();
        result = result * 59 + ($csrf == null ? 43 : ((Object)((Object)$csrf)).hashCode());
        List<CorsProperties> $cors = this.getCors();
        result = result * 59 + ($cors == null ? 43 : ((Object)$cors).hashCode());
        Map<String, List<RequestParam>> $authorizationRequestParams = this.getAuthorizationRequestParams();
        result = result * 59 + ($authorizationRequestParams == null ? 43 : ((Object)$authorizationRequestParams).hashCode());
        Map<String, Map<String, List<String>>> $authorizationParams = this.getAuthorizationParams();
        result = result * 59 + ($authorizationParams == null ? 43 : ((Object)$authorizationParams).hashCode());
        Map<String, List<RequestParam>> $tokenRequestParams = this.getTokenRequestParams();
        result = result * 59 + ($tokenRequestParams == null ? 43 : ((Object)$tokenRequestParams).hashCode());
        Map<String, Map<String, List<String>>> $tokenParams = this.getTokenParams();
        result = result * 59 + ($tokenParams == null ? 43 : ((Object)$tokenParams).hashCode());
        BackChannelLogoutProperties $backChannelLogout = this.getBackChannelLogout();
        result = result * 59 + ($backChannelLogout == null ? 43 : ((Object)$backChannelLogout).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SpringAddonsOidcClientProperties(securityMatchers=" + this.getSecurityMatchers() + ", clientUri=" + this.getClientUri() + ", loginUri=" + this.getLoginUri() + ", postLoginRedirectHost=" + this.getPostLoginRedirectHost() + ", postLoginRedirectPath=" + this.getPostLoginRedirectPath() + ", loginErrorRedirectPath=" + this.getLoginErrorRedirectPath() + ", oauth2Redirections=" + this.getOauth2Redirections() + ", postLogoutRedirectHost=" + this.getPostLogoutRedirectHost() + ", postLogoutRedirectPath=" + this.getPostLogoutRedirectPath() + ", oauth2Logout=" + this.getOauth2Logout() + ", multiTenancyEnabled=" + this.isMultiTenancyEnabled() + ", permitAll=" + this.getPermitAll() + ", csrf=" + this.getCsrf() + ", pkceForced=" + this.isPkceForced() + ", cors=" + this.getCors() + ", authorizationRequestParams=" + this.getAuthorizationRequestParams() + ", authorizationParams=" + this.getAuthorizationParams() + ", tokenRequestParams=" + this.getTokenRequestParams() + ", tokenParams=" + this.getTokenParams() + ", backChannelLogout=" + this.getBackChannelLogout() + ")";
    }

    public static class RequestParam {
        private String name;
        private String value;

        @Generated
        public RequestParam() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setValue(String value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestParam)) {
                return false;
            }
            RequestParam other = (RequestParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RequestParam;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SpringAddonsOidcClientProperties.RequestParam(name=" + this.getName() + ", value=" + this.getValue() + ")";
        }
    }

    public static class OAuth2LogoutProperties {
        private URI uri;
        private Optional<String> clientIdRequestParam = Optional.empty();
        private Optional<String> postLogoutUriRequestParam = Optional.empty();
        private Optional<String> idTokenHintRequestParam = Optional.empty();
        private boolean enabled = true;

        @Generated
        public OAuth2LogoutProperties() {
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public Optional<String> getClientIdRequestParam() {
            return this.clientIdRequestParam;
        }

        @Generated
        public Optional<String> getPostLogoutUriRequestParam() {
            return this.postLogoutUriRequestParam;
        }

        @Generated
        public Optional<String> getIdTokenHintRequestParam() {
            return this.idTokenHintRequestParam;
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public void setUri(URI uri) {
            this.uri = uri;
        }

        @Generated
        public void setClientIdRequestParam(Optional<String> clientIdRequestParam) {
            this.clientIdRequestParam = clientIdRequestParam;
        }

        @Generated
        public void setPostLogoutUriRequestParam(Optional<String> postLogoutUriRequestParam) {
            this.postLogoutUriRequestParam = postLogoutUriRequestParam;
        }

        @Generated
        public void setIdTokenHintRequestParam(Optional<String> idTokenHintRequestParam) {
            this.idTokenHintRequestParam = idTokenHintRequestParam;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OAuth2LogoutProperties)) {
                return false;
            }
            OAuth2LogoutProperties other = (OAuth2LogoutProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            URI this$uri = this.getUri();
            URI other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
                return false;
            }
            Optional<String> this$clientIdRequestParam = this.getClientIdRequestParam();
            Optional<String> other$clientIdRequestParam = other.getClientIdRequestParam();
            if (this$clientIdRequestParam == null ? other$clientIdRequestParam != null : !((Object)this$clientIdRequestParam).equals(other$clientIdRequestParam)) {
                return false;
            }
            Optional<String> this$postLogoutUriRequestParam = this.getPostLogoutUriRequestParam();
            Optional<String> other$postLogoutUriRequestParam = other.getPostLogoutUriRequestParam();
            if (this$postLogoutUriRequestParam == null ? other$postLogoutUriRequestParam != null : !((Object)this$postLogoutUriRequestParam).equals(other$postLogoutUriRequestParam)) {
                return false;
            }
            Optional<String> this$idTokenHintRequestParam = this.getIdTokenHintRequestParam();
            Optional<String> other$idTokenHintRequestParam = other.getIdTokenHintRequestParam();
            return !(this$idTokenHintRequestParam == null ? other$idTokenHintRequestParam != null : !((Object)this$idTokenHintRequestParam).equals(other$idTokenHintRequestParam));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OAuth2LogoutProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            URI $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
            Optional<String> $clientIdRequestParam = this.getClientIdRequestParam();
            result = result * 59 + ($clientIdRequestParam == null ? 43 : ((Object)$clientIdRequestParam).hashCode());
            Optional<String> $postLogoutUriRequestParam = this.getPostLogoutUriRequestParam();
            result = result * 59 + ($postLogoutUriRequestParam == null ? 43 : ((Object)$postLogoutUriRequestParam).hashCode());
            Optional<String> $idTokenHintRequestParam = this.getIdTokenHintRequestParam();
            result = result * 59 + ($idTokenHintRequestParam == null ? 43 : ((Object)$idTokenHintRequestParam).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SpringAddonsOidcClientProperties.OAuth2LogoutProperties(uri=" + this.getUri() + ", clientIdRequestParam=" + this.getClientIdRequestParam() + ", postLogoutUriRequestParam=" + this.getPostLogoutUriRequestParam() + ", idTokenHintRequestParam=" + this.getIdTokenHintRequestParam() + ", enabled=" + this.isEnabled() + ")";
        }
    }

    public static class OAuth2RedirectionProperties {
        private HttpStatus authenticationEntryPoint = HttpStatus.FOUND;
        private HttpStatus preAuthorizationCode = HttpStatus.FOUND;
        private HttpStatus postAuthorizationCode = HttpStatus.FOUND;
        private HttpStatus postAuthorizationFailure = HttpStatus.FOUND;
        private HttpStatus rpInitiatedLogout = HttpStatus.FOUND;
        private HttpStatus invalidSessionStrategy = HttpStatus.FOUND;

        @Generated
        public OAuth2RedirectionProperties() {
        }

        @Generated
        public HttpStatus getAuthenticationEntryPoint() {
            return this.authenticationEntryPoint;
        }

        @Generated
        public HttpStatus getPreAuthorizationCode() {
            return this.preAuthorizationCode;
        }

        @Generated
        public HttpStatus getPostAuthorizationCode() {
            return this.postAuthorizationCode;
        }

        @Generated
        public HttpStatus getPostAuthorizationFailure() {
            return this.postAuthorizationFailure;
        }

        @Generated
        public HttpStatus getRpInitiatedLogout() {
            return this.rpInitiatedLogout;
        }

        @Generated
        public HttpStatus getInvalidSessionStrategy() {
            return this.invalidSessionStrategy;
        }

        @Generated
        public void setAuthenticationEntryPoint(HttpStatus authenticationEntryPoint) {
            this.authenticationEntryPoint = authenticationEntryPoint;
        }

        @Generated
        public void setPreAuthorizationCode(HttpStatus preAuthorizationCode) {
            this.preAuthorizationCode = preAuthorizationCode;
        }

        @Generated
        public void setPostAuthorizationCode(HttpStatus postAuthorizationCode) {
            this.postAuthorizationCode = postAuthorizationCode;
        }

        @Generated
        public void setPostAuthorizationFailure(HttpStatus postAuthorizationFailure) {
            this.postAuthorizationFailure = postAuthorizationFailure;
        }

        @Generated
        public void setRpInitiatedLogout(HttpStatus rpInitiatedLogout) {
            this.rpInitiatedLogout = rpInitiatedLogout;
        }

        @Generated
        public void setInvalidSessionStrategy(HttpStatus invalidSessionStrategy) {
            this.invalidSessionStrategy = invalidSessionStrategy;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OAuth2RedirectionProperties)) {
                return false;
            }
            OAuth2RedirectionProperties other = (OAuth2RedirectionProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            HttpStatus this$authenticationEntryPoint = this.getAuthenticationEntryPoint();
            HttpStatus other$authenticationEntryPoint = other.getAuthenticationEntryPoint();
            if (this$authenticationEntryPoint == null ? other$authenticationEntryPoint != null : !this$authenticationEntryPoint.equals(other$authenticationEntryPoint)) {
                return false;
            }
            HttpStatus this$preAuthorizationCode = this.getPreAuthorizationCode();
            HttpStatus other$preAuthorizationCode = other.getPreAuthorizationCode();
            if (this$preAuthorizationCode == null ? other$preAuthorizationCode != null : !this$preAuthorizationCode.equals(other$preAuthorizationCode)) {
                return false;
            }
            HttpStatus this$postAuthorizationCode = this.getPostAuthorizationCode();
            HttpStatus other$postAuthorizationCode = other.getPostAuthorizationCode();
            if (this$postAuthorizationCode == null ? other$postAuthorizationCode != null : !this$postAuthorizationCode.equals(other$postAuthorizationCode)) {
                return false;
            }
            HttpStatus this$postAuthorizationFailure = this.getPostAuthorizationFailure();
            HttpStatus other$postAuthorizationFailure = other.getPostAuthorizationFailure();
            if (this$postAuthorizationFailure == null ? other$postAuthorizationFailure != null : !this$postAuthorizationFailure.equals(other$postAuthorizationFailure)) {
                return false;
            }
            HttpStatus this$rpInitiatedLogout = this.getRpInitiatedLogout();
            HttpStatus other$rpInitiatedLogout = other.getRpInitiatedLogout();
            if (this$rpInitiatedLogout == null ? other$rpInitiatedLogout != null : !this$rpInitiatedLogout.equals(other$rpInitiatedLogout)) {
                return false;
            }
            HttpStatus this$invalidSessionStrategy = this.getInvalidSessionStrategy();
            HttpStatus other$invalidSessionStrategy = other.getInvalidSessionStrategy();
            return !(this$invalidSessionStrategy == null ? other$invalidSessionStrategy != null : !this$invalidSessionStrategy.equals(other$invalidSessionStrategy));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OAuth2RedirectionProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            HttpStatus $authenticationEntryPoint = this.getAuthenticationEntryPoint();
            result = result * 59 + ($authenticationEntryPoint == null ? 43 : $authenticationEntryPoint.hashCode());
            HttpStatus $preAuthorizationCode = this.getPreAuthorizationCode();
            result = result * 59 + ($preAuthorizationCode == null ? 43 : $preAuthorizationCode.hashCode());
            HttpStatus $postAuthorizationCode = this.getPostAuthorizationCode();
            result = result * 59 + ($postAuthorizationCode == null ? 43 : $postAuthorizationCode.hashCode());
            HttpStatus $postAuthorizationFailure = this.getPostAuthorizationFailure();
            result = result * 59 + ($postAuthorizationFailure == null ? 43 : $postAuthorizationFailure.hashCode());
            HttpStatus $rpInitiatedLogout = this.getRpInitiatedLogout();
            result = result * 59 + ($rpInitiatedLogout == null ? 43 : $rpInitiatedLogout.hashCode());
            HttpStatus $invalidSessionStrategy = this.getInvalidSessionStrategy();
            result = result * 59 + ($invalidSessionStrategy == null ? 43 : $invalidSessionStrategy.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SpringAddonsOidcClientProperties.OAuth2RedirectionProperties(authenticationEntryPoint=" + this.getAuthenticationEntryPoint() + ", preAuthorizationCode=" + this.getPreAuthorizationCode() + ", postAuthorizationCode=" + this.getPostAuthorizationCode() + ", postAuthorizationFailure=" + this.getPostAuthorizationFailure() + ", rpInitiatedLogout=" + this.getRpInitiatedLogout() + ", invalidSessionStrategy=" + this.getInvalidSessionStrategy() + ")";
        }
    }

    public static class BackChannelLogoutProperties {
        private boolean enabled = false;
        private Optional<String> internalLogoutUri = Optional.empty();
        private Optional<String> cookieName = Optional.empty();

        @Generated
        public BackChannelLogoutProperties() {
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public Optional<String> getInternalLogoutUri() {
            return this.internalLogoutUri;
        }

        @Generated
        public Optional<String> getCookieName() {
            return this.cookieName;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setInternalLogoutUri(Optional<String> internalLogoutUri) {
            this.internalLogoutUri = internalLogoutUri;
        }

        @Generated
        public void setCookieName(Optional<String> cookieName) {
            this.cookieName = cookieName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BackChannelLogoutProperties)) {
                return false;
            }
            BackChannelLogoutProperties other = (BackChannelLogoutProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            Optional<String> this$internalLogoutUri = this.getInternalLogoutUri();
            Optional<String> other$internalLogoutUri = other.getInternalLogoutUri();
            if (this$internalLogoutUri == null ? other$internalLogoutUri != null : !((Object)this$internalLogoutUri).equals(other$internalLogoutUri)) {
                return false;
            }
            Optional<String> this$cookieName = this.getCookieName();
            Optional<String> other$cookieName = other.getCookieName();
            return !(this$cookieName == null ? other$cookieName != null : !((Object)this$cookieName).equals(other$cookieName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BackChannelLogoutProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            Optional<String> $internalLogoutUri = this.getInternalLogoutUri();
            result = result * 59 + ($internalLogoutUri == null ? 43 : ((Object)$internalLogoutUri).hashCode());
            Optional<String> $cookieName = this.getCookieName();
            result = result * 59 + ($cookieName == null ? 43 : ((Object)$cookieName).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SpringAddonsOidcClientProperties.BackChannelLogoutProperties(enabled=" + this.isEnabled() + ", internalLogoutUri=" + this.getInternalLogoutUri() + ", cookieName=" + this.getCookieName() + ")";
        }
    }
}

