/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.synchronised;

import com.c4_soft.springaddons.security.oidc.starter.properties.CorsProperties;
import com.c4_soft.springaddons.security.oidc.starter.properties.Csrf;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.ExpressionInterceptUrlRegistryPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.ClientExpressionInterceptUrlRegistryPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.ClientSynchronizedHttpSecurityPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.resourceserver.ResourceServerExpressionInterceptUrlRegistryPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.resourceserver.ResourceServerSynchronizedHttpSecurityPostProcessor;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.csrf.XorCsrfTokenRequestAttributeHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.filter.OncePerRequestFilter;

public class ServletConfigurationSupport {
    public static HttpSecurity configureResourceServer(HttpSecurity http, ServerProperties serverProperties, SpringAddonsOidcProperties addonsProperties, ResourceServerExpressionInterceptUrlRegistryPostProcessor authorizePostProcessor, ResourceServerSynchronizedHttpSecurityPostProcessor httpPostProcessor) throws Exception {
        http.exceptionHandling(exceptions -> {
            String issuers = addonsProperties.getOps().stream().map(SpringAddonsOidcProperties.OpenidProviderProperties::getIss).filter(iss -> iss != null).map(URI::toString).collect(Collectors.joining(",", "\"", "\""));
            exceptions.authenticationEntryPoint((request, response, authException) -> {
                response.addHeader("WWW-Authenticate", "OAuth realm=%s".formatted(issuers));
                response.sendError(HttpStatus.UNAUTHORIZED.value(), HttpStatus.UNAUTHORIZED.getReasonPhrase());
            });
        });
        ServletConfigurationSupport.configureState(http, addonsProperties.getResourceserver().isStatlessSessions(), addonsProperties.getResourceserver().getCsrf());
        ArrayList<CorsProperties> corsProps = new ArrayList<CorsProperties>(addonsProperties.getCors());
        List<CorsProperties> deprecatedClientCorsProps = addonsProperties.getClient().getCors();
        List<CorsProperties> deprecatedResourceServerCorsProps = addonsProperties.getResourceserver().getCors();
        corsProps.addAll(deprecatedClientCorsProps);
        corsProps.addAll(deprecatedResourceServerCorsProps);
        ServletConfigurationSupport.configureAccess(http, addonsProperties.getResourceserver().getPermitAll(), corsProps, authorizePostProcessor);
        if (serverProperties.getSsl() != null && serverProperties.getSsl().isEnabled()) {
            http.requiresChannel(channel -> ((ChannelSecurityConfigurer.RequiresChannelUrl)channel.anyRequest()).requiresSecure());
        }
        return httpPostProcessor.process(http);
    }

    public static HttpSecurity configureClient(HttpSecurity http, ServerProperties serverProperties, SpringAddonsOidcProperties addonsProperties, ClientExpressionInterceptUrlRegistryPostProcessor authorizePostProcessor, ClientSynchronizedHttpSecurityPostProcessor httpPostProcessor) throws Exception {
        ServletConfigurationSupport.configureState(http, false, addonsProperties.getClient().getCsrf());
        ArrayList<CorsProperties> corsProps = new ArrayList<CorsProperties>(addonsProperties.getCors());
        List<CorsProperties> deprecatedClientCorsProps = addonsProperties.getClient().getCors();
        List<CorsProperties> deprecatedResourceServerCorsProps = addonsProperties.getResourceserver().getCors();
        corsProps.addAll(deprecatedClientCorsProps);
        corsProps.addAll(deprecatedResourceServerCorsProps);
        ServletConfigurationSupport.configureAccess(http, addonsProperties.getClient().getPermitAll(), corsProps, authorizePostProcessor);
        if (serverProperties.getSsl() != null && serverProperties.getSsl().isEnabled()) {
            http.requiresChannel(channel -> ((ChannelSecurityConfigurer.RequiresChannelUrl)channel.anyRequest()).requiresSecure());
        }
        return httpPostProcessor.process(http);
    }

    public static HttpSecurity configureAccess(HttpSecurity http, List<String> permitAll, List<CorsProperties> corsProperties, ExpressionInterceptUrlRegistryPostProcessor authorizePostProcessor) throws Exception {
        List<String> permittedCorsOptions = corsProperties.stream().filter(cors -> (cors.getAllowedMethods().contains("*") || cors.getAllowedMethods().contains("OPTIONS")) && !cors.isDisableAnonymousOptions()).map(CorsProperties::getPath).toList();
        if (permitAll.size() > 0 || permittedCorsOptions.size() > 0) {
            http.anonymous(Customizer.withDefaults());
        }
        if (permitAll.size() > 0) {
            http.authorizeHttpRequests(registry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)registry.requestMatchers((RequestMatcher[])permitAll.stream().map(AntPathRequestMatcher::new).toArray(AntPathRequestMatcher[]::new))).permitAll());
        }
        if (permittedCorsOptions.size() > 0) {
            http.authorizeHttpRequests(registry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)registry.requestMatchers((RequestMatcher[])permittedCorsOptions.stream().map(corsPathPattern -> new AntPathRequestMatcher(corsPathPattern, "OPTIONS")).toArray(AntPathRequestMatcher[]::new))).permitAll());
        }
        return http.authorizeHttpRequests(registry -> authorizePostProcessor.authorizeHttpRequests((AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry)registry));
    }

    public static CorsFilter getCorsFilterBean(List<CorsProperties> corsProperties) {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        for (CorsProperties corsProps : corsProperties) {
            CorsConfiguration configuration = new CorsConfiguration();
            configuration.setAllowCredentials(corsProps.getAllowCredentials());
            configuration.setAllowedHeaders(corsProps.getAllowedHeaders());
            configuration.setAllowedMethods(corsProps.getAllowedMethods());
            configuration.setAllowedOriginPatterns(corsProps.getAllowedOriginPatterns());
            configuration.setExposedHeaders(corsProps.getExposedHeaders());
            configuration.setMaxAge(corsProps.getMaxAge());
            source.registerCorsConfiguration(corsProps.getPath(), configuration);
        }
        return new CorsFilter((CorsConfigurationSource)source);
    }

    public static HttpSecurity configureState(HttpSecurity http, boolean isStatless, Csrf csrfEnum) throws Exception {
        if (isStatless) {
            http.sessionManagement(sm -> sm.sessionCreationPolicy(SessionCreationPolicy.STATELESS));
        }
        http.csrf(configurer -> {
            switch (csrfEnum) {
                case DISABLE: {
                    configurer.disable();
                    break;
                }
                case DEFAULT: {
                    if (!isStatless) break;
                    configurer.disable();
                    break;
                }
                case SESSION: {
                    break;
                }
                case COOKIE_ACCESSIBLE_FROM_JS: {
                    configurer.csrfTokenRepository((CsrfTokenRepository)CookieCsrfTokenRepository.withHttpOnlyFalse()).csrfTokenRequestHandler((CsrfTokenRequestHandler)new SpaCsrfTokenRequestHandler());
                    http.addFilterAfter((Filter)new CsrfCookieFilter(), BasicAuthenticationFilter.class);
                }
            }
        });
        return http;
    }

    static final class SpaCsrfTokenRequestHandler
    extends CsrfTokenRequestAttributeHandler {
        private final CsrfTokenRequestHandler delegate = new XorCsrfTokenRequestAttributeHandler();

        SpaCsrfTokenRequestHandler() {
        }

        public void handle(HttpServletRequest request, HttpServletResponse response, Supplier<CsrfToken> csrfToken) {
            this.delegate.handle(request, response, csrfToken);
        }

        public String resolveCsrfTokenValue(HttpServletRequest request, CsrfToken csrfToken) {
            String csrfHeader = request.getHeader(csrfToken.getHeaderName());
            if (StringUtils.hasText((String)csrfHeader)) {
                return csrfHeader;
            }
            return this.delegate.resolveCsrfTokenValue(request, csrfToken);
        }
    }

    static final class CsrfCookieFilter
    extends OncePerRequestFilter {
        CsrfCookieFilter() {
        }

        protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
            CsrfToken csrfToken = (CsrfToken)request.getAttribute("_csrf");
            csrfToken.getToken();
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

